/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.calcite.CalciteParser;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.executor.StreamExecutor;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionConverter$;
import org.apache.flink.table.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SelectSinkOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.plan.StreamOptimizer;
import org.apache.flink.table.plan.nodes.LogicalSink;
import org.apache.flink.table.plan.nodes.LogicalSink$;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.planner.ParserImpl;
import org.apache.flink.table.planner.PlanningConfigurationBuilder;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.DataStreamTableSink;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.StreamSelectTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.TableSinkUtils$;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.util.DummyStreamExecutionEnvironment;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001B\u0001\u0003\u00015\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!\u0002Z3mK\u001e\fG/[8o\u0013\tY\u0002DA\u0004QY\u0006tg.\u001a:\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/}I!\u0001\t\r\u0003\u0011\u0015CXmY;u_JD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007G>tg-[4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011aA1qS&\u0011\u0001&\n\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001M\u0017\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000fG\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s!\taC'\u0003\u00026[\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\b\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\bF\u0003:wqjd\b\u0005\u0002;\u00015\t!\u0001C\u0003\u001em\u0001\u0007a\u0004C\u0003#m\u0001\u00071\u0005C\u0003+m\u0001\u00071\u0006C\u00033m\u0001\u00071\u0007C\u0004A\u0001\t\u0007I\u0011B!\u0002\u001d%tG/\u001a:oC2\u001c6\r[3nCV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!!\u000e\u001a2d\u0015\t9\u0005\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005%#%!D\"bY\u000eLG/Z*dQ\u0016l\u0017\r\u0003\u0004L\u0001\u0001\u0006IAQ\u0001\u0010S:$XM\u001d8bYN\u001b\u0007.Z7bA!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001E3yaJ,7o]5p]\n\u0013\u0018\u000eZ4f+\u0005y\u0005c\u0001)T+6\t\u0011K\u0003\u0002S\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t!\u0016K\u0001\tFqB\u0014Xm]:j_:\u0014%/\u001b3hKB\u0011\u0001KV\u0005\u0003/F\u0013\u0011\u0003\u00157b]:,'/\u0012=qe\u0016\u001c8/[8o\u0011\u0019I\u0006\u0001)A\u0005\u001f\u0006\tR\r\u001f9sKN\u001c\u0018n\u001c8Ce&$w-\u001a\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006a\u0002\u000f\\1o]&twmQ8oM&<WO]1uS>t')^5mI\u0016\u0014X#A/\u0011\u0005ir\u0016BA0\u0003\u0005q\u0001F.\u00198oS:<7i\u001c8gS\u001e,(/\u0019;j_:\u0014U/\u001b7eKJDa!\u0019\u0001!\u0002\u0013i\u0016!\b9mC:t\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\"vS2$WM\u001d\u0011\t\u0011\r\u0004!\u0019!C\u0001\r\u0011\f\u0011b\u001c9uS6L'0\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0003\u0002\tAd\u0017M\\\u0005\u0003U\u001e\u0014qb\u0015;sK\u0006lw\n\u001d;j[&TXM\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011B3\u0002\u0015=\u0004H/[7ju\u0016\u0014\b\u0005\u000b\u0002l]B\u0011qN]\u0007\u0002a*\u0011\u0011OB\u0001\u000bC:tw\u000e^1uS>t\u0017BA:q\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0003\u0019\u0001\u0018M]:feV\tq\u000f\u0005\u0002\u0018q&\u0011\u0011\u0010\u0007\u0002\u0007!\u0006\u00148/\u001a:\t\rm\u0004\u0001\u0015!\u0003x\u0003\u001d\u0001\u0018M]:fe\u0002BQ! \u0001\u0005By\f\u0011bZ3u!\u0006\u00148/\u001a:\u0015\u0003]Dq!!\u0001\u0001\t\u0003\n\u0019!A\u0005ue\u0006t7\u000f\\1uKR!\u0011QAA\u001f!\u0019\t9!!\u0004\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0011\u0012\u0001B;uS2LA!a\u0004\u0002\n\t!A*[:ua\u0011\t\u0019\"!\n\u0011\r\u0005U\u0011QDA\u0011\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011a\u00013bO*\u0011aEB\u0005\u0005\u0003?\t9B\u0001\bUe\u0006t7OZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t-\t9c`A\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#\u0013'\u0005\u0003\u0002,\u0005]\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0005\u0005E\u0012!B:dC2\f\u0017\u0002BA\u001b\u0003_\u0011qAT8uQ&tw\r\u0005\u0003\u0002.\u0005e\u0012\u0002BA\u001e\u0003_\u00111!\u00118z\u0011\u001d\tyd a\u0001\u0003\u0003\nq\u0002^1cY\u0016|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003\u000f\ti!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0005\u0003)y\u0007/\u001a:bi&|gn]\u0005\u0005\u0003\u001b\n9EA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011\u001d\t\t\u0006\u0001C!\u0003'\nq!\u001a=qY\u0006Lg\u000e\u0006\u0004\u0002V\u0005-\u0014Q\u000f\t\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005\u0005\u0004\u0003BA.\u0003_i!!!\u0018\u000b\u0007\u0005}C\"\u0001\u0004=e>|GOP\u0005\u0005\u0003G\ny#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\nIG\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003G\ny\u0003\u0003\u0005\u0002J\u0005=\u0003\u0019AA7!\u0019\t9!!\u0004\u0002pA!\u0011QIA9\u0013\u0011\t\u0019(a\u0012\u0003\u0013=\u0003XM]1uS>t\u0007\u0002CA<\u0003\u001f\u0002\r!!\u001f\u0002\u0019\u0015DHO]1EKR\f\u0017\u000e\\:\u0011\r\u00055\u00121PA@\u0013\u0011\ti(a\f\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002%\u0003\u0003K1!a!&\u00055)\u0005\u0010\u001d7bS:$U\r^1jY\"9\u0011q\u0011\u0001\u0005B\u0005%\u0015AE4fi\u000e{W\u000e\u001d7fi&|g\u000eS5oiN$b!a#\u0002\u0012\u0006U\u0005CBA\u0017\u0003\u001b\u000b)&\u0003\u0003\u0002\u0010\u0006=\"!B!se\u0006L\b\u0002CAJ\u0003\u000b\u0003\r!!\u0016\u0002\u0013M$\u0018\r^3nK:$\b\u0002CAL\u0003\u000b\u0003\r!!'\u0002\u0011A|7/\u001b;j_:\u0004B!!\f\u0002\u001c&!\u0011QTA\u0018\u0005\rIe\u000e\u001e\u0005\b\u0003C\u0003A\u0011BAR\u00039!(/\u00198tY\u0006$X\rV8SK2$B!!*\u0002>BA\u0011QFAT\u0003W\u000b9,\u0003\u0003\u0002*\u0006=\"A\u0002+va2,'\u0007\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\tLR\u0001\u0004e\u0016d\u0017\u0002BA[\u0003_\u0013qAU3m\u001d>$W\r\u0005\u0003\u0002.\u0005e\u0016\u0002BA^\u0003_\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002@\u0006}\u0005\u0019AA\"\u0003=iw\u000eZ5gs>\u0003XM]1uS>t\u0007bBAb\u0001\u0011%\u0011QY\u0001\u0010O\u0016$h\t\\5oWBc\u0017M\u001c8feV\u0011\u0011q\u0019\t\u0005\u0003\u0013\fi-\u0004\u0002\u0002L*\u0011q\tB\u0005\u0005\u0003\u001f\fYM\u0001\tGY&t7\u000e\u00157b]:,'/S7qY\"A\u00111\u001b\u0001\u0005\u0002\u0019\t).A\u0007hKR\u0014V\r\u001c\"vS2$WM]\u000b\u0003\u0003/\u0004B!!3\u0002Z&!\u00111\\Af\u0005=1E.\u001b8l%\u0016d')^5mI\u0016\u0014\b\u0002CAp\u0001\u0011\u0005a!!9\u0002\u0013\u001d,GoQ8oM&<W#A\u0012\t\u0011\u0005\u0015\b\u0001\"\u0001\u0007\u0003O\fqcZ3u\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\u0016\u0005\u0005%\b\u0003BAv\u0003ol!!!<\u000b\t\u0005=\u0018\u0011_\u0001\fK:4\u0018N]8o[\u0016tGOC\u0002'\u0003gT1!!>\u0007\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002z\u00065(AG*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$\bbBA\u007f\u0001\u0011%\u0011q`\u0001\u0010iJ\fgn\u001d7bi\u0016$vn\u0011*poR1!\u0011\u0001B\u000f\u0005?\u0001bAa\u0001\u0003\n\t5QB\u0001B\u0003\u0015\u0011\u00119!!=\u0002\u0015\u0011\fG/Y:ue\u0016\fW.\u0003\u0003\u0003\f\t\u0015!A\u0003#bi\u0006\u001cFO]3b[B!!q\u0002B\r\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\tU\u0011!\u0002;za\u0016\u001c(b\u0001B\f\t\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u000e\u0005#\u0011Aa\u0011*po\"11!a?A\u0002eB\u0001B!\t\u0002|\u0002\u0007\u00111V\u0001\fY><\u0017nY1m!2\fg\u000eC\u0004\u0003&\u0001!IAa\n\u0002\u0017]\u0014\u0018\u000e^3U_NKgn[\u000b\u0005\u0005S\u00119\u0005\u0006\u0005\u0002&\n-\"Q\u0007B&\u0011!\u0011iCa\tA\u0002\t=\u0012A\u0004;bE2,w\n]3sCRLwN\u001c\t\u0005\u0003\u000b\u0012\t$\u0003\u0003\u00034\u0005\u001d#AD)vKJLx\n]3sCRLwN\u001c\u0005\t\u0005o\u0011\u0019\u00031\u0001\u0003:\u0005!1/\u001b8l!\u0019\u0011YD!\u0011\u0003F5\u0011!Q\b\u0006\u0004\u0005\u007f!\u0011!B:j].\u001c\u0018\u0002\u0002B\"\u0005{\u0011\u0011\u0002V1cY\u0016\u001c\u0016N\\6\u0011\t\u0005\r\"q\t\u0003\t\u0005\u0013\u0012\u0019C1\u0001\u0002*\t\tA\u000b\u0003\u0005\u0003N\t\r\u0002\u0019AA+\u0003!\u0019\u0018N\\6OC6,\u0007b\u0002B)\u0001\u0011%!1K\u0001\rO\u0016$H+\u00192mKNKgn\u001b\u000b\u0005\u0005+\u0012)\u0007\u0005\u0004\u0002.\t]#1L\u0005\u0005\u00053\nyC\u0001\u0004PaRLwN\u001c\u0019\u0005\u0005;\u0012\t\u0007\u0005\u0004\u0003<\t\u0005#q\f\t\u0005\u0003G\u0011\t\u0007\u0002\u0007\u0003d\t=\u0013\u0011!A\u0001\u0006\u0003\tICA\u0002`IMB\u0001Ba\u001a\u0003P\u0001\u0007!\u0011N\u0001\u0011_\nTWm\u0019;JI\u0016tG/\u001b4jKJ\u00042\u0001\fB6\u0013\r\u0011i'\f\u0002\u0011\u001f\nTWm\u0019;JI\u0016tG/\u001b4jKJDqA!\u001d\u0001\t\u0013\u0011\u0019(\u0001\nde\u0016\fG/\u001a#v[6L\b\u000b\\1o]\u0016\u0014H#A\u001d")
public class StreamPlanner
implements Planner {
    private final Executor executor;
    private final TableConfig config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final CalciteSchema internalSchema;
    private final ExpressionBridge<PlannerExpression> expressionBridge;
    private final PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    @VisibleForTesting
    private final StreamOptimizer optimizer;
    private final Parser parser;

    private CalciteSchema internalSchema() {
        return this.internalSchema;
    }

    private ExpressionBridge<PlannerExpression> expressionBridge() {
        return this.expressionBridge;
    }

    public PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder() {
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    }

    public StreamOptimizer optimizer() {
        return this.optimizer;
    }

    private Parser parser() {
        return this.parser;
    }

    @Override
    public Parser getParser() {
        return this.parser();
    }

    @Override
    public List<Transformation<?>> translate(List<ModifyOperation> tableOperations) {
        StreamPlanner planner = this.createDummyPlanner();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableOperations).asScala()).map((Function1 & Serializable & scala.Serializable)operation -> {
            Tuple2<RelNode, Object> tuple2 = this.translateToRel((ModifyOperation)operation);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RelNode ast = (RelNode)tuple2._1();
            boolean updatesAsRetraction = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)ast, (Object)BoxesRunTime.boxToBoolean((boolean)updatesAsRetraction));
            Tuple2 tuple23 = tuple22;
            RelNode ast2 = (RelNode)tuple23._1();
            boolean updatesAsRetraction2 = tuple23._2$mcZ$sp();
            RelNode optimizedPlan = this.optimizer().optimize(ast2, updatesAsRetraction2, this.getRelBuilder());
            DataStream<CRow> dataStream = this.translateToCRow(planner, optimizedPlan);
            return dataStream.getTransformation();
        }, Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamPlanner.$anonfun$translate$2(x$1)))).asJava();
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        Buffer astWithUpdatesAsRetractionTuples = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2<RelNode, Object> tuple2;
            Operation operation = x0$1;
            if (operation instanceof QueryOperation) {
                Tuple2<RelNode, Object> tuple22;
                QueryOperation queryOperation = (QueryOperation)operation;
                RelNode relNode = this.getRelBuilder().tableOperation(queryOperation).build();
                RelNode relNode2 = relNode;
                if (relNode2 instanceof LogicalTableModify) {
                    LogicalTableModify logicalTableModify = (LogicalTableModify)relNode2;
                    List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                    Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0 & Serializable & scala.Serializable)() -> "the length of qualified name should be 3.");
                    CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of(qualifiedName.get(0), qualifiedName.get(1), qualifiedName.get(2)), new PlannerQueryOperation(logicalTableModify.getInput()));
                    tuple22 = this.translateToRel(modifyOperation);
                } else {
                    tuple22 = new Tuple2<RelNode, Object>((Object)relNode, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                tuple2 = tuple22;
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                tuple2 = this.translateToRel(modifyOperation);
            } else {
                throw new TableException(new StringBuilder(23).append("Unsupported operation: ").append(operation.getClass().getCanonicalName()).toString());
            }
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)astWithUpdatesAsRetractionTuples.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RelNode ast = (RelNode)tuple2._1();
            boolean updatesAsRetraction = tuple2._2$mcZ$sp();
            RelNode relNode = this.optimizer().optimize(ast, updatesAsRetraction, this.getRelBuilder());
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        StreamPlanner planner = this.createDummyPlanner();
        Buffer dataStreams = (Buffer)optimizedNodes.map((Function1 & Serializable & scala.Serializable)p -> this.translateToCRow(planner, (RelNode)p), Buffer$.MODULE$.canBuildFrom());
        String astPlan = ((TraversableOnce)astWithUpdatesAsRetractionTuples.map((Function1 & Serializable & scala.Serializable)p -> RelOptUtil.toString((RelNode)p._1()), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        String optimizedPlan = ((TraversableOnce)optimizedNodes.map((Function1 & Serializable & scala.Serializable)x$1 -> RelOptUtil.toString(x$1), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        StreamExecutionEnvironment env = ((DataStream)dataStreams.head()).getExecutionEnvironment();
        String jsonSqlPlan = env.getExecutionPlan();
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jsonSqlPlan, Predef$.MODULE$.boolean2Boolean(false));
        return new StringBuilder(83).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(String.valueOf(astPlan)).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(String.valueOf(optimizedPlan)).append(System.lineSeparator()).append("== Physical Execution Plan ==").append(System.lineSeparator()).append(String.valueOf(sqlPlan)).toString();
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        FlinkPlannerImpl planner = this.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
        return planner.getCompletionHints(statement, position);
    }

    private Tuple2<RelNode, Object> translateToRel(ModifyOperation modifyOperation) {
        Tuple2 tuple2;
        ModifyOperation modifyOperation2 = modifyOperation;
        if (modifyOperation2 instanceof UnregisteredSinkModifyOperation) {
            UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
            tuple2 = this.writeToSink(unregisteredSinkModifyOperation.getChild(), unregisteredSinkModifyOperation.getSink(), "UnregisteredSink");
        } else if (modifyOperation2 instanceof SelectSinkOperation) {
            SelectSinkOperation selectSinkOperation = (SelectSinkOperation)modifyOperation2;
            StreamSelectTableSink sink2 = new StreamSelectTableSink(selectSinkOperation.getChild().getTableSchema());
            selectSinkOperation.setSelectResultProvider(sink2.getSelectResultProvider());
            tuple2 = this.writeToSink(selectSinkOperation.getChild(), sink2, "collect");
        } else if (modifyOperation2 instanceof CatalogSinkModifyOperation) {
            Tuple2 t;
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
            Option option = this.getTableSink(catalogSinkModifyOperation.getTableIdentifier()).map((Function1 & Serializable & scala.Serializable)sink -> {
                TableSinkUtils$.MODULE$.validateSink(catalogSinkModifyOperation.getStaticPartitions(), catalogSinkModifyOperation.getChild(), catalogSinkModifyOperation.getTableIdentifier(), (TableSink<?>)sink);
                TableSink tableSink = sink;
                if (tableSink instanceof PartitionableTableSink) {
                    PartitionableTableSink partitionableTableSink = (PartitionableTableSink)((Object)tableSink);
                    partitionableTableSink.setStaticPartition(catalogSinkModifyOperation.getStaticPartitions());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                TableSink tableSink2 = sink;
                if (tableSink2 instanceof OverwritableTableSink) {
                    OverwritableTableSink overwritableTableSink = (OverwritableTableSink)((Object)tableSink2);
                    overwritableTableSink.setOverwrite(catalogSinkModifyOperation.isOverwrite());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Predef$.MODULE$.assert(!catalogSinkModifyOperation.isOverwrite(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("INSERT OVERWRITE requires ").append(new StringBuilder(18).append(OverwritableTableSink.class.getSimpleName()).append(" but actually got ").toString()).append(sink.getClass().getName()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return this.writeToSink(catalogSinkModifyOperation.getChild(), (TableSink)sink, catalogSinkModifyOperation.getTableIdentifier().asSummaryString());
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TableException(new StringBuilder(21).append("Sink ").append(catalogSinkModifyOperation.getTableIdentifier()).append(" does not exists").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Tuple2 tuple22 = t = (Tuple2)some.value();
            tuple2 = tuple22;
        } else if (modifyOperation2 instanceof OutputConversionModifyOperation) {
            Tuple2.mcZZ.sp sp2;
            OutputConversionModifyOperation outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
            OutputConversionModifyOperation.UpdateMode updateMode = outputConversionModifyOperation.getUpdateMode();
            if (((Object)((Object)OutputConversionModifyOperation.UpdateMode.RETRACT)).equals((Object)updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (((Object)((Object)OutputConversionModifyOperation.UpdateMode.APPEND)).equals((Object)updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, false);
            } else if (((Object)((Object)OutputConversionModifyOperation.UpdateMode.UPSERT)).equals((Object)updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, true);
            } else {
                throw new MatchError((Object)updateMode);
            }
            Tuple2.mcZZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            boolean isRetract = sp3._1$mcZ$sp();
            boolean withChangeFlag = sp3._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(isRetract, withChangeFlag);
            Tuple2.mcZZ.sp sp5 = sp4;
            boolean isRetract2 = sp5._1$mcZ$sp();
            boolean withChangeFlag2 = sp5._2$mcZ$sp();
            DataStreamTableSink tableSink = new DataStreamTableSink(outputConversionModifyOperation.getChild().getTableSchema(), TypeConversions.fromDataTypeToLegacyInfo(outputConversionModifyOperation.getType()), withChangeFlag2);
            RelNode input = this.getRelBuilder().tableOperation(modifyOperation.getChild()).build();
            LogicalSink sink3 = LogicalSink$.MODULE$.create(input, tableSink, "DataStreamTableSink");
            tuple2 = new Tuple2((Object)sink3, (Object)BoxesRunTime.boxToBoolean((boolean)isRetract2));
        } else {
            throw new TableException(new StringBuilder(29).append("Unsupported ModifyOperation: ").append(modifyOperation).toString());
        }
        return tuple2;
    }

    public FlinkPlannerImpl org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createRelBuilder(currentCatalogName, currentDatabase);
    }

    public TableConfig getConfig() {
        return this.config;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return ((StreamExecutor)this.executor).getExecutionEnvironment();
    }

    private DataStream<CRow> translateToCRow(StreamPlanner planner, RelNode logicalPlan) {
        RelNode relNode = logicalPlan;
        if (!(relNode instanceof DataStreamRel)) {
            throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
        }
        DataStreamRel dataStreamRel = (DataStreamRel)relNode;
        this.getExecutionEnvironment().configure((ReadableConfig)this.config.getConfiguration(), Thread.currentThread().getContextClassLoader());
        DataStream<CRow> dataStream = dataStreamRel.translateToPlan(planner);
        return dataStream;
    }

    private <T> Tuple2<RelNode, Object> writeToSink(QueryOperation tableOperation, TableSink<T> sink, String sinkName) {
        boolean bl;
        TableSink<T> tableSink = sink;
        if (tableSink instanceof RetractStreamTableSink) {
            RetractStreamTableSink retractStreamTableSink = (RetractStreamTableSink)tableSink;
            RetractStreamTableSink retractStreamTableSink2 = retractStreamTableSink;
            if (retractStreamTableSink2 instanceof PartitionableTableSink) {
                throw new TableException("Partitionable sink in retract stream mode is not supported yet!");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            bl = true;
        } else if (tableSink instanceof UpsertStreamTableSink) {
            UpsertStreamTableSink upsertStreamTableSink = (UpsertStreamTableSink)tableSink;
            UpsertStreamTableSink upsertStreamTableSink2 = upsertStreamTableSink;
            if (upsertStreamTableSink2 instanceof PartitionableTableSink) {
                throw new TableException("Partitionable sink in upsert stream mode is not supported yet!");
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            bl = false;
        } else if (tableSink instanceof AppendStreamTableSink) {
            bl = false;
        } else {
            throw new ValidationException("Stream Tables can only be emitted by AppendStreamTableSink, RetractStreamTableSink, or UpsertStreamTableSink.");
        }
        boolean updatesAsRetraction = bl;
        RelNode input = this.getRelBuilder().tableOperation(tableOperation).build();
        return new Tuple2((Object)LogicalSink$.MODULE$.create(input, sink, sinkName), (Object)BoxesRunTime.boxToBoolean((boolean)updatesAsRetraction));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<TableSink<?>> getTableSink(ObjectIdentifier objectIdentifier) {
        Option<CatalogManager.TableLookupResult> lookupResult = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager.getTable(objectIdentifier));
        boolean bl = false;
        Some some = null;
        Option option = lookupResult.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getTable());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CatalogBaseTable s = (CatalogBaseTable)some.value();
            if (s instanceof ConnectorCatalogTable) {
                return JavaScalaConversionUtil$.MODULE$.toScala(((ConnectorCatalogTable)s).getTableSink());
            }
        }
        if (!bl) return None$.MODULE$;
        CatalogBaseTable s = (CatalogBaseTable)some.value();
        if (!(s instanceof CatalogTable)) return None$.MODULE$;
        Optional<Catalog> catalog = this.catalogManager.getCatalog(objectIdentifier.getCatalogName());
        CatalogTable catalogTable = (CatalogTable)s;
        TableSinkFactoryContextImpl context = new TableSinkFactoryContextImpl(objectIdentifier, catalogTable, (ReadableConfig)this.config.getConfiguration(), false, ((CatalogManager.TableLookupResult)lookupResult.get()).isTemporary());
        if (!catalog.isPresent()) return Option$.MODULE$.apply(TableFactoryUtil.findAndCreateTableSink(context));
        if (!catalog.get().getTableFactory().isPresent()) return Option$.MODULE$.apply(TableFactoryUtil.findAndCreateTableSink(context));
        Optional<TableSink> sink = TableFactoryUtil.createTableSinkForCatalogTable(catalog.get(), context);
        if (!sink.isPresent()) return Option$.MODULE$.apply(TableFactoryUtil.findAndCreateTableSink(context));
        return Option$.MODULE$.apply((Object)sink.get());
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecutionEnvironment());
        StreamExecutor executor = new StreamExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.config, this.functionCatalog, this.catalogManager);
    }

    @Override
    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public static final /* synthetic */ boolean $anonfun$translate$2(Object x$1) {
        return Objects.nonNull(x$1);
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.executor = executor;
        this.config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.internalSchema = CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, config, true));
        this.expressionBridge = new ExpressionBridge<PlannerExpression>(PlannerExpressionConverter$.MODULE$.INSTANCE());
        this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder = new PlanningConfigurationBuilder(config, functionCatalog, this.internalSchema(), this.expressionBridge());
        this.optimizer = new StreamOptimizer((Function0<CalciteConfig>)(Function0 & Serializable & scala.Serializable)() -> $this.config.getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT()), this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder());
        this.parser = new ParserImpl(catalogManager, new Supplier<FlinkPlannerImpl>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public FlinkPlannerImpl get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Supplier<CalciteParser>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public CalciteParser get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createCalciteParser();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

