/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.util.InputRefVisitor;
import org.apache.flink.table.plan.util.RefFieldAccessorVisitor;
import org.apache.flink.table.plan.util.RexNodeToExpressionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class RexProgramExtractor$ {
    public static RexProgramExtractor$ MODULE$;
    private Logger LOG;
    private volatile boolean bitmap$0;

    static {
        new RexProgramExtractor$();
    }

    private Logger LOG$lzycompute() {
        RexProgramExtractor$ rexProgramExtractor$ = this;
        synchronized (rexProgramExtractor$) {
            if (!this.bitmap$0) {
                this.LOG = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
        }
        return this.LOG;
    }

    public Logger LOG() {
        return !this.bitmap$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public int[] extractRefInputFields(RexProgram rexProgram) {
        InputRefVisitor visitor = new InputRefVisitor();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexProgram.getProjectList()).foreach((Function1 & Serializable & scala.Serializable)exp -> {
            RexProgramExtractor$.$anonfun$extractRefInputFields$1(rexProgram, visitor, exp);
            return BoxedUnit.UNIT;
        });
        RexLocalRef condition = rexProgram.getCondition();
        BoxedUnit boxedUnit = condition != null ? rexProgram.expandLocalRef(condition).accept(visitor) : BoxedUnit.UNIT;
        return visitor.getFields();
    }

    public Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexProgram rexProgram, RexBuilder rexBuilder, FunctionCatalog catalog) {
        Tuple2 tuple2;
        RexLocalRef rexLocalRef = rexProgram.getCondition();
        if (rexLocalRef != null) {
            RexLocalRef rexLocalRef2 = rexLocalRef;
            RexNode expanded = rexProgram.expandLocalRef(rexLocalRef2);
            SqlKind sqlKind = expanded.getKind();
            SqlKind sqlKind2 = SqlKind.SEARCH;
            RexNode rewrite = !(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)sqlKind2) : sqlKind2 != null) ? RexUtil.expandSearch(rexBuilder, null, expanded) : expanded;
            RexNode cnf = RexUtil.toCnf(rexBuilder, rewrite);
            List<RexNode> conjunctions = RelOptUtil.conjunctions(cnf);
            ArrayBuffer convertedExpressions = new ArrayBuffer();
            ArrayBuffer unconvertedRexNodes = new ArrayBuffer();
            String[] inputNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rexProgram.getInputRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(rexBuilder, inputNames, catalog);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(conjunctions).asScala()).foreach((Function1 & Serializable & scala.Serializable)rex -> {
                ArrayBuffer arrayBuffer;
                Option<Expression> option = rex.accept(converter);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression expression = (Expression)some.value();
                    arrayBuffer = convertedExpressions.$plus$eq((Object)expression);
                } else if (None$.MODULE$.equals(option)) {
                    arrayBuffer = unconvertedRexNodes.$plus$eq(rex);
                } else {
                    throw new MatchError(option);
                }
                return arrayBuffer;
            });
            tuple2 = new Tuple2(convertedExpressions.toArray(ClassTag$.MODULE$.apply(Expression.class)), unconvertedRexNodes.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
        } else {
            tuple2 = new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Expression.class)), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RexNode.class)));
        }
        return tuple2;
    }

    public String[][] extractRefNestedInputFields(RexProgram rexProgram, int[] usedFields) {
        RefFieldAccessorVisitor visitor = new RefFieldAccessorVisitor(usedFields);
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexProgram.getProjectList()).foreach((Function1 & Serializable & scala.Serializable)exp -> {
            RexProgramExtractor$.$anonfun$extractRefNestedInputFields$1(rexProgram, visitor, exp);
            return BoxedUnit.UNIT;
        });
        RexLocalRef condition = rexProgram.getCondition();
        BoxedUnit boxedUnit = condition != null ? rexProgram.expandLocalRef(condition).accept(visitor) : BoxedUnit.UNIT;
        return visitor.getProjectedFields();
    }

    public static final /* synthetic */ void $anonfun$extractRefInputFields$1(RexProgram rexProgram$1, InputRefVisitor visitor$1, RexLocalRef exp) {
        rexProgram$1.expandLocalRef(exp).accept(visitor$1);
    }

    public static final /* synthetic */ void $anonfun$extractRefNestedInputFields$1(RexProgram rexProgram$2, RefFieldAccessorVisitor visitor$2, RexLocalRef exp) {
        rexProgram$2.expandLocalRef(exp).accept(visitor$2);
    }

    private RexProgramExtractor$() {
        MODULE$ = this;
    }
}

