/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001E\u0011\u0011\u0005U;tQ\u001aKG\u000e^3s\u0013:$x\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016T!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t9QC\u0003\u0002\u0017\u0019\u000591-\u00197dSR,\u0017B\u0001\r\u0015\u0005)\u0011V\r\\(qiJ+H.\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAqa\b\u0001C\u0002\u0013%\u0001%A\u0006uC\ndWmQ8oM&<W#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011B\u0011aA1qS&\u0011ae\t\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0004)\u0001\u0001\u0006I!I\u0001\ri\u0006\u0014G.Z\"p]\u001aLw\r\t\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u00039!WMZ1vYR\u001c\u0015\r^1m_\u001e,\u0012\u0001\f\t\u0003[Ij\u0011A\f\u0006\u0003_A\nA\u0001\\1oO*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005\u0019\u0019FO]5oO\"1Q\u0007\u0001Q\u0001\n1\nq\u0002Z3gCVdGoQ1uC2|w\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y!\tqaY1uC2|w-\u0003\u0002?w\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\bB\u0002!\u0001A\u0003%\u0011(A\bdCR\fGn\\4NC:\fw-\u001a:!\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003\u001di\u0017\r^2iKN$\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000f\t{w\u000e\\3b]\")1*\u0011a\u0001\u0019\u0006!1-\u00197m!\t\u0019R*\u0003\u0002O)\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"\u0002)\u0001\t\u0003\n\u0016aB8o\u001b\u0006$8\r\u001b\u000b\u0003%V\u0003\"!R*\n\u0005Q3%\u0001B+oSRDQaS(A\u00021CQa\u0016\u0001\u0005\na\u000b!\u0003];tQ\u001aKG\u000e^3s\u0013:$xnU2b]R1!+\u0017.dQrDQa\u0013,A\u00021CQa\u0017,A\u0002q\u000bAaY1mGB\u0011Q,Y\u0007\u0002=*\u00111a\u0018\u0006\u0003A\u001a\tQA\\8eKNL!A\u00190\u0003!\u0019c\u0017N\\6M_\u001eL7-\u00197DC2\u001c\u0007\"\u00023W\u0001\u0004)\u0017\u0001B:dC:\u0004\"!\u00184\n\u0005\u001dt&a\u0007$mS:\\Gj\\4jG\u0006dG+\u00192mKN{WO]2f'\u000e\fg\u000eC\u0003j-\u0002\u0007!.\u0001\tgS2$XM]1cY\u0016\u001cv.\u001e:dKB\u00121n\u001d\t\u0004Y>\fX\"A7\u000b\u00059D\u0011aB:pkJ\u001cWm]\u0005\u0003a6\u0014QCR5mi\u0016\u0014\u0018M\u00197f)\u0006\u0014G.Z*pkJ\u001cW\r\u0005\u0002sg2\u0001A!\u0003;i\u0003\u0003\u0005\tQ!\u0001v\u0005\ryFEM\t\u0003mf\u0004\"!R<\n\u0005a4%a\u0002(pi\"Lgn\u001a\t\u0003\u000bjL!a\u001f$\u0003\u0007\u0005s\u0017\u0010C\u0003~-\u0002\u0007a0A\u0006eKN\u001c'/\u001b9uS>t\u0007cA@\u0002\u000e9!\u0011\u0011AA\u0005!\r\t\u0019AR\u0007\u0003\u0003\u000bQ1!a\u0002\u0011\u0003\u0019a$o\\8u}%\u0019\u00111\u0002$\u0002\rA\u0013X\rZ3g\u0013\r\u0019\u0014q\u0002\u0006\u0004\u0003\u00171uaBA\n\u0005!\u0005\u0011QC\u0001\"!V\u001c\bNR5mi\u0016\u0014\u0018J\u001c;p)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\t\u0004;\u0005]aAB\u0001\u0003\u0011\u0003\tIb\u0005\u0003\u0002\u0018\u0005m\u0001cA#\u0002\u001e%\u0019\u0011q\u0004$\u0003\r\u0005s\u0017PU3g\u0011\u001dQ\u0012q\u0003C\u0001\u0003G!\"!!\u0006\t\u0015\u0005\u001d\u0012q\u0003b\u0001\n\u0003\tI#\u0001\u0005J\u001dN#\u0016IT\"F+\u0005\u0011\u0002\u0002CA\u0017\u0003/\u0001\u000b\u0011\u0002\n\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    private final TableConfig tableConfig = TableConfig.getDefault();
    private final String defaultCatalog;
    private final CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(Thread.currentThread().getContextClassLoader()).config((ReadableConfig)this.tableConfig().getConfiguration()).defaultCatalog(this.defaultCatalog(), new GenericInMemoryCatalog(this.defaultCatalog(), "default_database")).build();

    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    private TableConfig tableConfig() {
        return this.tableConfig;
    }

    private String defaultCatalog() {
        return this.defaultCatalog;
    }

    private CatalogManager catalogManager() {
        return this.catalogManager;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSource<?> tableSource = scan.tableSource();
        if (tableSource instanceof FilterableTableSource) {
            TableSource<?> tableSource2 = tableSource;
            bl = calc.getProgram().getCondition() != null && !((FilterableTableSource)((Object)tableSource2)).isFilterPushedDown();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)scan.tableSource());
        this.pushFilterIntoScan(call, calc, scan, filterableSource, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, FlinkLogicalCalc calc, FlinkLogicalTableSourceScan scan, FilterableTableSource<?> filterableSource, String description) {
        RexProgram newRexProgram;
        RexProgram rexProgram;
        RexNode rexNode;
        Preconditions.checkArgument((!filterableSource.isFilterPushedDown() ? 1 : 0) != 0);
        RexProgram program = calc.getProgram();
        Tuple2<Expression[], RexNode[]> tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, call.builder().getRexBuilder(), new FunctionCatalog(this.tableConfig(), this.catalogManager(), new ModuleManager()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] predicates = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] predicates2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).isEmpty()) {
            return;
        }
        LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)remainingPredicates.add(e)));
        TableSource<?> newTableSource = filterableSource.applyPredicate(remainingPredicates);
        if (((FilterableTableSource)((Object)newTableSource)).isFilterPushedDown() && newTableSource.explainSource().equals(scan.tableSource().explainSource())) {
            throw new TableException("Failed to push filter into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        RelBuilder relBuilder = call.builder();
        if (!remainingPredicates.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)).nonEmpty()) {
            relBuilder.push(scan);
            Buffer remainingPrecidatesAsExpr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (PlannerExpression)x$2, Buffer$.MODULE$.canBuildFrom());
            Buffer remainingConditions = ((BufferLike)remainingPrecidatesAsExpr.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toRexNode(relBuilder), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)));
            rexNode = (RexNode)remainingConditions.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> relBuilder.and((RexNode)l, (RexNode)r));
        } else {
            rexNode = null;
        }
        RexNode remainingCondition = rexNode;
        FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), scan.tableSchema(), newTableSource, scan.selectedFields());
        if (remainingCondition != null || !program.projectsOnlyIdentity()) {
            List expandedProjectList = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(program.getProjectList()).asScala()).map((Function1 & Serializable & scala.Serializable)ref -> program.expandLocalRef((RexLocalRef)ref), Buffer$.MODULE$.canBuildFrom())).asJava();
            rexProgram = RexProgram.create(program.getInputRowType(), (List<? extends RexNode>)expandedProjectList, remainingCondition, program.getOutputRowType(), relBuilder.getRexBuilder());
        } else {
            rexProgram = newRexProgram = null;
        }
        if (newRexProgram != null) {
            Calc newCalc = calc.copy(calc.getTraitSet(), newScan, newRexProgram);
            call.transformTo(newCalc);
        } else {
            call.transformTo(newScan);
        }
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
        this.defaultCatalog = "default_catalog";
    }
}

