/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.executor;

import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphGenerator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.delegation.Executor;

@Internal
public class StreamExecutor
implements Executor {
    private final StreamExecutionEnvironment executionEnvironment;

    @VisibleForTesting
    public StreamExecutor(StreamExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    @Override
    public Pipeline createPipeline(List<Transformation<?>> transformations, TableConfig tableConfig, String jobName) {
        if (transformations.size() <= 0) {
            throw new IllegalStateException("No operators defined in streaming topology. Cannot generate StreamGraph.");
        }
        return new StreamGraphGenerator(transformations, this.executionEnvironment.getConfig(), this.executionEnvironment.getCheckpointConfig()).setStateBackend(this.executionEnvironment.getStateBackend()).setChaining(this.executionEnvironment.isChainingEnabled()).setUserArtifacts((Collection)this.executionEnvironment.getCachedFiles()).setTimeCharacteristic(this.executionEnvironment.getStreamTimeCharacteristic()).setDefaultBufferTimeout(this.executionEnvironment.getBufferTimeout()).setJobName(jobName).generate();
    }

    @Override
    public JobExecutionResult execute(Pipeline pipeline) throws Exception {
        return this.executionEnvironment.execute((StreamGraph)pipeline);
    }

    @Override
    public JobClient executeAsync(Pipeline pipeline) throws Exception {
        return this.executionEnvironment.executeAsync((StreamGraph)pipeline);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }
}

