/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.operators.sort.IndexedSortable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.MemorySegmentPool;

public abstract class BinaryIndexedSortable
implements IndexedSortable {
    public static final int OFFSET_LEN = 8;
    private final NormalizedKeyComputer normalizedKeyComputer;
    protected final BinaryRowDataSerializer serializer;
    private final RecordComparator comparator;
    protected final RandomAccessInputView recordBuffer;
    private final RandomAccessInputView recordBufferForComparison;
    protected MemorySegment currentSortIndexSegment;
    protected final MemorySegmentPool memorySegmentPool;
    protected final ArrayList<MemorySegment> sortIndex;
    private final int numKeyBytes;
    protected final int indexEntrySize;
    private final int indexEntriesPerSegment;
    protected final int lastIndexEntryOffset;
    private final boolean normalizedKeyFullyDetermines;
    private final boolean useNormKeyUninverted;
    protected final BinaryRowDataSerializer serializer1;
    private final BinaryRowDataSerializer serializer2;
    protected final BinaryRowData row1;
    private final BinaryRowData row2;
    protected int currentSortIndexOffset;
    protected int numRecords;

    public BinaryIndexedSortable(NormalizedKeyComputer normalizedKeyComputer, BinaryRowDataSerializer serializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, MemorySegmentPool memorySegmentPool) {
        if (normalizedKeyComputer == null || serializer == null) {
            throw new NullPointerException();
        }
        this.normalizedKeyComputer = normalizedKeyComputer;
        this.serializer = serializer;
        this.comparator = comparator;
        this.memorySegmentPool = memorySegmentPool;
        this.useNormKeyUninverted = !normalizedKeyComputer.invertKey();
        this.numKeyBytes = normalizedKeyComputer.getNumKeyBytes();
        int segmentSize = memorySegmentPool.pageSize();
        this.recordBuffer = new RandomAccessInputView(recordBufferSegments, segmentSize);
        this.recordBufferForComparison = new RandomAccessInputView(recordBufferSegments, segmentSize);
        this.normalizedKeyFullyDetermines = normalizedKeyComputer.isKeyFullyDetermines();
        this.indexEntrySize = this.numKeyBytes + 8;
        this.indexEntriesPerSegment = segmentSize / this.indexEntrySize;
        this.lastIndexEntryOffset = (this.indexEntriesPerSegment - 1) * this.indexEntrySize;
        this.serializer1 = (BinaryRowDataSerializer)serializer.duplicate();
        this.serializer2 = (BinaryRowDataSerializer)serializer.duplicate();
        this.row1 = this.serializer1.createInstance();
        this.row2 = this.serializer2.createInstance();
        this.sortIndex = new ArrayList(16);
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
    }

    protected MemorySegment nextMemorySegment() {
        return this.memorySegmentPool.nextSegment();
    }

    protected boolean checkNextIndexOffset() {
        if (this.currentSortIndexOffset > this.lastIndexEntryOffset) {
            MemorySegment returnSegment = this.nextMemorySegment();
            if (returnSegment != null) {
                this.currentSortIndexSegment = returnSegment;
                this.sortIndex.add(this.currentSortIndexSegment);
                this.currentSortIndexOffset = 0;
            } else {
                return false;
            }
        }
        return true;
    }

    protected void writeIndexAndNormalizedKey(RowData record, long currOffset) {
        this.currentSortIndexSegment.putLong(this.currentSortIndexOffset, currOffset);
        if (this.numKeyBytes != 0) {
            this.normalizedKeyComputer.putKey(record, this.currentSortIndexSegment, this.currentSortIndexOffset + 8);
        }
        this.currentSortIndexOffset += this.indexEntrySize;
        ++this.numRecords;
    }

    public int compare(int i, int j) {
        int segmentNumberI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int segmentNumberJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        return this.compare(segmentNumberI, segmentOffsetI, segmentNumberJ, segmentOffsetJ);
    }

    public int compare(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        MemorySegment segJ;
        MemorySegment segI = this.sortIndex.get(segmentNumberI);
        int val = this.normalizedKeyComputer.compareKey(segI, segmentOffsetI + 8, segJ = this.sortIndex.get(segmentNumberJ), segmentOffsetJ + 8);
        if (val != 0 || this.normalizedKeyFullyDetermines) {
            return this.useNormKeyUninverted ? val : -val;
        }
        long pointerI = segI.getLong(segmentOffsetI);
        long pointerJ = segJ.getLong(segmentOffsetJ);
        return this.compareRecords(pointerI, pointerJ);
    }

    private int compareRecords(long pointer1, long pointer2) {
        this.recordBuffer.setReadPosition(pointer1);
        this.recordBufferForComparison.setReadPosition(pointer2);
        try {
            return this.comparator.compare(this.serializer1.mapFromPages(this.row1, (AbstractPagedInputView)this.recordBuffer), this.serializer2.mapFromPages(this.row2, (AbstractPagedInputView)this.recordBufferForComparison));
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error comparing two records.", ioex);
        }
    }

    public void swap(int i, int j) {
        int segmentNumberI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int segmentNumberJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        this.swap(segmentNumberI, segmentOffsetI, segmentNumberJ, segmentOffsetJ);
    }

    public void swap(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        MemorySegment segI = this.sortIndex.get(segmentNumberI);
        MemorySegment segJ = this.sortIndex.get(segmentNumberJ);
        long index = segI.getLong(segmentOffsetI);
        segI.putLong(segmentOffsetI, segJ.getLong(segmentOffsetJ));
        segJ.putLong(segmentOffsetJ, index);
        this.normalizedKeyComputer.swapKey(segI, segmentOffsetI + 8, segJ, segmentOffsetJ + 8);
    }

    public int size() {
        return this.numRecords;
    }

    public int recordSize() {
        return this.indexEntrySize;
    }

    public int recordsPerSegment() {
        return this.indexEntriesPerSegment;
    }

    public void writeToOutput(AbstractPagedOutputView output) throws IOException {
        int numRecords = this.numRecords;
        int currentMemSeg = 0;
        int currentRecord = 0;
        while (currentRecord < numRecords) {
            MemorySegment currentIndexSegment = this.sortIndex.get(currentMemSeg++);
            for (int offset = 0; currentRecord < numRecords && offset <= this.lastIndexEntryOffset; ++currentRecord, offset += this.indexEntrySize) {
                long pointer = currentIndexSegment.getLong(offset);
                this.recordBuffer.setReadPosition(pointer);
                this.serializer.copyFromPagesToView((AbstractPagedInputView)this.recordBuffer, (DataOutputView)output);
            }
        }
    }
}

