/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.match;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Collector;

public class RowtimeProcessFunction
extends ProcessFunction<RowData, RowData>
implements ResultTypeQueryable<RowData> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeIdx;
    private final int precision;
    private transient TypeInformation<RowData> returnType;

    public RowtimeProcessFunction(int rowtimeIdx, TypeInformation<RowData> returnType, int precision) {
        this.rowtimeIdx = rowtimeIdx;
        this.returnType = returnType;
        this.precision = precision;
    }

    public void processElement(RowData value, ProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        long timestamp = value.getTimestamp(this.rowtimeIdx, this.precision).getMillisecond();
        ((TimestampedCollector)out).setAbsoluteTimestamp(timestamp);
        out.collect((Object)value);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.returnType;
    }
}

