/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.table.utils.TypeMappingUtils;
import org.apache.flink.types.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TableSinkUtils$ {
    public static TableSinkUtils$ MODULE$;

    static {
        new TableSinkUtils$();
    }

    public void validateTableSink(CatalogSinkModifyOperation sinkOperation, ObjectIdentifier sinkIdentifier, TableSink<?> sink, Seq<String> partitionKeys) {
        TableSink<?> tableSink;
        Map<String, String> staticPartitions;
        if (partitionKeys.nonEmpty()) {
            TableSink<?> tableSink2 = sink;
            if (tableSink2 instanceof PartitionableTableSink) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new ValidationException(new StringBuilder(47).append("We need PartitionableTableSink to write data to").append(new StringBuilder(20).append(" partitioned table: ").append(sinkIdentifier).toString()).toString());
            }
        }
        if ((staticPartitions = sinkOperation.getStaticPartitions()) != null && !staticPartitions.isEmpty()) {
            ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(staticPartitions).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)p -> {
                TableSinkUtils$.$anonfun$validateTableSink$2(sinkIdentifier, partitionKeys, p);
                return BoxedUnit.UNIT;
            });
        }
        if ((tableSink = sink) instanceof OverwritableTableSink) {
            OverwritableTableSink overwritableTableSink = (OverwritableTableSink)((Object)tableSink);
            overwritableTableSink.setOverwrite(sinkOperation.isOverwrite());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.assert(!sinkOperation.isOverwrite(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("INSERT OVERWRITE requires ").append(new StringBuilder(18).append(OverwritableTableSink.class.getSimpleName()).append(" but actually got ").toString()).append(sink.getClass().getName()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public TableSchema inferSinkPhysicalSchema(RowType queryLogicalType, TableSink<?> sink) {
        boolean bl;
        TableSink<?> tableSink = sink;
        boolean bl2 = tableSink instanceof RetractStreamTableSink ? true : tableSink instanceof UpsertStreamTableSink;
        if (bl2) {
            bl = true;
        } else if (tableSink instanceof StreamTableSink) {
            bl = false;
        } else if (tableSink instanceof DataStreamTableSink) {
            DataStreamTableSink dataStreamTableSink = (DataStreamTableSink)tableSink;
            bl = dataStreamTableSink.withChangeFlag();
        } else {
            throw new MatchError(tableSink);
        }
        boolean withChangeFlag = bl;
        return this.inferSinkPhysicalSchema(sink.getConsumedDataType(), queryLogicalType, withChangeFlag);
    }

    public TableSchema inferSinkPhysicalSchema(DataType consumedDataType, RowType queryLogicalType, boolean withChangeFlag) {
        TableSchema tableSchema;
        DataType requestedOutputType = this.inferSinkPhysicalDataType(consumedDataType, queryLogicalType, withChangeFlag);
        if (LogicalTypeChecks.isCompositeType(requestedOutputType.getLogicalType())) {
            TableSchema tableSchema2;
            TypeInformation<?> typeInformation = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(requestedOutputType);
            if (typeInformation instanceof PojoTypeInfo) {
                PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                tableSchema2 = this.expandPojoTypeToSchema(pojoTypeInfo, queryLogicalType);
            } else {
                tableSchema2 = DataTypeUtils.expandCompositeTypeToSchema(requestedOutputType);
            }
            tableSchema = tableSchema2;
        } else {
            tableSchema = TableSchema.builder().field("f0", requestedOutputType).build();
        }
        return tableSchema;
    }

    private TableSchema expandPojoTypeToSchema(PojoTypeInfo<?> pojo, RowType queryLogicalType) {
        List<String> fieldNames = queryLogicalType.getFieldNames();
        Buffer reorderedFields = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldNames).map((Function1 & Serializable & scala.Serializable)name -> {
            DataType dataType;
            int index = pojo.getFieldIndex(name);
            if (index < 0) {
                throw new TableException(new StringBuilder(17).append((String)name).append(" is not found in ").append(pojo.toString()).toString());
            }
            TypeInformation fieldTypeInfo = pojo.getPojoFieldAt(index).getTypeInformation();
            TypeInformation typeInformation = fieldTypeInfo;
            if (typeInformation instanceof PojoTypeInfo) {
                PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                RowType nestedLogicalType = (RowType)((RowType.RowField)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(queryLogicalType.getFields()).apply(index)).getType();
                dataType = MODULE$.expandPojoTypeToSchema(pojoTypeInfo, nestedLogicalType).toRowDataType();
            } else {
                dataType = TypeConversions.fromLegacyInfoToDataType(fieldTypeInfo);
            }
            DataType fieldDataType = dataType;
            return DataTypes.FIELD(name, fieldDataType);
        }, Buffer$.MODULE$.canBuildFrom());
        return DataTypeUtils.expandCompositeTypeToSchema(DataTypes.ROW((DataTypes.Field[])reorderedFields.toArray(ClassTag$.MODULE$.apply(DataTypes.Field.class))));
    }

    /*
     * Unable to fully structure code
     */
    public DataType inferSinkPhysicalDataType(DataType consumedDataType, RowType queryLogicalType, boolean withChangeFlag) {
        block14: {
            block13: {
                block12: {
                    block9: {
                        block11: {
                            block10: {
                                var8_4 = consumedDataType.getLogicalType();
                                if (var8_4 instanceof LegacyTypeInformationType) {
                                    var9_5 = (LegacyTypeInformationType)var8_4;
                                    var6_6 = new Some(var9_5.getTypeInformation());
                                } else {
                                    var6_6 = None$.MODULE$;
                                }
                                consumedTypeInfo = var6_6;
                                if (consumedTypeInfo.isEmpty()) {
                                    return consumedDataType;
                                }
                                if (!withChangeFlag) break block9;
                                var11_8 = (TypeInformation)consumedTypeInfo.get();
                                if (!(var11_8 instanceof TypeInformation) || !(var11_8 instanceof CaseClassTypeInfo)) break block10;
                                var12_9 = (CaseClassTypeInfo)var11_8;
                                v0 = var12_9.getTypeClass();
                                var13_10 = scala.Tuple2.class;
                                if (v0 != null ? v0.equals(var13_10) == false : var13_10 != null) break block10;
                                v1 = var12_9.getTypeAt(0);
                                var14_11 = Types.BOOLEAN();
                                if (v1 != null ? v1.equals(var14_11) == false : var14_11 != null) break block10;
                                var5_12 = var12_9.getTypeAt(1);
                                break block11;
                            }
                            if (!(var11_8 instanceof TypeInformation) || !(var11_8 instanceof TupleTypeInfo)) ** GOTO lbl-1000
                            var15_13 = (TupleTypeInfo)var11_8;
                            v2 = var15_13.getTypeClass();
                            var16_14 = Tuple2.class;
                            if (v2 != null ? v2.equals(var16_14) == false : var16_14 != null) ** GOTO lbl-1000
                            v3 = var15_13.getTypeAt(0);
                            var17_15 = Types.BOOLEAN();
                            if (!(v3 != null ? v3.equals(var17_15) == false : var17_15 != null)) {
                                var5_12 = var15_13.getTypeAt(1);
                            } else lbl-1000:
                            // 3 sources

                            {
                                throw new TableException(new StringBuilder(46).append("Don't support ").append(consumedDataType).append(" conversion for the retract sink").toString());
                            }
                        }
                        v4 = var5_12;
                        break block12;
                    }
                    v4 = (TypeInformation)consumedTypeInfo.get();
                }
                requestedTypeInfo = v4;
                var18_17 = false;
                var19_18 = null;
                var20_19 = requestedTypeInfo;
                if (!(var20_19 instanceof GenericTypeInfo)) break block13;
                var18_17 = true;
                var19_18 = (GenericTypeInfo)var20_19;
                v5 = var19_18.getTypeClass();
                var21_20 = Row.class;
                if (v5 != null ? v5.equals(var21_20) == false : var21_20 != null) break block13;
                var4_21 = (DataType)TypeConversions.fromLogicalToDataType(queryLogicalType).bridgedTo(Row.class);
                break block14;
            }
            if (!var18_17) ** GOTO lbl-1000
            v6 = var19_18.getTypeClass();
            var22_22 = RowData.class;
            if (!(v6 != null ? v6.equals(var22_22) == false : var22_22 != null)) {
                var4_21 = (DataType)TypeConversions.fromLogicalToDataType(queryLogicalType).bridgedTo(RowData.class);
            } else if (var20_19 instanceof InternalTypeInfo) {
                var23_23 = (InternalTypeInfo)var20_19;
                fields = (DataTypes.Field[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])var23_23.toRowFieldNames())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])var23_23.toRowFieldTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class))))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$inferSinkPhysicalDataType$1(scala.Tuple2 ), (Lscala/Tuple2;)Lorg/apache/flink/table/api/DataTypes$Field;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataTypes.Field.class)));
                var4_21 = (DataType)DataTypes.ROW(fields).bridgedTo(RowData.class);
            } else {
                var4_21 = TypeConversions.fromLegacyInfoToDataType(requestedTypeInfo);
            }
        }
        return var4_21;
    }

    public void validateLogicalPhysicalTypesCompatible(CatalogTable catalogTable, TableSink<?> sink, RowType queryLogicalType) {
        TableSchema logicalSchema = TableSchemaUtils.getPhysicalSchema(catalogTable.getSchema());
        TableSchema physicalSchema = this.inferSinkPhysicalSchema(queryLogicalType, sink);
        if (logicalSchema.getFieldCount() != physicalSchema.getFieldCount()) {
            throw new ValidationException(new StringBuilder(104).append("The field count of logical schema of the table does not match with the field count of physical schema\n. ").append(new StringBuilder(23).append("The logical schema: [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logicalSchema.getFieldDataTypes())).mkString(",")).append("]\n").toString()).append(new StringBuilder(24).append("The physical schema: [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])physicalSchema.getFieldDataTypes())).mkString(",")).append("].").toString()).toString());
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), logicalSchema.getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            DataType logicalFieldType = DataTypeUtils.transform(logicalSchema.getFieldDataTypes()[i], TypeTransformations.toNullable());
            String logicalFieldName = logicalSchema.getFieldNames()[i];
            DataType physicalFieldType = DataTypeUtils.transform(physicalSchema.getFieldDataTypes()[i], TypeTransformations.toNullable());
            String physicalFieldName = physicalSchema.getFieldNames()[i];
            TypeMappingUtils.checkPhysicalLogicalTypeCompatible(physicalFieldType.getLogicalType(), logicalFieldType.getLogicalType(), physicalFieldName, logicalFieldName, false);
        });
    }

    public int[] getNotNullFieldIndices(CatalogTable catalogTable) {
        RowType rowType = (RowType)catalogTable.getSchema().toPhysicalRowDataType().getLogicalType();
        LogicalType[] fieldTypes = (LogicalType[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rowType.getFields()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getType(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class));
        return (int[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldTypes)).indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)index -> !fieldTypes[index].isNullable())).toArray(ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ void $anonfun$validateTableSink$2(ObjectIdentifier sinkIdentifier$1, Seq partitionKeys$1, String p) {
        if (!partitionKeys$1.contains((Object)p)) {
            throw new ValidationException(new StringBuilder(51).append("Static partition column ").append(p).append(" should be in the partition").append(new StringBuilder(26).append(" fields list ").append(partitionKeys$1).append(" for Table(").append(sinkIdentifier$1).append(").").toString()).toString());
        }
    }

    public static final /* synthetic */ DataTypes.Field $anonfun$inferSinkPhysicalDataType$1(scala.Tuple2 x0$1) {
        scala.Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String n = (String)tuple2._1();
        LogicalType t = (LogicalType)tuple2._2();
        DataTypes.Field field = DataTypes.FIELD(n, TypeConversions.fromLogicalToDataType(t));
        return field;
    }

    private TableSinkUtils$() {
        MODULE$ = this;
    }
}

