/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import scala.Tuple2;

public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    public static final PushFilterIntoTableSourceScanRule INSTANCE = new PushFilterIntoTableSourceScanRule();

    public PushFilterIntoTableSourceScanRule() {
        super(PushFilterIntoTableSourceScanRule.operand(Filter.class, PushFilterIntoTableSourceScanRule.operand(LogicalTableScan.class, PushFilterIntoTableSourceScanRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        TableConfig config = call.getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig();
        if (!config.getConfiguration().getBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_PREDICATE_PUSHDOWN_ENABLED)) {
            return false;
        }
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        return tableSourceTable != null && tableSourceTable.tableSource() instanceof SupportsFilterPushDown && Arrays.stream(tableSourceTable.extraDigests()).noneMatch(str -> str.startsWith("filter=["));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable table = scan.getTable().unwrap(TableSourceTable.class);
        this.pushFilterIntoScan(call, filter, scan, table);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkPreparingTableBase relOptTable) {
        RelBuilder relBuilder = call.builder();
        FlinkContext context = call.getPlanner().getContext().unwrap(FlinkContext.class);
        int maxCnfNodeCount = FlinkRelOptUtil.getMaxCnfNodeCount(scan);
        Tuple2<Expression[], RexNode[]> tuple2 = RexNodeExtractor.extractConjunctiveConditions(filter.getCondition(), maxCnfNodeCount, filter.getInput().getRowType().getFieldNames(), relBuilder.getRexBuilder(), context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(scan.getCluster().getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig().getLocalTimeZone()));
        Expression[] predicates = (Expression[])tuple2._1;
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2;
        if (predicates.length == 0) {
            return;
        }
        LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
        remainingPredicates.addAll(Arrays.asList(predicates));
        int originPredicatesSize = remainingPredicates.size();
        TableSourceTable oldTableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        DynamicTableSource newTableSource = oldTableSourceTable.tableSource().copy();
        ExpressionResolver resolver = ExpressionResolver.resolverFor(context.getTableConfig(), name -> Optional.empty(), context.getFunctionCatalog().asLookup(str -> {
            throw new TableException("We should not need to lookup any expressions at this point");
        }), context.getCatalogManager().getDataTypeFactory(), new QueryOperation[0]).build();
        SupportsFilterPushDown.Result result = ((SupportsFilterPushDown)((Object)newTableSource)).applyFilters(resolver.resolve(remainingPredicates));
        int updatedPredicatesSize = result.getRemainingFilters().size();
        TableSourceTable newTableSourceTable = oldTableSourceTable.copy(newTableSource, this.getNewFlinkStatistic(oldTableSourceTable, originPredicatesSize, updatedPredicatesSize), this.getNewExtraDigests(result.getAcceptedFilters()));
        LogicalTableScan newScan = LogicalTableScan.create(scan.getCluster(), newTableSourceTable, scan.getHints());
        if (result.getRemainingFilters().isEmpty() && unconvertedRexNodes.length == 0) {
            call.transformTo(newScan);
        } else {
            relBuilder.push(scan);
            ExpressionConverter converter = new ExpressionConverter(relBuilder);
            List remainingConditions = result.getRemainingFilters().stream().map(e -> e.accept(converter)).collect(Collectors.toList());
            remainingConditions.addAll(Arrays.asList(unconvertedRexNodes));
            RexNode remainingCondition = relBuilder.and(remainingConditions);
            Filter newFilter = filter.copy(filter.getTraitSet(), newScan, remainingCondition);
            call.transformTo(newFilter);
        }
    }

    private FlinkStatistic getNewFlinkStatistic(TableSourceTable tableSourceTable, int originPredicatesSize, int updatedPredicatesSize) {
        FlinkStatistic oldStatistic = tableSourceTable.getStatistic();
        FlinkStatistic newStatistic = null;
        newStatistic = originPredicatesSize == updatedPredicatesSize ? oldStatistic : (oldStatistic == FlinkStatistic.UNKNOWN() ? oldStatistic : FlinkStatistic.builder().statistic(oldStatistic).tableStats(null).build());
        return newStatistic;
    }

    private String[] getNewExtraDigests(List<ResolvedExpression> acceptedFilters) {
        String extraDigest = null;
        if (!acceptedFilters.isEmpty()) {
            String pushedExpr = ((ResolvedExpression)acceptedFilters.stream().reduce((l, r) -> new CallExpression(BuiltInFunctionDefinitions.AND, Arrays.asList(l, r), DataTypes.BOOLEAN())).get()).toString();
            extraDigest = "filter=[" + pushedExpr + "]";
        } else {
            extraDigest = "filter=[]";
        }
        return new String[]{extraDigest};
    }
}

