/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154Q!\u0001\u0002\u0002\u0002M\u0011!\u0007T8hS\u000e\fGnQ8se\u0016d\u0017\r^3U_*{\u0017N\u001c$s_6<UM\\3sC2$V-\u001c9pe\u0006dG+\u00192mKJ+H.\u001a\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003W1{w-[2bY\u000e{'O]3mCR,Gk\u001c&pS:4%o\\7UK6\u0004xN]1m)\u0006\u0014G.\u001a*vY\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\b_B,'/\u00198e!\tYr$D\u0001\u001d\u0015\t9QD\u0003\u0002\u001f\u001d\u000591-\u00197dSR,\u0017B\u0001\u0011\u001d\u0005E\u0011V\r\\(qiJ+H.Z(qKJ\fg\u000e\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005YA-Z:de&\u0004H/[8o!\t!SF\u0004\u0002&WA\u0011a%K\u0007\u0002O)\u0011\u0001FE\u0001\u0007yI|w\u000e\u001e \u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y%BQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtDcA\u001a5kA\u0011Q\u0003\u0001\u0005\u00063A\u0002\rA\u0007\u0005\u0006EA\u0002\ra\t\u0005\u0006o\u0001!\t\u0002O\u0001\u001eKb$(/Y2u%&<\u0007\u000e^#wK:$H+[7f\u0013:\u0004X\u000f\u001e*fMR\u0019\u0011hQ&\u0011\u0007iZT(D\u0001*\u0013\ta\u0014F\u0001\u0004PaRLwN\u001c\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001v\t1A]3y\u0013\t\u0011uHA\u0004SKbtu\u000eZ3\t\u000b\u00113\u0004\u0019A#\u0002\u00131,g\r^%oaV$\bC\u0001$J\u001b\u00059%B\u0001%\u001e\u0003\r\u0011X\r\\\u0005\u0003\u0015\u001e\u0013qAU3m\u001d>$W\rC\u0003Mm\u0001\u0007Q*\u0001\u0005t]\u0006\u00048\u000f[8u!\tq\u0005+D\u0001P\u0015\t\u0019q)\u0003\u0002R\u001f\nyAj\\4jG\u0006d7K\\1qg\"|G\u000fC\u0003T\u0001\u0011EA+A\u000efqR\u0014\u0018m\u0019;T]\u0006\u00048\u000f[8u)&lW-\u00138qkR\u0014VM\u001a\u000b\u0004+fS\u0006c\u0001\u001e<-B\u0011ahV\u0005\u00031~\u00121BU3y\u0013:\u0004X\u000f\u001e*fM\")AI\u0015a\u0001\u000b\")AJ\u0015a\u0001\u001b\")A\f\u0001C!;\u00069qN\\'bi\u000eDGC\u00010b!\tQt,\u0003\u0002aS\t!QK\\5u\u0011\u0015\u00117\f1\u0001d\u0003\u0011\u0019\u0017\r\u001c7\u0011\u0005m!\u0017BA3\u001d\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQa\u001a\u0001\u0005\n!\f!$[:S_^$\u0016.\\3UK6\u0004xN]1m)\u0006\u0014G.\u001a&pS:$\"!\u001b7\u0011\u0005iR\u0017BA6*\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u00144A\u00025\u0003")
public abstract class LogicalCorrelateToJoinFromGeneralTemporalTableRule
extends LogicalCorrelateToJoinFromTemporalTableRule {
    public Option<RexNode> extractRightEventTimeInputRef(RelNode leftInput, LogicalSnapshot snapshot) {
        None$ none$;
        Buffer rightFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(snapshot.getRowType().getFieldList()).asScala();
        Buffer timeAttributeFields = (Buffer)rightFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogicalCorrelateToJoinFromGeneralTemporalTableRule.$anonfun$extractRightEventTimeInputRef$1(f)));
        if (timeAttributeFields.length() == 1) {
            int timeColIndex = leftInput.getRowType().getFieldCount() + rightFields.indexOf(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(timeAttributeFields).get(0));
            RelDataType timeColDataType = ((RelDataTypeField)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(timeAttributeFields).get(0)).getType();
            RexBuilder rexBuilder = snapshot.getCluster().getRexBuilder();
            none$ = new Some((Object)rexBuilder.makeInputRef(timeColDataType, timeColIndex));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexInputRef> extractSnapshotTimeInputRef(RelNode leftInput, LogicalSnapshot snapshot) {
        None$ none$;
        RelDataTypeField periodField;
        RelDataType leftRowType = leftInput.getRowType();
        List<RelDataTypeField> leftFields = leftRowType.getFieldList();
        if (leftFields.contains(periodField = ((RexFieldAccess)snapshot.getPeriod()).getField())) {
            int index = leftRowType.getFieldList().indexOf(periodField);
            none$ = new Some((Object)RexInputRef.of(index, leftRowType));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RexNode rexNode;
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        Object leftInput = call.rel(1);
        RexNode filterCondition = this.getFilterCondition(call);
        LogicalSnapshot snapshot = this.getLogicalSnapshot(call);
        RelDataType leftRowType = leftInput.getRowType();
        RexNode joinCondition = filterCondition.accept(new RexShuttle(null, correlate, leftRowType){
            private final LogicalCorrelate correlate$2;
            private final RelDataType leftRowType$2;

            public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                RexNode rexNode;
                RexNode rexNode2 = fieldAccess.getReferenceExpr();
                if (rexNode2 instanceof RexCorrelVariable) {
                    RexCorrelVariable rexCorrelVariable = (RexCorrelVariable)rexNode2;
                    Predef$.MODULE$.require(this.correlate$2.getCorrelationId().equals(rexCorrelVariable.id));
                    int index = this.leftRowType$2.getFieldList().indexOf(fieldAccess.getField());
                    rexNode = RexInputRef.of(index, this.leftRowType$2);
                } else {
                    rexNode = super.visitFieldAccess(fieldAccess);
                }
                return rexNode;
            }

            public RexNode visitInputRef(RexInputRef inputRef) {
                int rightIndex = this.leftRowType$2.getFieldCount() + inputRef.getIndex();
                return new RexInputRef(rightIndex, inputRef.getType());
            }
            {
                this.correlate$2 = correlate$2;
                this.leftRowType$2 = leftRowType$2;
            }
        });
        this.validateSnapshotInCorrelate(snapshot, correlate);
        RexBuilder rexBuilder = correlate.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)leftInput);
        relBuilder.push(snapshot);
        RelNode rewriteJoin = relBuilder.join(correlate.getJoinType(), joinCondition).build();
        JoinInfo joinInfo = ((LogicalJoin)rewriteJoin).analyzeCondition();
        Buffer leftJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)joinInfo.leftKeys).map((Function1 & Serializable & scala.Serializable)i -> rexBuilder.makeInputRef((RelNode)leftInput, Predef$.MODULE$.Integer2int(i)), Buffer$.MODULE$.canBuildFrom());
        int leftFieldCnt = leftInput.getRowType().getFieldCount();
        Buffer rightJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((List)joinInfo.rightKeys).map((Function1 & Serializable & scala.Serializable)i -> {
            RelDataType leftKeyType = snapshot.getRowType().getFieldList().get(Predef$.MODULE$.Integer2int(i)).getType();
            return rexBuilder.makeInputRef(leftKeyType, leftFieldCnt + Predef$.MODULE$.Integer2int(i));
        }, Buffer$.MODULE$.canBuildFrom());
        if (leftJoinKey.length() == 0 || rightJoinKey.length() == 0) {
            throw new ValidationException("Currently the join key in Temporal Table Join can not be empty.");
        }
        Tuple2 tuple2 = new Tuple2((Object)leftJoinKey, (Object)rightJoinKey);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Buffer leftJoinKey2 = (Buffer)tuple2._1();
        Buffer rightJoinKey2 = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftJoinKey2, (Object)rightJoinKey2);
        Tuple2 tuple23 = tuple22;
        Buffer leftJoinKey3 = (Buffer)tuple23._1();
        Buffer rightJoinKey3 = (Buffer)tuple23._2();
        RexInputRef snapshotTimeInputRef = (RexInputRef)this.extractSnapshotTimeInputRef((RelNode)leftInput, snapshot).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ValidationException("Temporal Table Join requires time attribute in the left table, but no time attribute found.");
        });
        if (this.isRowTimeTemporalTableJoin(snapshot)) {
            Option<RexNode> rightTimeInputRef = this.extractRightEventTimeInputRef((RelNode)leftInput, snapshot);
            if (rightTimeInputRef.isEmpty() || !FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(((RexNode)rightTimeInputRef.get()).getType())) {
                throw new ValidationException(new StringBuilder(139).append("Event-Time Temporal Table Join requires both").append(" primary key and row time attribute in versioned table,").append(" but no row time attribute can be found.").toString());
            }
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialRowTimeTemporalTableJoinCondCall(rexBuilder, snapshotTimeInputRef, (RexNode)rightTimeInputRef.get(), (Seq<RexNode>)leftJoinKey3, (Seq<RexNode>)rightJoinKey3);
        } else {
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialProcTimeTemporalTableJoinConCall(rexBuilder, snapshotTimeInputRef, (Seq<RexNode>)leftJoinKey3, (Seq<RexNode>)rightJoinKey3);
        }
        RexNode temporalCondition = rexNode;
        RelBuilder builder = call.builder();
        RexNode condition = builder.and(joinCondition, temporalCondition);
        builder.push((RelNode)leftInput);
        builder.push(snapshot);
        builder.join(correlate.getJoinType(), condition);
        RelNode temporalJoin = builder.build();
        call.transformTo(temporalJoin);
    }

    private boolean isRowTimeTemporalTableJoin(LogicalSnapshot snapshot) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType = snapshot.getPeriod().getType();
        boolean bl = relDataType instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$extractRightEventTimeInputRef$1(RelDataTypeField f) {
        return f.getType() instanceof TimeIndicatorRelDataType && ((TimeIndicatorRelDataType)f.getType()).isEventTime();
    }

    public LogicalCorrelateToJoinFromGeneralTemporalTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }
}

