/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Union;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.transformations.ShuffleMode;
import org.apache.flink.streaming.api.transformations.SourceTransformation;
import org.apache.flink.table.planner.plan.nodes.common.CommonPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.AbstractExecNodeExactlyOnceVisitor;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecBoundedStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecMultipleInput;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecMultipleInput;
import org.apache.flink.table.planner.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.planner.plan.nodes.process.DAGProcessor;
import org.apache.flink.table.planner.plan.processors.utils.InputOrderCalculator;
import org.apache.flink.table.planner.plan.processors.utils.InputPriorityConflictResolver;
import org.apache.flink.util.Preconditions;

public class MultipleInputNodeCreationProcessor
implements DAGProcessor {
    private final boolean isStreaming;

    public MultipleInputNodeCreationProcessor(boolean isStreaming) {
        this.isStreaming = isStreaming;
    }

    @Override
    public List<ExecNode<?, ?>> process(List<ExecNode<?, ?>> roots, DAGProcessContext context) {
        if (!this.isStreaming) {
            InputPriorityConflictResolver resolver = new InputPriorityConflictResolver(roots, ExecEdge.DamBehavior.BLOCKING, ShuffleMode.PIPELINED);
            resolver.detectAndResolve();
        }
        List<ExecNodeWrapper> rootWrappers = this.wrapExecNodes(roots);
        List<ExecNodeWrapper> orderedWrappers = this.topologicalSort(rootWrappers);
        this.createMultipleInputGroups(orderedWrappers);
        this.optimizeMultipleInputGroups(orderedWrappers, context);
        return this.createMultipleInputNodes(rootWrappers);
    }

    private List<ExecNodeWrapper> wrapExecNodes(List<ExecNode<?, ?>> rootNodes) {
        final HashMap wrapperMap = new HashMap();
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?, ?> node) {
                ExecNodeWrapper wrapper = wrapperMap.computeIfAbsent(node, k -> new ExecNodeWrapper(node));
                for (ExecNode<?, ?> input : node.getInputNodes()) {
                    ExecNodeWrapper inputWrapper = wrapperMap.computeIfAbsent(input, k -> new ExecNodeWrapper(input));
                    wrapper.inputs.add(inputWrapper);
                    inputWrapper.outputs.add(wrapper);
                }
                this.visitInputs(node);
            }
        };
        rootNodes.forEach(s -> s.accept(visitor));
        ArrayList<ExecNodeWrapper> rootWrappers = new ArrayList<ExecNodeWrapper>();
        for (ExecNode<?, ?> root : rootNodes) {
            ExecNodeWrapper rootWrapper = (ExecNodeWrapper)wrapperMap.get(root);
            Preconditions.checkNotNull((Object)rootWrapper, (String)"Root node is not wrapped. This is a bug.");
            rootWrappers.add(rootWrapper);
        }
        return rootWrappers;
    }

    private List<ExecNodeWrapper> topologicalSort(List<ExecNodeWrapper> rootWrappers) {
        ArrayList<ExecNodeWrapper> result = new ArrayList<ExecNodeWrapper>();
        LinkedList<ExecNodeWrapper> queue = new LinkedList<ExecNodeWrapper>(rootWrappers);
        HashMap<ExecNodeWrapper, Integer> visitCountMap = new HashMap<ExecNodeWrapper, Integer>();
        while (!queue.isEmpty()) {
            ExecNodeWrapper wrapper = (ExecNodeWrapper)queue.poll();
            result.add(wrapper);
            for (ExecNodeWrapper inputWrapper : wrapper.inputs) {
                int visitCount = visitCountMap.compute(inputWrapper, (k, v) -> v == null ? 1 : v + 1);
                if (visitCount != inputWrapper.outputs.size()) continue;
                queue.offer(inputWrapper);
            }
        }
        return result;
    }

    private void createMultipleInputGroups(List<ExecNodeWrapper> orderedWrappers) {
        for (ExecNodeWrapper wrapper : orderedWrappers) {
            if (!this.canBeMultipleInputNodeMember(wrapper)) continue;
            MultipleInputGroup outputGroup = this.canBeInSameGroupWithOutputs(wrapper);
            if (outputGroup != null) {
                outputGroup.addMember(wrapper);
                continue;
            }
            if (!this.canBeRootOfMultipleInputGroup(wrapper)) continue;
            wrapper.group = new MultipleInputGroup(wrapper);
        }
    }

    private boolean canBeMultipleInputNodeMember(ExecNodeWrapper wrapper) {
        if (wrapper.inputs.isEmpty()) {
            return false;
        }
        return !(wrapper.execNode instanceof Exchange);
    }

    private MultipleInputGroup canBeInSameGroupWithOutputs(ExecNodeWrapper wrapper) {
        if (wrapper.outputs.isEmpty()) {
            return null;
        }
        MultipleInputGroup outputGroup = ((ExecNodeWrapper)wrapper.outputs.get(0)).group;
        if (outputGroup == null) {
            return null;
        }
        for (ExecNodeWrapper outputWrapper : wrapper.outputs) {
            if (outputWrapper.group == outputGroup) continue;
            return null;
        }
        return outputGroup;
    }

    private boolean canBeRootOfMultipleInputGroup(ExecNodeWrapper wrapper) {
        return wrapper.inputs.size() >= 2;
    }

    private void optimizeMultipleInputGroups(List<ExecNodeWrapper> orderedWrappers, DAGProcessContext context) {
        MultipleInputGroup group;
        for (int i = orderedWrappers.size() - 1; i >= 0; --i) {
            ExecNodeWrapper wrapper = orderedWrappers.get(i);
            group = wrapper.group;
            if (group == null || !this.isEntranceOfMultipleInputGroup(wrapper)) continue;
            boolean shouldRemove = false;
            if (wrapper.execNode instanceof Union) {
                shouldRemove = wrapper.inputs.stream().noneMatch(inputWrapper -> MultipleInputNodeCreationProcessor.isChainableSource(((ExecNodeWrapper)inputWrapper).execNode, context));
            } else if (wrapper.inputs.size() == 1) {
                ExecNode input = ((ExecNodeWrapper)wrapper.inputs.get(0)).execNode;
                boolean bl = shouldRemove = !(input instanceof Exchange) && !MultipleInputNodeCreationProcessor.isChainableSource(input, context);
            }
            if (!(shouldRemove |= wrapper.inputs.stream().anyMatch(inputWrapper -> ((ExecNodeWrapper)inputWrapper).execNode instanceof Exchange && ((Exchange)((Object)((ExecNodeWrapper)inputWrapper).execNode)).distribution.getType() == RelDistribution.Type.SINGLETON))) continue;
            wrapper.group.removeMember(wrapper);
        }
        for (ExecNodeWrapper wrapper : orderedWrappers) {
            group = wrapper.group;
            if (group == null || wrapper != wrapper.group.root) continue;
            boolean isUnion = wrapper.execNode instanceof Union;
            if (group.members.size() == 1) {
                if (!isUnion && !wrapper.inputs.stream().noneMatch(inputWrapper -> MultipleInputNodeCreationProcessor.isChainableSource(((ExecNodeWrapper)inputWrapper).execNode, context))) continue;
                wrapper.group.removeRoot();
                continue;
            }
            if (isUnion) {
                List sameGroupWrappers;
                int numberOfUsefulInputs = 0;
                ArrayList<Integer> uselessBranches = new ArrayList<Integer>();
                ArrayList<List> sameGroupWrappersList = new ArrayList<List>();
                for (int i = 0; i < wrapper.inputs.size(); ++i) {
                    ExecNodeWrapper inputWrapper2 = (ExecNodeWrapper)wrapper.inputs.get(i);
                    sameGroupWrappers = this.getInputWrappersInSameGroup(inputWrapper2, wrapper.group);
                    sameGroupWrappersList.add(sameGroupWrappers);
                    long numberOfValuableNodes = sameGroupWrappers.stream().filter(w -> ((ExecNodeWrapper)w).inputs.size() >= 2 && !(((ExecNodeWrapper)w).execNode instanceof Union)).count();
                    if (numberOfValuableNodes > 0L) {
                        ++numberOfUsefulInputs;
                        continue;
                    }
                    uselessBranches.add(i);
                }
                if (numberOfUsefulInputs >= 2) continue;
                Iterator iterator = uselessBranches.iterator();
                while (iterator.hasNext()) {
                    int branch = (Integer)iterator.next();
                    sameGroupWrappers = (List)sameGroupWrappersList.get(branch);
                    for (ExecNodeWrapper w2 : sameGroupWrappers) {
                        if (w2.group == null) continue;
                        w2.group.removeMember(w2);
                    }
                }
                wrapper.group.removeRoot();
                continue;
            }
            if (wrapper.inputs.size() != 1) continue;
            wrapper.group.removeRoot();
        }
    }

    private List<ExecNodeWrapper> getInputWrappersInSameGroup(ExecNodeWrapper wrapper, MultipleInputGroup group) {
        ArrayList<ExecNodeWrapper> ret = new ArrayList<ExecNodeWrapper>();
        LinkedList<ExecNodeWrapper> queue = new LinkedList<ExecNodeWrapper>();
        HashSet<ExecNodeWrapper> visited = new HashSet<ExecNodeWrapper>();
        queue.add(wrapper);
        visited.add(wrapper);
        while (!queue.isEmpty()) {
            ExecNodeWrapper w = (ExecNodeWrapper)queue.poll();
            if (w.group != group) continue;
            ret.add(w);
            for (ExecNodeWrapper inputWrapper : w.inputs) {
                if (visited.contains(inputWrapper)) continue;
                queue.add(inputWrapper);
                visited.add(inputWrapper);
            }
        }
        return ret;
    }

    private boolean isEntranceOfMultipleInputGroup(ExecNodeWrapper wrapper) {
        Preconditions.checkNotNull((Object)wrapper.group, (String)"Exec node wrapper does not have a multiple input group. This is a bug.");
        for (ExecNodeWrapper inputWrapper : wrapper.inputs) {
            if (inputWrapper.group != wrapper.group) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean isChainableSource(ExecNode<?, ?> node, DAGProcessContext context) {
        if (node instanceof BatchExecBoundedStreamScan) {
            BatchExecBoundedStreamScan scan = (BatchExecBoundedStreamScan)node;
            return scan.boundedStreamTable().dataStream().getTransformation() instanceof SourceTransformation;
        }
        if (node instanceof StreamExecDataStreamScan) {
            StreamExecDataStreamScan scan = (StreamExecDataStreamScan)node;
            return scan.dataStreamTable().dataStream().getTransformation() instanceof SourceTransformation;
        }
        if (node instanceof CommonPhysicalTableSourceScan) {
            Transformation<?> transformation = node.translateToPlan(((DAGProcessContext)Preconditions.checkNotNull((Object)context)).getPlanner());
            return transformation instanceof SourceTransformation;
        }
        return false;
    }

    private List<ExecNode<?, ?>> createMultipleInputNodes(List<ExecNodeWrapper> rootWrappers) {
        ArrayList result = new ArrayList();
        HashMap visitedMap = new HashMap();
        for (ExecNodeWrapper rootWrapper : rootWrappers) {
            result.add(this.getMultipleInputNode(rootWrapper, visitedMap));
        }
        return result;
    }

    private ExecNode<?, ?> getMultipleInputNode(ExecNodeWrapper wrapper, Map<ExecNodeWrapper, ExecNode<?, ?>> visitedMap) {
        if (visitedMap.containsKey(wrapper)) {
            return visitedMap.get(wrapper);
        }
        for (int i = 0; i < wrapper.inputs.size(); ++i) {
            wrapper.execNode.replaceInputNode(i, this.getMultipleInputNode((ExecNodeWrapper)wrapper.inputs.get(i), visitedMap));
        }
        ExecNode<?, ?> ret = wrapper.group != null && wrapper == wrapper.group.root ? this.createMultipleInputNode(wrapper.group, visitedMap) : wrapper.execNode;
        visitedMap.put(wrapper, ret);
        return ret;
    }

    private ExecNode<?, ?> createMultipleInputNode(MultipleInputGroup group, Map<ExecNodeWrapper, ExecNode<?, ?>> visitedMap) {
        ArrayList inputs = new ArrayList();
        for (ExecNodeWrapper member : group.members) {
            for (int i = 0; i < member.inputs.size(); ++i) {
                ExecNodeWrapper memberInput = (ExecNodeWrapper)member.inputs.get(i);
                if (group.members.contains(memberInput)) continue;
                Preconditions.checkState((boolean)visitedMap.containsKey(memberInput), (Object)"Input of a multiple input member is not visited. This is a bug.");
                ExecNode<?, ?> inputNode = visitedMap.get(memberInput);
                ExecEdge inputEdge = member.execNode.getInputEdges().get(i);
                inputs.add(Tuple2.of(inputNode, (Object)inputEdge));
            }
        }
        if (this.isStreaming) {
            return this.createStreamMultipleInputNode(group, inputs);
        }
        return this.createBatchMultipleInputNode(group, inputs);
    }

    private StreamExecMultipleInput createStreamMultipleInputNode(MultipleInputGroup group, List<Tuple2<ExecNode<?, ?>, ExecEdge>> inputs) {
        RelNode outputRel = (RelNode)((Object)group.root.execNode);
        RelNode[] inputRels = new RelNode[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            inputRels[i] = (RelNode)inputs.get((int)i).f0;
        }
        return new StreamExecMultipleInput(outputRel.getCluster(), outputRel.getTraitSet(), inputRels, outputRel);
    }

    private BatchExecMultipleInput createBatchMultipleInputNode(MultipleInputGroup group, List<Tuple2<ExecNode<?, ?>, ExecEdge>> inputs) {
        HashSet inputSet = new HashSet();
        for (Tuple2<ExecNode<?, ?>, ExecEdge> t : inputs) {
            inputSet.add((ExecNode<?, ?>)t.f0);
        }
        InputOrderCalculator calculator = new InputOrderCalculator(group.root.execNode, inputSet, ExecEdge.DamBehavior.BLOCKING);
        Map<ExecNode<?, ?>, Integer> inputOrderMap = calculator.calculate();
        RelNode outputRel = (RelNode)((Object)group.root.execNode);
        RelNode[] inputRels = new RelNode[inputs.size()];
        ExecEdge[] inputEdges = new ExecEdge[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            ExecNode inputNode = (ExecNode)inputs.get((int)i).f0;
            ExecEdge originalInputEdge = (ExecEdge)inputs.get((int)i).f1;
            inputRels[i] = (RelNode)((Object)inputNode);
            inputEdges[i] = ExecEdge.builder().requiredShuffle(originalInputEdge.getRequiredShuffle()).damBehavior(originalInputEdge.getDamBehavior()).priority(inputOrderMap.get(inputNode)).build();
        }
        return new BatchExecMultipleInput(outputRel.getCluster(), outputRel.getTraitSet(), inputRels, outputRel, inputEdges);
    }

    private static class MultipleInputGroup {
        private final List<ExecNodeWrapper> members = new ArrayList<ExecNodeWrapper>();
        private ExecNodeWrapper root;

        private MultipleInputGroup(ExecNodeWrapper root) {
            this.members.add(root);
            this.root = root;
        }

        private void addMember(ExecNodeWrapper wrapper) {
            Preconditions.checkState((wrapper.group == null ? 1 : 0) != 0, (Object)"The given exec node wrapper is already in a multiple input group. This is a bug.");
            this.members.add(wrapper);
            wrapper.group = this;
        }

        private void removeMember(ExecNodeWrapper wrapper) {
            if (wrapper == this.root) {
                this.removeRoot();
            } else {
                Preconditions.checkState((boolean)this.members.remove(wrapper), (Object)"The given exec node wrapper does not exist in the multiple input group. This is a bug.");
                wrapper.group = null;
            }
        }

        private void removeRoot() {
            Preconditions.checkNotNull((Object)this.root, (String)"Multiple input group does not have a root. This is a bug.");
            HashSet<ExecNodeWrapper> sameGroupInputWrappers = new HashSet<ExecNodeWrapper>();
            for (ExecNodeWrapper inputWrapper : this.root.inputs) {
                if (!this.members.contains(inputWrapper)) continue;
                sameGroupInputWrappers.add(inputWrapper);
            }
            Preconditions.checkState((sameGroupInputWrappers.size() < 2 ? 1 : 0) != 0, (Object)"There are two or more inputs of the root remaining in the multiple input group. This is a bug.");
            this.members.remove(this.root);
            this.root.group = null;
            this.root = sameGroupInputWrappers.isEmpty() ? null : (ExecNodeWrapper)sameGroupInputWrappers.iterator().next();
        }
    }

    private static class ExecNodeWrapper {
        private final ExecNode<?, ?> execNode;
        private final List<ExecNodeWrapper> inputs;
        private final List<ExecNodeWrapper> outputs;
        private MultipleInputGroup group;

        private ExecNodeWrapper(ExecNode<?, ?> execNode) {
            this.execNode = execNode;
            this.inputs = new ArrayList<ExecNodeWrapper>();
            this.outputs = new ArrayList<ExecNodeWrapper>();
            this.group = null;
        }
    }
}

