/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecTemporalJoinToCoProcessTranslator$;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.temporal.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.operators.join.temporal.TemporalProcessTimeJoinOperator;
import org.apache.flink.table.runtime.operators.join.temporal.TemporalRowTimeJoinOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u0001\u0003\u0001U\u00111f\u0015;sK\u0006lW\t_3d)\u0016l\u0007o\u001c:bY*{\u0017N\u001c+p\u0007>\u0004&o\\2fgN$&/\u00198tY\u0006$xN\u001d\u0006\u0003\u0007\u0011\taa\u001d;sK\u0006l'BA\u0003\u0007\u0003!\u0001\b._:jG\u0006d'BA\u0004\t\u0003\u0015qw\u000eZ3t\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001aD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0016i\u0016DH/^1m%\u0016\u0004(/Z:f]R\fG/[8o!\tybE\u0004\u0002!IA\u0011\u0011\u0005G\u0007\u0002E)\u00111\u0005F\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015B\u0012A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!\n\r\t\u0011)\u0002!\u0011!Q\u0001\n-\naaY8oM&<\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\r\u0003\r\t\u0007/[\u0005\u0003a5\u00121\u0002V1cY\u0016\u001cuN\u001c4jO\"A!\u0007\u0001B\u0001B\u0003%1'\u0001\u0006sKR,(O\u001c+za\u0016\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u000f1|w-[2bY*\u0011\u0001\bD\u0001\u0006if\u0004Xm]\u0005\u0003uU\u0012qAU8x)f\u0004X\r\u0003\u0005=\u0001\t\u0005\t\u0015!\u00034\u00035aWM\u001a;J]B,H\u000fV=qK\"Aa\b\u0001B\u0001B\u0003%1'\u0001\bsS\u001eDG/\u00138qkR$\u0016\u0010]3\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005\u000b\u0001B[8j]&sgm\u001c\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bAaY8sK*\u0011aiR\u0001\u0004e\u0016d'B\u0001%\u0011\u0003\u001d\u0019\u0017\r\\2ji\u0016L!AS\"\u0003\u0011){\u0017N\\%oM>D\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!T\u0001\u000be\u0016D()^5mI\u0016\u0014\bC\u0001(R\u001b\u0005y%B\u0001)H\u0003\r\u0011X\r_\u0005\u0003%>\u0013!BU3y\u0005VLG\u000eZ3s\u0011!!\u0006A!A!\u0002\u0013)\u0016a\b7fMR$\u0016.\\3BiR\u0014\u0018NY;uK&s\u0007/\u001e;SK\u001a,'/\u001a8dKB\u0011qCV\u0005\u0003/b\u00111!\u00138u\u0011!I\u0006A!A!\u0002\u0013Q\u0016a\t:jO\"$(k\\<US6,\u0017\t\u001e;sS\n,H/Z%oaV$(+\u001a4fe\u0016t7-\u001a\t\u0004/m+\u0016B\u0001/\u0019\u0005\u0019y\u0005\u000f^5p]\"Aa\f\u0001B\u0001B\u0003%q,\u0001\u0010sK6\f\u0017N\\5oO:{g.R9vS*{\u0017N\u001c)sK\u0012L7-\u0019;fgB\u0011a\nY\u0005\u0003C>\u0013qAU3y\u001d>$W\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0003YI7\u000fV3na>\u0014\u0018\r\u001c$v]\u000e$\u0018n\u001c8K_&t\u0007CA\ff\u0013\t1\u0007DA\u0004C_>dW-\u00198\t\u000b!\u0004A\u0011B5\u0002\rqJg.\u001b;?)1QG.\u001c8paF\u00148\u000f^;w!\tY\u0007!D\u0001\u0003\u0011\u0015ir\r1\u0001\u001f\u0011\u0015Qs\r1\u0001,\u0011\u0015\u0011t\r1\u00014\u0011\u0015at\r1\u00014\u0011\u0015qt\r1\u00014\u0011\u0015\u0001u\r1\u0001B\u0011\u0015au\r1\u0001N\u0011\u0015!v\r1\u0001V\u0011\u0015Iv\r1\u0001[\u0011\u0015qv\r1\u0001`\u0011\u0015\u0019w\r1\u0001e\u0011\u001dA\bA1A\u0005\u0002e\fQC\\8o\u000bF,\u0018NS8j]B\u0013X\rZ5dCR,7/F\u0001{!\r92l\u0018\u0005\u0007y\u0002\u0001\u000b\u0011\u0002>\u0002-9|g.R9vS*{\u0017N\u001c)sK\u0012L7-\u0019;fg\u0002BQA \u0001\u0005\u0002}\f!cZ3u\u0019\u00164GoS3z'\u0016dWm\u0019;peV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003-YW-_:fY\u0016\u001cGo\u001c:\u000b\u0007\u0005-A\"A\u0004sk:$\u0018.\\3\n\t\u0005=\u0011Q\u0001\u0002\u0013%><H)\u0019;b\u0017\u0016L8+\u001a7fGR|'\u000f\u0003\u0004\u0002\u0014\u0001!\ta`\u0001\u0014O\u0016$(+[4ii.+\u0017pU3mK\u000e$xN\u001d\u0005\b\u0003/\u0001A\u0011AA\r\u0003=9W\r\u001e&pS:|\u0005/\u001a:bi>\u0014HCBA\u000e\u0003s\t\u0019\u0005\u0005\u0006\u0002\u001e\u0005%\u0012QFA\u0017\u0003[i!!a\b\u000b\t\u0005\u0005\u00121E\u0001\n_B,'/\u0019;peNT1ALA\u0013\u0015\r\t9CD\u0001\ngR\u0014X-Y7j]\u001eLA!a\u000b\u0002 \t1Bk^8J]B,Ho\u0015;sK\u0006lw\n]3sCR|'\u000f\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019\u0004D\u0001\u0005I\u0006$\u0018-\u0003\u0003\u00028\u0005E\"a\u0002*po\u0012\u000bG/\u0019\u0005\t\u0003w\t)\u00021\u0001\u0002>\u0005A!n\\5o)f\u0004X\rE\u0002C\u0003\u007fI1!!\u0011D\u0005-Qu.\u001b8SK2$\u0016\u0010]3\t\u0011\u0005\u0015\u0013Q\u0003a\u0001\u0003\u000f\n\u0001C]3ukJtg)[3mI:\u000bW.Z:\u0011\u000b\u0005%\u00131\u000b\u0010\u000f\t\u0005-\u0013q\n\b\u0004C\u00055\u0013\"A\r\n\u0007\u0005E\u0003$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0013q\u000b\u0002\u0004'\u0016\f(bAA)1!9\u00111\f\u0001\u0005\u0012\u0005u\u0013AE2sK\u0006$XMS8j]>\u0003XM]1u_J$\u0002\"a\u0007\u0002`\u0005\r\u0014Q\r\u0005\b\u0003C\nI\u00061\u0001,\u0003-!\u0018M\u00197f\u0007>tg-[4\t\u0011\u0005m\u0012\u0011\fa\u0001\u0003{A\u0001\"a\u001a\u0002Z\u0001\u0007\u0011\u0011N\u0001\u0017O\u0016tWM]1uK\u0012Tu.\u001b8D_:$\u0017\u000e^5p]B!\u00111NA9\u001b\t\tiG\u0003\u0003\u0002p\u0005%\u0011!C4f]\u0016\u0014\u0018\r^3e\u0013\u0011\t\u0019(!\u001c\u0003-\u001d+g.\u001a:bi\u0016$'j\\5o\u0007>tG-\u001b;j_:<q!a\u001e\u0003\u0011\u0003\tI(A\u0016TiJ,\u0017-\\#yK\u000e$V-\u001c9pe\u0006d'j\\5o)>\u001cu\u000e\u0015:pG\u0016\u001c8\u000f\u0016:b]Nd\u0017\r^8s!\rY\u00171\u0010\u0004\u0007\u0003\tA\t!! \u0014\u0007\u0005md\u0003C\u0004i\u0003w\"\t!!!\u0015\u0005\u0005e\u0004\u0002CAC\u0003w\"\t!a\"\u0002\r\r\u0014X-\u0019;f)=Q\u0017\u0011RAF\u0003\u001b\u000by)a'\u0002 \u0006\u0005\u0006BB\u000f\u0002\u0004\u0002\u0007a\u0004\u0003\u0004+\u0003\u0007\u0003\ra\u000b\u0005\u0007e\u0005\r\u0005\u0019A\u001a\t\u0011\u0005E\u00151\u0011a\u0001\u0003'\u000b\u0011\u0002\\3gi&s\u0007/\u001e;\u0011\t\u0005U\u0015qS\u0007\u0002\u000b&\u0019\u0011\u0011T#\u0003\u000fI+GNT8eK\"A\u0011QTAB\u0001\u0004\t\u0019*\u0001\u0006sS\u001eDG/\u00138qkRDa\u0001QAB\u0001\u0004\t\u0005B\u0002'\u0002\u0004\u0002\u0007QJB\u0004\u0002&\u0006mD!a*\u0003=Q+W\u000e]8sC2Tu.\u001b8D_:$\u0017\u000e^5p]\u0016CHO]1di>\u00148\u0003BAR\u0003S\u00032ATAV\u0013\r\tik\u0014\u0002\u000b%\u0016D8\u000b[;ui2,\u0007\"C\u000f\u0002$\n\u0005\t\u0015!\u0003\u001f\u0011)\t\u0019,a)\u0003\u0002\u0003\u0006I!V\u0001\u0018e&<\u0007\u000e^&fsN\u001cF/\u0019:uS:<wJ\u001a4tKRD\u0011\u0002QAR\u0005\u0003\u0005\u000b\u0011B!\t\u00131\u000b\u0019K!A!\u0002\u0013i\u0005\"C2\u0002$\n\u0005\t\u0015!\u0003e\u0011\u001dA\u00171\u0015C\u0001\u0003{#B\"a0\u0002D\u0006\u0015\u0017qYAe\u0003\u0017\u0004B!!1\u0002$6\u0011\u00111\u0010\u0005\u0007;\u0005m\u0006\u0019\u0001\u0010\t\u000f\u0005M\u00161\u0018a\u0001+\"1\u0001)a/A\u0002\u0005Ca\u0001TA^\u0001\u0004i\u0005BB2\u0002<\u0002\u0007A\rC\u0005\u0002P\u0006\r\u0006\u0019!C\u0001s\u0006\tB.\u001a4u)&lW-\u0011;ue&\u0014W\u000f^3\t\u0015\u0005M\u00171\u0015a\u0001\n\u0003\t).A\u000bmK\u001a$H+[7f\u0003R$(/\u001b2vi\u0016|F%Z9\u0015\t\u0005]\u0017Q\u001c\t\u0004/\u0005e\u0017bAAn1\t!QK\\5u\u0011%\ty.!5\u0002\u0002\u0003\u0007!0A\u0002yIEB\u0001\"a9\u0002$\u0002\u0006KA_\u0001\u0013Y\u00164G\u000fV5nK\u0006#HO]5ckR,\u0007\u0005C\u0005\u0002h\u0006\r\u0006\u0019!C\u0001s\u0006\u0011\"/[4iiRKW.Z!uiJL'-\u001e;f\u0011)\tY/a)A\u0002\u0013\u0005\u0011Q^\u0001\u0017e&<\u0007\u000e\u001e+j[\u0016\fE\u000f\u001e:jEV$Xm\u0018\u0013fcR!\u0011q[Ax\u0011%\ty.!;\u0002\u0002\u0003\u0007!\u0010\u0003\u0005\u0002t\u0006\r\u0006\u0015)\u0003{\u0003M\u0011\u0018n\u001a5u)&lW-\u0011;ue&\u0014W\u000f^3!\u0011)\t90a)A\u0002\u0013\u0005\u0011\u0011`\u0001\u0010e&<\u0007\u000e\u001e)sS6\f'/_&fsV\u0011\u00111 \t\u0005/m\u000bi\u0010\u0005\u0003\u0018\u0003\u007f|\u0016b\u0001B\u00011\t)\u0011I\u001d:bs\"Q!QAAR\u0001\u0004%\tAa\u0002\u0002'ILw\r\u001b;Qe&l\u0017M]=LKf|F%Z9\u0015\t\u0005]'\u0011\u0002\u0005\u000b\u0003?\u0014\u0019!!AA\u0002\u0005m\b\"\u0003B\u0007\u0003G\u0003\u000b\u0015BA~\u0003A\u0011\u0018n\u001a5u!JLW.\u0019:z\u0017\u0016L\b\u0005\u0003\u0005\u0003\u0012\u0005\rF\u0011\tB\n\u0003%1\u0018n]5u\u0007\u0006dG\u000eF\u0002`\u0005+A\u0001Ba\u0006\u0003\u0010\u0001\u0007!\u0011D\u0001\u0005G\u0006dG\u000eE\u0002O\u00057I1A!\bP\u0005\u001d\u0011V\r_\"bY2D\u0001B!\t\u0002$\u0012%!1E\u0001\u0017Kb$(/Y2u!JLW.\u0019:z\u0017\u0016L\u0018I\u001d:bsR!\u0011Q B\u0013\u0011\u001d\t9Pa\bA\u0002}\u0003")
public class StreamExecTemporalJoinToCoProcessTranslator {
    private final TableConfig config;
    private final RowType leftInputType;
    private final RowType rightInputType;
    private final JoinInfo joinInfo;
    private final int leftTimeAttributeInputReference;
    private final Option<Object> rightRowTimeAttributeInputReference;
    private final boolean isTemporalFunctionJoin;
    private final Option<RexNode> nonEquiJoinPredicates;

    public static StreamExecTemporalJoinToCoProcessTranslator create(String string, TableConfig tableConfig, RowType rowType, RelNode relNode, RelNode relNode2, JoinInfo joinInfo, RexBuilder rexBuilder) {
        return StreamExecTemporalJoinToCoProcessTranslator$.MODULE$.create(string, tableConfig, rowType, relNode, relNode2, joinInfo, rexBuilder);
    }

    public Option<RexNode> nonEquiJoinPredicates() {
        return this.nonEquiJoinPredicates;
    }

    public RowDataKeySelector getLeftKeySelector() {
        return KeySelectorUtil.getRowDataSelector(this.joinInfo.leftKeys.toIntArray(), InternalTypeInfo.of(this.leftInputType));
    }

    public RowDataKeySelector getRightKeySelector() {
        return KeySelectorUtil.getRowDataSelector(this.joinInfo.rightKeys.toIntArray(), InternalTypeInfo.of(this.rightInputType));
    }

    public TwoInputStreamOperator<RowData, RowData, RowData> getJoinOperator(JoinRelType joinType, Seq<String> returnFieldNames) {
        String string;
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(this.config);
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        RowType x$3 = this.leftInputType;
        String x$4 = qual$1.bindInput$default$2();
        Option<int[]> x$5 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$3, x$4, x$5);
        RowType x$6 = this.rightInputType;
        String x$7 = qual$2.bindSecondInput$default$2();
        Option<int[]> x$8 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$6, x$7, x$8);
        if (this.nonEquiJoinPredicates().isEmpty()) {
            string = "return true;";
        } else {
            GeneratedExpression condition = exprGenerator.generateExpression((RexNode)this.nonEquiJoinPredicates().get());
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(condition.code()).append("\n         |return ").append(condition.resultTerm()).append(";\n         |").toString())).stripMargin();
        }
        String body = string;
        GeneratedJoinCondition generatedJoinCondition = FunctionCodeGenerator$.MODULE$.generateJoinCondition(ctx, "ConditionFunction", body, FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$4(), FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$5());
        return this.createJoinOperator(this.config, joinType, generatedJoinCondition);
    }

    public TwoInputStreamOperator<RowData, RowData, RowData> createJoinOperator(TableConfig tableConfig, JoinRelType joinType, GeneratedJoinCondition generatedJoinCondition) {
        BaseTwoInputStreamOperatorWithStateRetention baseTwoInputStreamOperatorWithStateRetention;
        if (this.isTemporalFunctionJoin) {
            JoinRelType joinRelType = joinType;
            JoinRelType joinRelType2 = JoinRelType.INNER;
            if (joinRelType == null ? joinRelType2 != null : !((Object)((Object)joinRelType)).equals((Object)joinRelType2)) {
                throw new ValidationException(new StringBuilder(78).append("Temporal table function join currently only support INNER JOIN, but was ").append(joinType.toString()).append(" JOIN.").toString());
            }
        } else {
            JoinRelType joinRelType = joinType;
            JoinRelType joinRelType3 = JoinRelType.LEFT;
            if (joinRelType == null ? joinRelType3 != null : !((Object)((Object)joinRelType)).equals((Object)joinRelType3)) {
                JoinRelType joinRelType4 = joinType;
                JoinRelType joinRelType5 = JoinRelType.INNER;
                if (joinRelType4 == null ? joinRelType5 != null : !((Object)((Object)joinRelType4)).equals((Object)joinRelType5)) {
                    throw new TableException(new StringBuilder(83).append("Temporal table join currently only support INNER JOIN and LEFT JOIN, but was ").append(joinType.toString()).append(" JOIN.").toString());
                }
            }
        }
        JoinRelType joinRelType = joinType;
        JoinRelType joinRelType6 = JoinRelType.LEFT;
        boolean isLeftOuterJoin = !(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType6) : joinRelType6 != null);
        long minRetentionTime = tableConfig.getMinIdleStateRetentionTime();
        long maxRetentionTime = tableConfig.getMaxIdleStateRetentionTime();
        if (this.rightRowTimeAttributeInputReference.isDefined()) {
            baseTwoInputStreamOperatorWithStateRetention = new TemporalRowTimeJoinOperator(InternalTypeInfo.of(this.leftInputType), InternalTypeInfo.of(this.rightInputType), generatedJoinCondition, this.leftTimeAttributeInputReference, BoxesRunTime.unboxToInt((Object)this.rightRowTimeAttributeInputReference.get()), minRetentionTime, maxRetentionTime, isLeftOuterJoin);
        } else if (this.isTemporalFunctionJoin) {
            baseTwoInputStreamOperatorWithStateRetention = new TemporalProcessTimeJoinOperator(InternalTypeInfo.of(this.rightInputType), generatedJoinCondition, minRetentionTime, maxRetentionTime, isLeftOuterJoin);
        } else {
            throw new TableException("Processing-time temporal join is not supported yet.");
        }
        return baseTwoInputStreamOperatorWithStateRetention;
    }

    public StreamExecTemporalJoinToCoProcessTranslator(String textualRepresentation, TableConfig config, RowType returnType, RowType leftInputType, RowType rightInputType, JoinInfo joinInfo, RexBuilder rexBuilder, int leftTimeAttributeInputReference, Option<Object> rightRowTimeAttributeInputReference, RexNode remainingNonEquiJoinPredicates, boolean isTemporalFunctionJoin) {
        this.config = config;
        this.leftInputType = leftInputType;
        this.rightInputType = rightInputType;
        this.joinInfo = joinInfo;
        this.leftTimeAttributeInputReference = leftTimeAttributeInputReference;
        this.rightRowTimeAttributeInputReference = rightRowTimeAttributeInputReference;
        this.isTemporalFunctionJoin = isTemporalFunctionJoin;
        this.nonEquiJoinPredicates = new Some((Object)remainingNonEquiJoinPredicates);
    }

    public static class TemporalJoinConditionExtractor
    extends RexShuttle {
        private final String textualRepresentation;
        private final int rightKeysStartingOffset;
        private final JoinInfo joinInfo;
        private final RexBuilder rexBuilder;
        private final boolean isTemporalFunctionJoin;
        private Option<RexNode> leftTimeAttribute;
        private Option<RexNode> rightTimeAttribute;
        private Option<RexNode[]> rightPrimaryKey;

        public Option<RexNode> leftTimeAttribute() {
            return this.leftTimeAttribute;
        }

        public void leftTimeAttribute_$eq(Option<RexNode> x$1) {
            this.leftTimeAttribute = x$1;
        }

        public Option<RexNode> rightTimeAttribute() {
            return this.rightTimeAttribute;
        }

        public void rightTimeAttribute_$eq(Option<RexNode> x$1) {
            this.rightTimeAttribute = x$1;
        }

        public Option<RexNode[]> rightPrimaryKey() {
            return this.rightPrimaryKey;
        }

        public void rightPrimaryKey_$eq(Option<RexNode[]> x$1) {
            this.rightPrimaryKey = x$1;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            block4: {
                SqlOperator sqlOperator = call.getOperator();
                SqlFunction sqlFunction = TemporalJoinUtil$.MODULE$.TEMPORAL_JOIN_CONDITION();
                if (sqlOperator == null ? sqlFunction != null : !((Object)sqlOperator).equals(sqlFunction)) {
                    return super.visitCall(call);
                }
                if (this.isTemporalFunctionJoin) {
                    Preconditions.checkState((this.leftTimeAttribute().isEmpty() && this.rightPrimaryKey().isEmpty() && this.rightTimeAttribute().isEmpty() ? 1 : 0) != 0, (String)"Multiple %s temporal functions in [%s]", (Object[])new Object[]{TemporalJoinUtil$.MODULE$.TEMPORAL_JOIN_CONDITION(), this.textualRepresentation});
                }
                if (TemporalJoinUtil$.MODULE$.isRowTimeTemporalTableJoinCon(call) || TemporalJoinUtil$.MODULE$.isRowTimeTemporalFunctionJoinCon(call)) {
                    this.leftTimeAttribute_$eq((Option<RexNode>)new Some((Object)call.getOperands().get(0)));
                    this.rightTimeAttribute_$eq((Option<RexNode>)new Some((Object)call.getOperands().get(1)));
                    this.rightPrimaryKey_$eq((Option<RexNode[]>)new Some((Object)this.extractPrimaryKeyArray(call.getOperands().get(2))));
                } else {
                    this.leftTimeAttribute_$eq((Option<RexNode>)new Some((Object)call.getOperands().get(0)));
                    this.rightPrimaryKey_$eq((Option<RexNode[]>)new Some((Object)this.extractPrimaryKeyArray(call.getOperands().get(1))));
                }
                if (!this.isTemporalFunctionJoin) break block4;
                TemporalJoinUtil$.MODULE$.validateTemporalFunctionCondition(call, (RexNode)this.leftTimeAttribute().get(), this.rightTimeAttribute(), this.rightPrimaryKey(), this.rightKeysStartingOffset, this.joinInfo, "Temporal Table Function");
            }
            return this.rexBuilder.makeLiteral(true);
        }

        private RexNode[] extractPrimaryKeyArray(RexNode rightPrimaryKey) {
            block3: {
                block2: {
                    if (!(rightPrimaryKey instanceof RexCall)) break block2;
                    SqlOperator sqlOperator = ((RexCall)rightPrimaryKey).getOperator();
                    SqlFunction sqlFunction = TemporalJoinUtil$.MODULE$.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY();
                    if (!(sqlOperator == null ? sqlFunction != null : !((Object)sqlOperator).equals(sqlFunction))) break block3;
                }
                throw new ValidationException(new StringBuilder(78).append("No primary key [").append((RexCall)rightPrimaryKey).append("] ").append("defined in versioned table of Event-time temporal table join").toString());
            }
            return (RexNode[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((RexCall)rightPrimaryKey).getOperands()).asScala()).toArray(ClassTag$.MODULE$.apply(RexNode.class));
        }

        public TemporalJoinConditionExtractor(String textualRepresentation, int rightKeysStartingOffset, JoinInfo joinInfo, RexBuilder rexBuilder, boolean isTemporalFunctionJoin) {
            this.textualRepresentation = textualRepresentation;
            this.rightKeysStartingOffset = rightKeysStartingOffset;
            this.joinInfo = joinInfo;
            this.rexBuilder = rexBuilder;
            this.isTemporalFunctionJoin = isTemporalFunctionJoin;
            this.leftTimeAttribute = None$.MODULE$;
            this.rightTimeAttribute = None$.MODULE$;
            this.rightPrimaryKey = None$.MODULE$;
        }
    }
}

