/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecGroupAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecLocalHashWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecLocalSortWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecWindowAggregateBase;
import org.apache.flink.table.planner.plan.stats.FiniteValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.stats.ValueInterval$;
import org.apache.flink.table.planner.plan.stats.WithLower;
import org.apache.flink.table.planner.plan.stats.WithUpper;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001E\u00111$Q4h\u0007\u0006dGnU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014(BA\u0002\u0005\u0003!iW\r^1eCR\f'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003E\u0002\u00141ii\u0011\u0001\u0006\u0006\u0003+Y\t1A]3y\u0015\t9B\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005e!\"A\u0004*fqZK7/\u001b;pe&k\u0007\u000f\u001c\t\u00047y\u0001S\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r=\u0003H/[8o!\tY\u0012%\u0003\u0002#9\t1Ai\\;cY\u0016D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0004C\u001e<\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0017\u0003\r\u0011X\r\\\u0005\u0003U\u001d\u0012qAU3m\u001d>$W\r\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003\ti\u0017\u000f\u0005\u0002/_5\t!!\u0003\u00021\u0005\t)b\t\\5oWJ+G.T3uC\u0012\fG/Y)vKJL\b\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\bF\u00025kY\u0002\"A\f\u0001\t\u000b\u0011\n\u0004\u0019A\u0013\t\u000b1\n\u0004\u0019A\u0017\t\u000fa\u0002!\u0019!C\u0005s\u0005Q!/\u001a=Ck&dG-\u001a:\u0016\u0003i\u0002\"aE\u001e\n\u0005q\"\"A\u0003*fq\n+\u0018\u000e\u001c3fe\"1a\b\u0001Q\u0001\ni\n1B]3y\u0005VLG\u000eZ3sA!9\u0001\t\u0001b\u0001\n\u0013\t\u0015AA:f+\u0005\u0011\u0005C\u0001\u0018D\u0013\t!%A\u0001\u000bTK2,7\r^5wSRLXi\u001d;j[\u0006$xN\u001d\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\"\u0002\u0007M,\u0007\u0005\u0003\u0005I\u0001\t\u0007I\u0011\u0001\u0006J\u0003e!WMZ1vYR\fumZ\"bY2\u001cV\r\\3di&4\u0018\u000e^=\u0016\u0003)\u00032aG&!\u0013\taED\u0001\u0003T_6,\u0007B\u0002(\u0001A\u0003%!*\u0001\u000eeK\u001a\fW\u000f\u001c;BO\u001e\u001c\u0015\r\u001c7TK2,7\r^5wSRL\b\u0005C\u0003Q\u0001\u0011\u0005\u0011+A\nhKR\u001cV\u000f\u001d9peR,G-Q4h\u0007\u0006dG\u000e\u0006\u0002S3B\u00191DH*\u0011\u0005Q;V\"A+\u000b\u0005Y;\u0013\u0001B2pe\u0016L!\u0001W+\u0003\u001b\u0005;wM]3hCR,7)\u00197m\u0011\u0015Qv\n1\u0001\\\u0003%yW\u000f\u001e9vi&#\u0007\u0010\u0005\u0002\u001c9&\u0011Q\f\b\u0002\u0004\u0013:$\b\"B0\u0001\t\u0003\u0001\u0017AE5t'V\u0004\bo\u001c:uK\u0012\fumZ\"bY2$\"!\u00193\u0011\u0005m\u0011\u0017BA2\u001d\u0005\u001d\u0011un\u001c7fC:DQ!\u001a0A\u0002M\u000bq!Y4h\u0007\u0006dG\u000eC\u0003h\u0001\u0011\u0005\u0001.\u0001\nhKR\fumZ\"bY2Le\u000e^3sm\u0006dGCA5p!\tQW.D\u0001l\u0015\taG!A\u0003ti\u0006$8/\u0003\u0002oW\nia+\u00197vK&sG/\u001a:wC2DQ!\u001a4A\u0002MCQ!\u001d\u0001\u0005\u0002I\f\u0001\"\u001a<bYV\fG/\u001a\u000b\u00035MDQ\u0001\u001e9A\u0002U\f\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\u0005M1\u0018BA<\u0015\u0005\u001d\u0011V\r\u001f(pI\u0016DQ!\u001f\u0001\u0005Bi\f\u0011B^5tSR\u001c\u0015\r\u001c7\u0015\u0005iY\b\"\u0002?y\u0001\u0004i\u0018\u0001B2bY2\u0004\"a\u0005@\n\u0005}$\"a\u0002*fq\u000e\u000bG\u000e\u001c\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003=)7\u000f^5nCR,w\n]3sC:$Gc\u0001\u0011\u0002\b!9\u0011\u0011BA\u0001\u0001\u0004)\u0018aB8qKJ\fg\u000e\u001a\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0003])7\u000f^5nCR,7+\u001b8hY\u0016\u0004&/\u001a3jG\u0006$X\rF\u0002\u001b\u0003#Aq!a\u0005\u0002\f\u0001\u0007Q0A\btS:<G.\u001a)sK\u0012L7-\u0019;f\u0011\u001d\t9\u0002\u0001C\u0005\u00033\t!#Z:uS6\fG/Z\"p[B\f'/[:p]R9!$a\u0007\u0002,\u0005=\u0002\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u0005=\u0004\b\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015b#A\u0002tc2LA!!\u000b\u0002$\tY1+\u001d7Pa\u0016\u0014\u0018\r^8s\u0011\u001d\ti#!\u0006A\u0002U\fA\u0001\\3gi\"9\u0011\u0011GA\u000b\u0001\u0004)\u0018!\u0002:jO\"$\bbBA\u001b\u0001\u0011%\u0011qG\u0001\u000fKN$\u0018.\\1uK\u0016\u000bX/\u00197t)\u0015Q\u0012\u0011HA\"\u0011!\tY$a\rA\u0002\u0005u\u0012\u0001C5oaV$(+\u001a4\u0011\u0007M\ty$C\u0002\u0002BQ\u00111BU3y\u0013:\u0004X\u000f\u001e*fM\"A\u0011QIA\u001a\u0001\u0004\t9%A\u0004mSR,'/\u00197\u0011\u0007M\tI%C\u0002\u0002LQ\u0011!BU3y\u0019&$XM]1m\u0011\u001d\t9\u0002\u0001C\u0005\u0003\u001f\"rAGA)\u0003'\n)\u0006\u0003\u0005\u0002\u001e\u00055\u0003\u0019AA\u0010\u0011!\tY$!\u0014A\u0002\u0005u\u0002\u0002CA#\u0003\u001b\u0002\r!a\u0012\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\\u0005IRm\u001d;j[\u0006$XMT;nKJL7mQ8na\u0006\u0014\u0018n]8o)\u001dQ\u0012QLA0\u0003CB\u0001\"!\b\u0002X\u0001\u0007\u0011q\u0004\u0005\u0007K\u0006]\u0003\u0019A*\t\u0011\u0005\u0015\u0013q\u000ba\u0001\u0003\u000f\u0002")
public class AggCallSelectivityEstimator
extends RexVisitorImpl<Option<Object>> {
    private final RelNode agg;
    private final FlinkRelMetadataQuery mq;
    private final RexBuilder rexBuilder;
    private final SelectivityEstimator se;
    private final Some<Object> defaultAggCallSelectivity;

    private RexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    private SelectivityEstimator se() {
        return this.se;
    }

    public Some<Object> defaultAggCallSelectivity() {
        return this.defaultAggCallSelectivity;
    }

    public Option<AggregateCall> getSupportedAggCall(int outputIdx) {
        Tuple2 tuple2;
        RelNode relNode = this.agg;
        if (relNode instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)relNode;
            Tuple2<int[], Seq<AggregateCall>> tuple22 = AggregateUtil$.MODULE$.checkAndSplitAggCalls(aggregate);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int[] auxGroupSet = (int[])tuple22._1();
            Seq otherAggCalls = (Seq)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)auxGroupSet, (Object)otherAggCalls);
            Tuple2 tuple24 = tuple23;
            int[] auxGroupSet2 = (int[])tuple24._1();
            Seq otherAggCalls2 = (Seq)tuple24._2();
            tuple2 = new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(aggregate.getGroupSet().toArray())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGroupSet2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), (Object)otherAggCalls2);
        } else if (relNode instanceof BatchExecGroupAggregateBase) {
            BatchExecGroupAggregateBase batchExecGroupAggregateBase = (BatchExecGroupAggregateBase)relNode;
            tuple2 = new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecGroupAggregateBase.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecGroupAggregateBase.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), batchExecGroupAggregateBase.getAggCallList());
        } else if (relNode instanceof BatchExecLocalHashWindowAggregate) {
            BatchExecLocalHashWindowAggregate batchExecLocalHashWindowAggregate = (BatchExecLocalHashWindowAggregate)relNode;
            int[] fullGrouping = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalHashWindowAggregate.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{batchExecLocalHashWindowAggregate.inputTimeFieldIndex()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalHashWindowAggregate.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            tuple2 = new Tuple2((Object)fullGrouping, batchExecLocalHashWindowAggregate.getAggCallList());
        } else if (relNode instanceof BatchExecLocalSortWindowAggregate) {
            BatchExecLocalSortWindowAggregate batchExecLocalSortWindowAggregate = (BatchExecLocalSortWindowAggregate)relNode;
            int[] fullGrouping = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalSortWindowAggregate.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{batchExecLocalSortWindowAggregate.inputTimeFieldIndex()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalSortWindowAggregate.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            tuple2 = new Tuple2((Object)fullGrouping, batchExecLocalSortWindowAggregate.getAggCallList());
        } else if (relNode instanceof BatchExecWindowAggregateBase) {
            BatchExecWindowAggregateBase batchExecWindowAggregateBase = (BatchExecWindowAggregateBase)relNode;
            tuple2 = new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecWindowAggregateBase.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecWindowAggregateBase.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), batchExecWindowAggregateBase.getAggCallList());
        } else {
            throw new IllegalArgumentException(new StringBuilder(15).append("Cannot handle ").append(this.agg.getRelTypeName()).append("!").toString());
        }
        Tuple2 tuple25 = tuple2;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        int[] fullGrouping = (int[])tuple25._1();
        Seq aggCalls = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)fullGrouping, (Object)aggCalls);
        Tuple2 tuple27 = tuple26;
        int[] fullGrouping2 = (int[])tuple27._1();
        Seq aggCalls2 = (Seq)tuple27._2();
        Predef$.MODULE$.require(outputIdx >= fullGrouping2.length);
        int aggCallIdx = outputIdx - fullGrouping2.length;
        AggregateCall aggCall2 = aggCallIdx < aggCalls2.length() ? (AggregateCall)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(aggCalls2).get(aggCallIdx) : null;
        return Option$.MODULE$.apply(aggCall2).filter((Function1 & Serializable & scala.Serializable)aggCall -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedAggCall(aggCall)));
    }

    public boolean isSupportedAggCall(AggregateCall aggCall) {
        SqlKind sqlKind = aggCall.getAggregation().getKind();
        boolean bl = ((Object)((Object)SqlKind.SUM)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MAX)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MIN)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.AVG)).equals((Object)sqlKind)));
        boolean bl2 = bl ? true : (((Object)((Object)SqlKind.COUNT)).equals((Object)sqlKind) ? aggCall.getArgList().size() == 1 : false);
        return bl2;
    }

    public ValueInterval getAggCallInterval(AggregateCall aggCall) {
        ValueInterval valueInterval;
        RelNode aggInput = this.agg.getInput(0);
        SqlKind sqlKind = aggCall.getAggregation().getKind();
        SqlKind sqlKind2 = SqlKind.COUNT;
        if (!(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)sqlKind2) : sqlKind2 != null)) {
            ValueInterval valueInterval2;
            Option option = this.getRowCntPerGroup$1(aggInput);
            if (option instanceof Some) {
                Some some = (Some)option;
                double rowCntPerGroup = BoxesRunTime.unboxToDouble((Object)some.value());
                double lower = package$.MODULE$.max(rowCntPerGroup / (double)2, 1.0);
                double upper = rowCntPerGroup * (double)2;
                valueInterval2 = ValueInterval$.MODULE$.apply(BoxesRunTime.boxToDouble((double)lower), BoxesRunTime.boxToDouble((double)upper), true, true);
            } else {
                valueInterval2 = null;
            }
            return valueInterval2;
        }
        ValueInterval argInterval = this.mq.getColumnInterval(aggInput, Predef$.MODULE$.Integer2int((Integer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(aggCall.getArgList()).head()));
        ValueInterval valueInterval3 = argInterval;
        if (valueInterval3 == null) {
            valueInterval = null;
        } else {
            ValueInterval valueInterval4 = ValueInterval$.MODULE$.infinite();
            ValueInterval valueInterval5 = valueInterval3;
            if (!(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null)) {
                valueInterval = ValueInterval$.MODULE$.infinite();
            } else {
                ValueInterval valueInterval6 = ValueInterval$.MODULE$.empty();
                ValueInterval valueInterval7 = valueInterval3;
                if (!(valueInterval6 != null ? !valueInterval6.equals(valueInterval7) : valueInterval7 != null)) {
                    valueInterval = ValueInterval$.MODULE$.empty();
                } else {
                    Tuple2 tuple2;
                    Tuple2 tuple22;
                    ValueInterval valueInterval8 = argInterval;
                    if (valueInterval8 instanceof WithLower) {
                        WithLower withLower = (WithLower)valueInterval8;
                        tuple22 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withLower.lower()), (Object)BoxesRunTime.boxToBoolean((boolean)withLower.includeLower()));
                    } else {
                        tuple22 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    Tuple2 tuple23 = tuple22;
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Double min = (Double)tuple23._1();
                    boolean includeMin = tuple23._2$mcZ$sp();
                    Tuple2 tuple24 = new Tuple2((Object)min, (Object)BoxesRunTime.boxToBoolean((boolean)includeMin));
                    Tuple2 tuple25 = tuple24;
                    Double min2 = (Double)tuple25._1();
                    boolean includeMin2 = tuple25._2$mcZ$sp();
                    ValueInterval valueInterval9 = argInterval;
                    if (valueInterval9 instanceof WithUpper) {
                        WithUpper withUpper = (WithUpper)valueInterval9;
                        tuple2 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withUpper.upper()), (Object)BoxesRunTime.boxToBoolean((boolean)withUpper.includeUpper()));
                    } else {
                        tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    Tuple2 tuple26 = tuple2;
                    if (tuple26 == null) {
                        throw new MatchError((Object)tuple26);
                    }
                    Double max = (Double)tuple26._1();
                    boolean includeMax = tuple26._2$mcZ$sp();
                    Tuple2 tuple27 = new Tuple2((Object)max, (Object)BoxesRunTime.boxToBoolean((boolean)includeMax));
                    Tuple2 tuple28 = tuple27;
                    Double max2 = (Double)tuple28._1();
                    boolean includeMax2 = tuple28._2$mcZ$sp();
                    valueInterval = ValueInterval$.MODULE$.apply(this.getAggCallValue$1(min2, aggCall, aggInput), this.getAggCallValue$1(max2, aggCall, aggInput), includeMin2, includeMax2);
                }
            }
        }
        return valueInterval;
    }

    public Option<Object> evaluate(RexNode predicate) {
        Option<Object> option;
        block5: {
            try {
                if (predicate == null) {
                    option = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                    break block5;
                }
                RexSimplify rexSimplify = new RexSimplify(this.rexBuilder(), RelOptPredicateList.EMPTY, true, RexUtil.EXECUTOR);
                RexNode simplifiedPredicate = rexSimplify.simplify(predicate);
                if (simplifiedPredicate.isAlwaysTrue()) {
                    option = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                    break block5;
                }
                if (simplifiedPredicate.isAlwaysFalse()) {
                    option = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                    break block5;
                }
                option = simplifiedPredicate.accept(this);
            }
            catch (Throwable throwable) {
                option = None$.MODULE$;
            }
        }
        return option;
    }

    @Override
    public Option<Object> visitCall(RexCall call) {
        Some some;
        List<RexNode> operands = call.getOperands();
        SqlOperator sqlOperator = call.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.AND;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            Buffer selectivity = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).map((Function1 & Serializable & scala.Serializable)operand -> BoxesRunTime.boxToDouble((double)this.estimateOperand(operand)), Buffer$.MODULE$.canBuildFrom());
            some = new Some(selectivity.product((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        } else {
            SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.OR;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                Buffer selectivity = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).map((Function1 & Serializable & scala.Serializable)operand -> BoxesRunTime.boxToDouble((double)this.estimateOperand(operand)), Buffer$.MODULE$.canBuildFrom());
                some = new Some((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.min(1.0, BoxesRunTime.unboxToDouble((Object)selectivity.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)selectivity.product((Numeric)Numeric.DoubleIsFractional$.MODULE$)))));
            } else {
                SqlPrefixOperator sqlPrefixOperator = SqlStdOperatorTable.NOT;
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlPrefixOperator != null ? !((Object)sqlPrefixOperator).equals(sqlOperator4) : sqlOperator4 != null)) {
                    double selectivity = this.estimateOperand((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head());
                    some = new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - selectivity)));
                } else {
                    some = this.estimateSinglePredicate(call);
                }
            }
        }
        return some;
    }

    public double estimateOperand(RexNode operand) {
        Option<Object> subSelectivity = operand.accept(this);
        return subSelectivity != null ? BoxesRunTime.unboxToDouble((Object)subSelectivity.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0)) : 1.0;
    }

    private Option<Object> estimateSinglePredicate(RexCall singlePredicate) {
        Object object;
        List<RexNode> operands = singlePredicate.getOperands();
        SqlOperator sqlOperator = singlePredicate.getOperator();
        SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.EQUALS;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
            object = this.estimateComparison((SqlOperator)SqlStdOperatorTable.EQUALS, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
        } else {
            SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.NOT_EQUALS;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                Option<Object> selectivity = this.estimateComparison((SqlOperator)SqlStdOperatorTable.EQUALS, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
                object = new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)selectivity.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0)))));
            } else {
                SqlBinaryOperator sqlBinaryOperator3 = SqlStdOperatorTable.GREATER_THAN;
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlBinaryOperator3 != null ? !((Object)sqlBinaryOperator3).equals(sqlOperator4) : sqlOperator4 != null)) {
                    object = this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
                } else {
                    SqlBinaryOperator sqlBinaryOperator4 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                    SqlOperator sqlOperator5 = sqlOperator;
                    if (!(sqlBinaryOperator4 != null ? !((Object)sqlBinaryOperator4).equals(sqlOperator5) : sqlOperator5 != null)) {
                        object = this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
                    } else {
                        SqlBinaryOperator sqlBinaryOperator5 = SqlStdOperatorTable.LESS_THAN;
                        SqlOperator sqlOperator6 = sqlOperator;
                        if (!(sqlBinaryOperator5 != null ? !((Object)sqlBinaryOperator5).equals(sqlOperator6) : sqlOperator6 != null)) {
                            object = this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
                        } else {
                            SqlBinaryOperator sqlBinaryOperator6 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                            SqlOperator sqlOperator7 = sqlOperator;
                            if (!(sqlBinaryOperator6 != null ? !((Object)sqlBinaryOperator6).equals(sqlOperator7) : sqlOperator7 != null)) {
                                object = this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).head(), (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operands).last());
                            } else {
                                SqlFunction sqlFunction = RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC;
                                SqlOperator sqlOperator8 = sqlOperator;
                                object = !(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator8) : sqlOperator8 != null) ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)RelMdUtil.getSelectivityValue(singlePredicate))) : this.se().defaultSelectivity();
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private Option<Object> estimateComparison(SqlOperator op, RexNode left, RexNode right) {
        block14: {
            block24: {
                block26: {
                    block25: {
                        block21: {
                            block23: {
                                block22: {
                                    block18: {
                                        block20: {
                                            block19: {
                                                block15: {
                                                    block17: {
                                                        block16: {
                                                            block11: {
                                                                block13: {
                                                                    block12: {
                                                                        if (!SelectivityEstimator$.MODULE$.isSupportedComparisonType(left.getType()) || !SelectivityEstimator$.MODULE$.isSupportedComparisonType(right.getType())) {
                                                                            var12_4 = op;
                                                                            v0 = SqlStdOperatorTable.EQUALS;
                                                                            var13_5 = var12_4;
                                                                            var10_6 = !(v0 != null ? v0.equals(var13_5) == false : var13_5 != null) ? this.se().defaultEqualsSelectivity() : this.se().defaultComparisonSelectivity();
                                                                            default = var10_6;
                                                                            return default;
                                                                        }
                                                                        var14_8 = op;
                                                                        v1 = SqlStdOperatorTable.EQUALS;
                                                                        var15_9 = var14_8;
                                                                        if (v1 != null ? v1.equals(var15_9) == false : var15_9 != null) break block11;
                                                                        var16_10 = new Tuple2((Object)left, (Object)right);
                                                                        if (var16_10 == null) break block12;
                                                                        i = (RexNode)var16_10._1();
                                                                        l = (RexNode)var16_10._2();
                                                                        if (!(i instanceof RexInputRef)) break block12;
                                                                        var19_13 = (RexInputRef)i;
                                                                        if (!(l instanceof RexLiteral)) break block12;
                                                                        var20_14 = (RexLiteral)l;
                                                                        var9_15 = this.estimateEquals(var19_13, var20_14);
                                                                        break block13;
                                                                    }
                                                                    if (var16_10 == null) ** GOTO lbl-1000
                                                                    l = (RexNode)var16_10._1();
                                                                    i = (RexNode)var16_10._2();
                                                                    if (!(l instanceof RexLiteral)) ** GOTO lbl-1000
                                                                    var23_18 = (RexLiteral)l;
                                                                    if (i instanceof RexInputRef) {
                                                                        var24_19 = (RexInputRef)i;
                                                                        var9_15 = this.estimateEquals(var24_19, var23_18);
                                                                    } else lbl-1000:
                                                                    // 3 sources

                                                                    {
                                                                        var9_15 = this.se().defaultEqualsSelectivity();
                                                                    }
                                                                }
                                                                var4_20 = var9_15;
                                                                break block14;
                                                            }
                                                            v2 = SqlStdOperatorTable.LESS_THAN;
                                                            var25_21 = var14_8;
                                                            if (v2 != null ? v2.equals(var25_21) == false : var25_21 != null) break block15;
                                                            var26_22 = new Tuple2((Object)left, (Object)right);
                                                            if (var26_22 == null) break block16;
                                                            i = (RexNode)var26_22._1();
                                                            l = (RexNode)var26_22._2();
                                                            if (!(i instanceof RexInputRef)) break block16;
                                                            var29_25 = (RexInputRef)i;
                                                            if (!(l instanceof RexLiteral)) break block16;
                                                            var30_26 = (RexLiteral)l;
                                                            var8_27 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN, var29_25, var30_26);
                                                            break block17;
                                                        }
                                                        if (var26_22 == null) ** GOTO lbl-1000
                                                        l = (RexNode)var26_22._1();
                                                        i = (RexNode)var26_22._2();
                                                        if (!(l instanceof RexLiteral)) ** GOTO lbl-1000
                                                        var33_30 = (RexLiteral)l;
                                                        if (i instanceof RexInputRef) {
                                                            var34_31 = (RexInputRef)i;
                                                            var8_27 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN, var34_31, var33_30);
                                                        } else lbl-1000:
                                                        // 3 sources

                                                        {
                                                            var8_27 = this.se().defaultComparisonSelectivity();
                                                        }
                                                    }
                                                    var4_20 = var8_27;
                                                    break block14;
                                                }
                                                v3 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                                                var35_32 = var14_8;
                                                if (v3 != null ? v3.equals(var35_32) == false : var35_32 != null) break block18;
                                                var36_33 = new Tuple2((Object)left, (Object)right);
                                                if (var36_33 == null) break block19;
                                                i = (RexNode)var36_33._1();
                                                l = (RexNode)var36_33._2();
                                                if (!(i instanceof RexInputRef)) break block19;
                                                var39_36 = (RexInputRef)i;
                                                if (!(l instanceof RexLiteral)) break block19;
                                                var40_37 = (RexLiteral)l;
                                                var7_38 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, var39_36, var40_37);
                                                break block20;
                                            }
                                            if (var36_33 == null) ** GOTO lbl-1000
                                            l = (RexNode)var36_33._1();
                                            i = (RexNode)var36_33._2();
                                            if (!(l instanceof RexLiteral)) ** GOTO lbl-1000
                                            var43_41 = (RexLiteral)l;
                                            if (i instanceof RexInputRef) {
                                                var44_42 = (RexInputRef)i;
                                                var7_38 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, var44_42, var43_41);
                                            } else lbl-1000:
                                            // 3 sources

                                            {
                                                var7_38 = this.se().defaultComparisonSelectivity();
                                            }
                                        }
                                        var4_20 = var7_38;
                                        break block14;
                                    }
                                    v4 = SqlStdOperatorTable.GREATER_THAN;
                                    var45_43 = var14_8;
                                    if (v4 != null ? v4.equals(var45_43) == false : var45_43 != null) break block21;
                                    var46_44 = new Tuple2((Object)left, (Object)right);
                                    if (var46_44 == null) break block22;
                                    i = (RexNode)var46_44._1();
                                    l = (RexNode)var46_44._2();
                                    if (!(i instanceof RexInputRef)) break block22;
                                    var49_47 = (RexInputRef)i;
                                    if (!(l instanceof RexLiteral)) break block22;
                                    var50_48 = (RexLiteral)l;
                                    var6_49 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN, var49_47, var50_48);
                                    break block23;
                                }
                                if (var46_44 == null) ** GOTO lbl-1000
                                l = (RexNode)var46_44._1();
                                i = (RexNode)var46_44._2();
                                if (!(l instanceof RexLiteral)) ** GOTO lbl-1000
                                var53_52 = (RexLiteral)l;
                                if (i instanceof RexInputRef) {
                                    var54_53 = (RexInputRef)i;
                                    var6_49 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN, var54_53, var53_52);
                                } else lbl-1000:
                                // 3 sources

                                {
                                    var6_49 = this.se().defaultComparisonSelectivity();
                                }
                            }
                            var4_20 = var6_49;
                            break block14;
                        }
                        v5 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                        var55_54 = var14_8;
                        if (v5 != null ? v5.equals(var55_54) == false : var55_54 != null) break block24;
                        var56_55 = new Tuple2((Object)left, (Object)right);
                        if (var56_55 == null) break block25;
                        i = (RexNode)var56_55._1();
                        l = (RexNode)var56_55._2();
                        if (!(i instanceof RexInputRef)) break block25;
                        var59_58 = (RexInputRef)i;
                        if (!(l instanceof RexLiteral)) break block25;
                        var60_59 = (RexLiteral)l;
                        var5_60 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, var59_58, var60_59);
                        break block26;
                    }
                    if (var56_55 == null) ** GOTO lbl-1000
                    l = (RexNode)var56_55._1();
                    i = (RexNode)var56_55._2();
                    if (!(l instanceof RexLiteral)) ** GOTO lbl-1000
                    var63_63 = (RexLiteral)l;
                    if (i instanceof RexInputRef) {
                        var64_64 = (RexInputRef)i;
                        var5_60 = this.estimateComparison((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, var64_64, var63_63);
                    } else lbl-1000:
                    // 3 sources

                    {
                        var5_60 = this.se().defaultComparisonSelectivity();
                    }
                }
                var4_20 = var5_60;
                break block14;
            }
            var4_20 = this.se().defaultComparisonSelectivity();
        }
        return var4_20;
    }

    private Option<Object> estimateEquals(RexInputRef inputRef, RexLiteral literal) {
        Some<Object> some;
        ValueInterval convertedInterval;
        if (literal.isNull()) {
            return this.se().defaultIsNullSelectivity();
        }
        Option<AggregateCall> aggCall = this.getSupportedAggCall(inputRef.getIndex());
        if (!SelectivityEstimator$.MODULE$.canConvertToNumericType(inputRef.getType()) || aggCall.isEmpty()) {
            return this.se().defaultEqualsSelectivity();
        }
        ValueInterval aggCallInterval = this.getAggCallInterval((AggregateCall)aggCall.get());
        if (aggCallInterval == null) {
            return this.se().defaultEqualsSelectivity();
        }
        ValueInterval valueInterval = convertedInterval = SelectivityEstimator$.MODULE$.convertValueInterval(aggCallInterval, inputRef.getType());
        ValueInterval valueInterval2 = ValueInterval$.MODULE$.infinite();
        ValueInterval valueInterval3 = valueInterval;
        if (!(valueInterval2 != null ? !valueInterval2.equals(valueInterval3) : valueInterval3 != null)) {
            some = this.se().defaultEqualsSelectivity();
        } else {
            ValueInterval valueInterval4 = ValueInterval$.MODULE$.empty();
            ValueInterval valueInterval5 = valueInterval;
            if (!(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null)) {
                some = this.defaultAggCallSelectivity();
            } else if (valueInterval instanceof FiniteValueInterval) {
                FiniteValueInterval finiteValueInterval = (FiniteValueInterval)valueInterval;
                Double min = SelectivityEstimator$.MODULE$.comparableToDouble(finiteValueInterval.lower());
                Double max = SelectivityEstimator$.MODULE$.comparableToDouble(finiteValueInterval.upper());
                some = ValueInterval$.MODULE$.contains(finiteValueInterval, SelectivityEstimator$.MODULE$.literalToComparable(literal)) ? new Some((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)this.defaultAggCallSelectivity().get()), 1.0 / (Predef$.MODULE$.Double2double(max) - Predef$.MODULE$.Double2double(min))))) : this.defaultAggCallSelectivity();
            } else {
                some = this.se().defaultEqualsSelectivity();
            }
        }
        return some;
    }

    private Option<Object> estimateComparison(SqlOperator op, RexInputRef inputRef, RexLiteral literal) {
        if (literal.isNull()) {
            throw new IllegalArgumentException("Numeric comparison does not support null literal here.");
        }
        Option<AggregateCall> aggCall = this.getSupportedAggCall(inputRef.getIndex());
        return SelectivityEstimator$.MODULE$.canConvertToNumericType(inputRef.getType()) && aggCall.isDefined() ? this.estimateNumericComparison(op, (AggregateCall)aggCall.get(), literal) : this.se().defaultComparisonSelectivity();
    }

    private Option<Object> estimateNumericComparison(SqlOperator op, AggregateCall aggCall, RexLiteral literal) {
        Some some;
        ValueInterval aggCallInterval = this.getAggCallInterval(aggCall);
        if (aggCallInterval == null) {
            return this.se().defaultComparisonSelectivity();
        }
        ValueInterval valueInterval = aggCallInterval;
        ValueInterval valueInterval2 = ValueInterval$.MODULE$.infinite();
        ValueInterval valueInterval3 = valueInterval;
        if (!(valueInterval2 != null ? !valueInterval2.equals(valueInterval3) : valueInterval3 != null)) {
            some = this.se().defaultComparisonSelectivity();
        } else {
            ValueInterval valueInterval4 = ValueInterval$.MODULE$.empty();
            ValueInterval valueInterval5 = valueInterval;
            if (!(valueInterval4 != null ? !valueInterval4.equals(valueInterval5) : valueInterval5 != null)) {
                some = this.defaultAggCallSelectivity();
            } else {
                double d;
                Tuple2.mcZZ.sp sp2;
                Tuple2 tuple2;
                Tuple2 tuple22;
                ValueInterval valueInterval6 = aggCallInterval;
                if (valueInterval6 instanceof WithLower) {
                    WithLower withLower = (WithLower)valueInterval6;
                    tuple22 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withLower.lower()), (Object)BoxesRunTime.boxToBoolean((boolean)withLower.includeLower()));
                } else {
                    tuple22 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                Double min = (Double)tuple23._1();
                boolean includeMin = tuple23._2$mcZ$sp();
                Tuple2 tuple24 = new Tuple2((Object)min, (Object)BoxesRunTime.boxToBoolean((boolean)includeMin));
                Tuple2 tuple25 = tuple24;
                Double min2 = (Double)tuple25._1();
                boolean includeMin2 = tuple25._2$mcZ$sp();
                ValueInterval valueInterval7 = aggCallInterval;
                if (valueInterval7 instanceof WithUpper) {
                    WithUpper withUpper = (WithUpper)valueInterval7;
                    tuple2 = new Tuple2((Object)SelectivityEstimator$.MODULE$.comparableToDouble(withUpper.upper()), (Object)BoxesRunTime.boxToBoolean((boolean)withUpper.includeUpper()));
                } else {
                    tuple2 = new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                Tuple2 tuple26 = tuple2;
                if (tuple26 == null) {
                    throw new MatchError((Object)tuple26);
                }
                Double max = (Double)tuple26._1();
                boolean includeMax = tuple26._2$mcZ$sp();
                Tuple2 tuple27 = new Tuple2((Object)max, (Object)BoxesRunTime.boxToBoolean((boolean)includeMax));
                Tuple2 tuple28 = tuple27;
                Double max2 = (Double)tuple28._1();
                boolean includeMax2 = tuple28._2$mcZ$sp();
                Double lit = SelectivityEstimator$.MODULE$.literalToDouble(literal);
                SqlOperator sqlOperator = op;
                SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.LESS_THAN;
                SqlOperator sqlOperator2 = sqlOperator;
                if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
                    boolean noOverlap = SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min2, lit);
                    boolean completeOverlap = includeMax2 ? SelectivityEstimator$.MODULE$.lessThan(max2, lit) : SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                    sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                } else {
                    SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                    SqlOperator sqlOperator3 = sqlOperator;
                    if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                        boolean noOverlap = includeMin2 ? SelectivityEstimator$.MODULE$.greaterThan(min2, lit) : SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min2, lit);
                        boolean completeOverlap = SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                        sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                    } else {
                        SqlBinaryOperator sqlBinaryOperator3 = SqlStdOperatorTable.GREATER_THAN;
                        SqlOperator sqlOperator4 = sqlOperator;
                        if (!(sqlBinaryOperator3 != null ? !((Object)sqlBinaryOperator3).equals(sqlOperator4) : sqlOperator4 != null)) {
                            boolean noOverlap = SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                            boolean completeOverlap = includeMin2 ? SelectivityEstimator$.MODULE$.greaterThan(min2, lit) : SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min2, lit);
                            sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                        } else {
                            SqlBinaryOperator sqlBinaryOperator4 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                            SqlOperator sqlOperator5 = sqlOperator;
                            if (!(sqlBinaryOperator4 != null ? !((Object)sqlBinaryOperator4).equals(sqlOperator5) : sqlOperator5 != null)) {
                                boolean noOverlap = includeMax2 ? SelectivityEstimator$.MODULE$.lessThan(max2, lit) : SelectivityEstimator$.MODULE$.lessThanOrEqualTo(max2, lit);
                                boolean completeOverlap = SelectivityEstimator$.MODULE$.greaterThanOrEqualTo(min2, lit);
                                sp2 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                            } else {
                                throw new MatchError((Object)sqlOperator);
                            }
                        }
                    }
                }
                Tuple2.mcZZ.sp sp3 = sp2;
                if (sp3 == null) {
                    throw new MatchError((Object)sp3);
                }
                boolean noOverlap = sp3._1$mcZ$sp();
                boolean completeOverlap = sp3._2$mcZ$sp();
                Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(noOverlap, completeOverlap);
                Tuple2.mcZZ.sp sp5 = sp4;
                boolean noOverlap2 = sp5._1$mcZ$sp();
                boolean completeOverlap2 = sp5._2$mcZ$sp();
                if (noOverlap2) {
                    d = BoxesRunTime.unboxToDouble((Object)this.defaultAggCallSelectivity().get());
                } else if (completeOverlap2) {
                    d = 1.0 - BoxesRunTime.unboxToDouble((Object)this.defaultAggCallSelectivity().get());
                } else if (min2 != null && max2 != null) {
                    double d2;
                    boolean bl;
                    SqlOperator sqlOperator6 = op;
                    SqlBinaryOperator sqlBinaryOperator5 = SqlStdOperatorTable.LESS_THAN;
                    SqlOperator sqlOperator7 = sqlOperator6;
                    if (!(sqlBinaryOperator5 != null ? !((Object)sqlBinaryOperator5).equals(sqlOperator7) : sqlOperator7 != null)) {
                        bl = true;
                    } else {
                        SqlBinaryOperator sqlBinaryOperator6 = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
                        SqlOperator sqlOperator8 = sqlOperator6;
                        bl = !(sqlBinaryOperator6 != null ? !((Object)sqlBinaryOperator6).equals(sqlOperator8) : sqlOperator8 != null);
                    }
                    if (bl) {
                        d2 = (Predef$.MODULE$.Double2double(lit) - Predef$.MODULE$.Double2double(min2)) / (Predef$.MODULE$.Double2double(max2) - Predef$.MODULE$.Double2double(min2));
                    } else {
                        boolean bl2;
                        SqlBinaryOperator sqlBinaryOperator7 = SqlStdOperatorTable.GREATER_THAN;
                        SqlOperator sqlOperator9 = sqlOperator6;
                        if (!(sqlBinaryOperator7 != null ? !((Object)sqlBinaryOperator7).equals(sqlOperator9) : sqlOperator9 != null)) {
                            bl2 = true;
                        } else {
                            SqlBinaryOperator sqlBinaryOperator8 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
                            SqlOperator sqlOperator10 = sqlOperator6;
                            bl2 = !(sqlBinaryOperator8 != null ? !((Object)sqlBinaryOperator8).equals(sqlOperator10) : sqlOperator10 != null);
                        }
                        if (bl2) {
                            d2 = (Predef$.MODULE$.Double2double(max2) - Predef$.MODULE$.Double2double(lit)) / (Predef$.MODULE$.Double2double(max2) - Predef$.MODULE$.Double2double(min2));
                        } else {
                            throw new MatchError((Object)sqlOperator6);
                        }
                    }
                    d = d2;
                } else {
                    d = BoxesRunTime.unboxToDouble((Object)this.se().defaultComparisonSelectivity().get());
                }
                double selectivity = d;
                some = new Some((Object)BoxesRunTime.boxToDouble((double)selectivity));
            }
        }
        return some;
    }

    private final Option getRowCntPerGroup$1(RelNode aggInput$1) {
        Double inputRowCnt = this.mq.getRowCount(aggInput$1);
        if (inputRowCnt == null) {
            return None$.MODULE$;
        }
        Double aggRowCnt = this.mq.getRowCount(this.agg);
        if (aggRowCnt == null) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(inputRowCnt) / Predef$.MODULE$.Double2double(aggRowCnt))));
    }

    private final Double getAggCallValue$1(Double v, AggregateCall aggCall$1, RelNode aggInput$1) {
        Double d;
        if (v == null) {
            return null;
        }
        SqlKind sqlKind = aggCall$1.getAggregation().getKind();
        boolean bl = ((Object)((Object)SqlKind.MAX)).equals((Object)sqlKind) ? true : (((Object)((Object)SqlKind.MIN)).equals((Object)sqlKind) ? true : ((Object)((Object)SqlKind.AVG)).equals((Object)sqlKind));
        if (bl) {
            d = v;
        } else if (((Object)((Object)SqlKind.SUM)).equals((Object)sqlKind)) {
            Double d2;
            Option option = this.getRowCntPerGroup$1(aggInput$1);
            if (option instanceof Some) {
                Some some = (Some)option;
                double rowCntPerGroup = BoxesRunTime.unboxToDouble((Object)some.value());
                d2 = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(v) * rowCntPerGroup);
            } else {
                d2 = null;
            }
            d = d2;
        } else {
            throw new MatchError((Object)sqlKind);
        }
        return d;
    }

    public AggCallSelectivityEstimator(RelNode agg, FlinkRelMetadataQuery mq) {
        this.agg = agg;
        this.mq = mq;
        super(true);
        this.rexBuilder = agg.getCluster().getRexBuilder();
        this.se = new SelectivityEstimator(agg, mq);
        this.defaultAggCallSelectivity = new Some((Object)BoxesRunTime.boxToDouble((double)0.01));
    }
}

