/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.planner.calcite.FlinkSqlNameMatcher;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.catalog.QueryOperationCatalogViewTable;
import org.apache.flink.table.planner.catalog.SqlCatalogViewTable;
import org.apache.flink.table.planner.plan.schema.CatalogSourceTable;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyCatalogSourceTable;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;

public class FlinkCalciteCatalogReader
extends CalciteCatalogReader {
    public FlinkCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> defaultSchemas, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        super(rootSchema, new FlinkSqlNameMatcher(SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), typeFactory), Stream.concat(defaultSchemas.stream(), Stream.of(Collections.emptyList())).collect(Collectors.toList()), typeFactory, config);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        SqlValidatorTable originRelOptTable = super.getTable((List)names);
        if (originRelOptTable == null) {
            return null;
        }
        CatalogSchemaTable table = originRelOptTable.unwrap(CatalogSchemaTable.class);
        if (table != null) {
            return FlinkCalciteCatalogReader.toPreparingTable(originRelOptTable.getRelOptSchema(), originRelOptTable.getQualifiedName(), originRelOptTable.getRowType(), table);
        }
        return originRelOptTable;
    }

    private static FlinkPreparingTableBase toPreparingTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable) {
        CatalogBaseTable baseTable = schemaTable.getCatalogTable();
        if (baseTable instanceof QueryOperationCatalogView) {
            return FlinkCalciteCatalogReader.convertQueryOperationView(relOptSchema, names, rowType, (QueryOperationCatalogView)baseTable);
        }
        if (baseTable instanceof ConnectorCatalogTable) {
            ConnectorCatalogTable connectorTable = (ConnectorCatalogTable)baseTable;
            if (connectorTable.getTableSource().isPresent()) {
                return FlinkCalciteCatalogReader.convertSourceTable(relOptSchema, rowType, schemaTable.getTableIdentifier(), connectorTable, schemaTable.getStatistic(), schemaTable.isStreamingMode());
            }
            throw new ValidationException("Cannot convert a connector table without source.");
        }
        if (baseTable instanceof CatalogView) {
            return FlinkCalciteCatalogReader.convertCatalogView(relOptSchema, names, rowType, schemaTable.getStatistic(), (CatalogView)baseTable);
        }
        if (baseTable instanceof CatalogTable) {
            return FlinkCalciteCatalogReader.convertCatalogTable(relOptSchema, names, rowType, (CatalogTable)baseTable, schemaTable);
        }
        throw new ValidationException("Unsupported table type: " + baseTable);
    }

    private static FlinkPreparingTableBase convertQueryOperationView(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, QueryOperationCatalogView view) {
        return QueryOperationCatalogViewTable.create(relOptSchema, names, rowType, view);
    }

    private static FlinkPreparingTableBase convertCatalogView(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, FlinkStatistic statistic, CatalogView view) {
        return new SqlCatalogViewTable(relOptSchema, rowType, names, statistic, view, names.subList(0, 2));
    }

    private static FlinkPreparingTableBase convertSourceTable(RelOptSchema relOptSchema, RelDataType rowType, ObjectIdentifier tableIdentifier, ConnectorCatalogTable<?, ?> table, FlinkStatistic statistic, boolean isStreamingMode) {
        TableSource<?> tableSource = table.getTableSource().get();
        if (!(tableSource instanceof StreamTableSource) && !(tableSource instanceof LookupableTableSource)) {
            throw new ValidationException("Only StreamTableSource and LookupableTableSource can be used in Blink planner.");
        }
        if (!isStreamingMode && tableSource instanceof StreamTableSource && !((StreamTableSource)tableSource).isBounded()) {
            throw new ValidationException("Only bounded StreamTableSource can be used in batch mode.");
        }
        return new LegacyTableSourceTable(relOptSchema, tableIdentifier, rowType, statistic, tableSource, isStreamingMode, table);
    }

    private static FlinkPreparingTableBase convertCatalogTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogTable catalogTable, CatalogSchemaTable schemaTable) {
        if (FlinkCalciteCatalogReader.isLegacySourceOptions(catalogTable, schemaTable)) {
            return new LegacyCatalogSourceTable(relOptSchema, names, rowType, schemaTable, catalogTable);
        }
        return new CatalogSourceTable(relOptSchema, names, rowType, schemaTable, catalogTable);
    }

    private static boolean isLegacySourceOptions(CatalogTable catalogTable, CatalogSchemaTable schemaTable) {
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(catalogTable.getOptions());
        if (properties.containsKey("connector.type")) {
            return true;
        }
        try {
            TableFactoryUtil.findAndCreateTableSource(schemaTable.getCatalog(), schemaTable.getTableIdentifier(), catalogTable, (ReadableConfig)new Configuration(), schemaTable.isTemporary());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

