/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.HashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;

@Internal
public class RichTableSourceQueryOperation<T>
extends TableSourceQueryOperation<T> {
    private final FlinkStatistic statistic;
    private final ObjectIdentifier identifier;

    public RichTableSourceQueryOperation(ObjectIdentifier identifier, TableSource<T> tableSource, FlinkStatistic statistic) {
        super(tableSource, false);
        Preconditions.checkArgument((boolean)(tableSource instanceof StreamTableSource), (Object)"Blink planner should always use StreamTableSource.");
        this.statistic = statistic;
        this.identifier = identifier;
    }

    @Override
    public String asSummaryString() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("fields", this.getTableSource().getTableSchema().getFieldNames());
        if (this.statistic != FlinkStatistic.UNKNOWN()) {
            args.put("statistic", this.statistic.toString());
        }
        return OperationUtils.formatWithChildren("TableSource", args, this.getChildren(), Operation::asSummaryString);
    }

    public ObjectIdentifier getIdentifier() {
        return this.identifier;
    }

    public FlinkStatistic getStatistic() {
        return this.statistic;
    }
}

