/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;

@Internal
public final class FlinkCalciteSqlValidator
extends SqlValidatorImpl {
    public FlinkCalciteSqlValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config) {
        super(opTab, catalogReader, typeFactory, config);
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        BigDecimal decimal;
        if (literal.getTypeName() == SqlTypeName.DECIMAL && (decimal = literal.getValueAs(BigDecimal.class)).precision() > 38) {
            throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(decimal.toString()));
        }
        super.validateLiteral(literal);
    }

    @Override
    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        if (join.getJoinType() == JoinType.LEFT && SqlUtil.stripAs(join.getRight()).getKind() == SqlKind.COLLECTION_TABLE) {
            SqlBasicCall call;
            Object operand0;
            SqlNode right = SqlUtil.stripAs(join.getRight());
            if (right instanceof SqlBasicCall && (operand0 = (call = (SqlBasicCall)right).operand(0)) instanceof SqlBasicCall && ((SqlBasicCall)operand0).getOperator() instanceof SqlWindowTableFunction) {
                return;
            }
            SqlNode condition = join.getCondition();
            if (!(condition == null || SqlUtil.isLiteral(condition) && ((SqlLiteral)condition).getValueAs(Boolean.class) == Boolean.TRUE)) {
                throw new ValidationException(String.format("Left outer joins with a table function do not accept a predicate such as %s. Only literal TRUE is accepted.", condition));
            }
        }
        super.validateJoin(join, scope);
    }

    @Override
    public void validateColumnListParams(SqlFunction function, List<RelDataType> argTypes, List<SqlNode> operands) {
    }
}

