/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.ArrayResultIterator;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.UserCodeClassLoader;

public class DeserializationSchemaAdapter
implements BulkFormat<RowData, FileSourceSplit> {
    private static final int BATCH_SIZE = 100;
    private final DeserializationSchema<RowData> deserializationSchema;
    private final String[] fieldNames;
    private final DataType[] fieldTypes;
    private final int[] projectFields;
    private final RowType projectedRowType;
    private final List<String> partitionKeys;
    private final String defaultPartValue;
    private final int[] toProjectedField;
    private final RowData.FieldGetter[] formatFieldGetters;

    public DeserializationSchemaAdapter(DeserializationSchema<RowData> deserializationSchema, TableSchema schema, int[] projectFields, List<String> partitionKeys, String defaultPartValue) {
        this.deserializationSchema = deserializationSchema;
        this.fieldNames = schema.getFieldNames();
        this.fieldTypes = schema.getFieldDataTypes();
        this.projectFields = projectFields;
        this.partitionKeys = partitionKeys;
        this.defaultPartValue = defaultPartValue;
        List<String> projectedNames = Arrays.stream(projectFields).mapToObj(idx -> schema.getFieldNames()[idx]).collect(Collectors.toList());
        this.projectedRowType = RowType.of((LogicalType[])Arrays.stream(projectFields).mapToObj(idx -> schema.getFieldDataTypes()[idx].getLogicalType()).toArray(LogicalType[]::new), projectedNames.toArray(new String[0]));
        List formatFields = Arrays.stream(schema.getFieldNames()).filter(field -> !partitionKeys.contains(field)).collect(Collectors.toList());
        List formatProjectedFields = projectedNames.stream().filter(field -> !partitionKeys.contains(field)).collect(Collectors.toList());
        this.toProjectedField = formatProjectedFields.stream().mapToInt(projectedNames::indexOf).toArray();
        this.formatFieldGetters = new RowData.FieldGetter[formatProjectedFields.size()];
        for (int i = 0; i < formatProjectedFields.size(); ++i) {
            String name = (String)formatProjectedFields.get(i);
            this.formatFieldGetters[i] = RowData.createFieldGetter(schema.getFieldDataType(name).get().getLogicalType(), formatFields.indexOf(name));
        }
    }

    private DeserializationSchema<RowData> createDeserialization() throws IOException {
        try {
            DeserializationSchema deserialization = (DeserializationSchema)InstantiationUtil.clone(this.deserializationSchema);
            deserialization.open(new DeserializationSchema.InitializationContext(){

                public MetricGroup getMetricGroup() {
                    throw new UnsupportedOperationException("MetricGroup is unsupported in BulkFormat.");
                }

                public UserCodeClassLoader getUserCodeClassLoader() {
                    return (UserCodeClassLoader)Thread.currentThread().getContextClassLoader();
                }
            });
            return deserialization;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Reader createReader(Configuration config, FileSourceSplit split) throws IOException {
        return new Reader(config, split);
    }

    public Reader restoreReader(Configuration config, FileSourceSplit split) throws IOException {
        Reader reader = new Reader(config, split);
        reader.seek(split.getReaderPosition().get().getRecordsAfterOffset());
        return reader;
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return InternalTypeInfo.of(this.projectedRowType);
    }

    private class LineBytesInputFormat
    extends DelimitedInputFormat<RowData> {
        private static final long serialVersionUID = 1L;
        private static final byte CARRIAGE_RETURN = 13;
        private static final byte NEW_LINE = 10;
        private final DeserializationSchema<RowData> deserializationSchema;
        private transient boolean end;
        private transient RecordCollector collector;
        private transient GenericRowData rowData;

        public LineBytesInputFormat(Path path, Configuration config) throws IOException {
            super(path, config);
            this.deserializationSchema = DeserializationSchemaAdapter.this.createDeserialization();
        }

        public void open(FileInputSplit split) throws IOException {
            super.open(split);
            this.end = false;
            this.collector = new RecordCollector();
            this.rowData = PartitionPathUtils.fillPartitionValueForRecord(DeserializationSchemaAdapter.this.fieldNames, DeserializationSchemaAdapter.this.fieldTypes, DeserializationSchemaAdapter.this.projectFields, DeserializationSchemaAdapter.this.partitionKeys, this.currentSplit.getPath(), DeserializationSchemaAdapter.this.defaultPartValue);
        }

        private GenericRowData newOutputRow() {
            GenericRowData row = new GenericRowData(this.rowData.getArity());
            for (int i = 0; i < row.getArity(); ++i) {
                row.setField(i, this.rowData.getField(i));
            }
            return row;
        }

        public boolean reachedEnd() {
            return this.end;
        }

        public RowData readRecord(RowData reuse, byte[] bytes, int offset, int numBytes) throws IOException {
            if (this.getDelimiter() != null && this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10 && offset + numBytes >= 1 && bytes[offset + numBytes - 1] == 13) {
                --numBytes;
            }
            byte[] trimBytes = Arrays.copyOfRange(bytes, offset, offset + numBytes);
            this.deserializationSchema.deserialize(trimBytes, (Collector)this.collector);
            return null;
        }

        private RowData convert(RowData record) {
            GenericRowData outputRow = this.newOutputRow();
            for (int i = 0; i < DeserializationSchemaAdapter.this.toProjectedField.length; ++i) {
                outputRow.setField(DeserializationSchemaAdapter.this.toProjectedField[i], DeserializationSchemaAdapter.this.formatFieldGetters[i].getFieldOrNull(record));
            }
            outputRow.setRowKind(record.getRowKind());
            return outputRow;
        }

        public RowData nextRecord(RowData reuse) throws IOException {
            while (true) {
                RowData record;
                if ((record = (RowData)this.collector.records.poll()) != null) {
                    return this.convert(record);
                }
                if (!this.readLine()) break;
                this.readRecord(reuse, this.currBuffer, this.currOffset, this.currLen);
            }
            this.end = true;
            return null;
        }

        private class RecordCollector
        implements Collector<RowData> {
            private final Queue<RowData> records = new ArrayDeque<RowData>();

            private RecordCollector() {
            }

            public void collect(RowData record) {
                this.records.add(record);
            }

            public void close() {
            }
        }
    }

    private class Reader
    implements BulkFormat.Reader<RowData> {
        private final LineBytesInputFormat inputFormat;
        private long numRead = 0L;

        private Reader(Configuration config, FileSourceSplit split) throws IOException {
            this.inputFormat = new LineBytesInputFormat(split.path(), config);
            this.inputFormat.open(new FileInputSplit(0, split.path(), split.offset(), split.length(), null));
        }

        @Override
        @Nullable
        public BulkFormat.RecordIterator<RowData> readBatch() throws IOException {
            RowData record;
            RowData[] records = new RowData[2048];
            int num = 0;
            long skipCount = this.numRead;
            for (int i = 0; i < 100 && (record = this.inputFormat.nextRecord(null)) != null; ++i) {
                records[num++] = record;
            }
            if (num == 0) {
                return null;
            }
            this.numRead += (long)num;
            ArrayResultIterator<RowData> iterator = new ArrayResultIterator<RowData>();
            iterator.set(records, num, -1L, skipCount);
            return iterator;
        }

        private void seek(long toSkip) throws IOException {
            while (toSkip > 0L) {
                this.inputFormat.nextRecord(null);
                --toSkip;
            }
        }

        @Override
        public void close() throws IOException {
            this.inputFormat.close();
        }
    }
}

