/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;

@Internal
public class RowRowConverter
implements DataStructureConverter<RowData, Row> {
    private static final long serialVersionUID = 1L;
    private final DataStructureConverter<Object, Object>[] fieldConverters;
    private final RowData.FieldGetter[] fieldGetters;

    private RowRowConverter(DataStructureConverter<Object, Object>[] fieldConverters, RowData.FieldGetter[] fieldGetters) {
        this.fieldConverters = fieldConverters;
        this.fieldGetters = fieldGetters;
    }

    @Override
    public void open(ClassLoader classLoader) {
        for (DataStructureConverter<Object, Object> fieldConverter : this.fieldConverters) {
            fieldConverter.open(classLoader);
        }
    }

    @Override
    public RowData toInternal(Row external) {
        int length = this.fieldConverters.length;
        GenericRowData genericRow = new GenericRowData(external.getKind(), length);
        for (int pos = 0; pos < length; ++pos) {
            Object value = external.getField(pos);
            genericRow.setField(pos, this.fieldConverters[pos].toInternalOrNull(value));
        }
        return genericRow;
    }

    @Override
    public Row toExternal(RowData internal) {
        int length = this.fieldConverters.length;
        Row row = new Row(internal.getRowKind(), length);
        for (int pos = 0; pos < length; ++pos) {
            Object value = this.fieldGetters[pos].getFieldOrNull(internal);
            row.setField(pos, this.fieldConverters[pos].toExternalOrNull(value));
        }
        return row;
    }

    public static RowRowConverter create(DataType dataType) {
        List<DataType> fields = dataType.getChildren();
        DataStructureConverter[] fieldConverters = (DataStructureConverter[])fields.stream().map(dt -> DataStructureConverters.getConverter(dt)).toArray(DataStructureConverter[]::new);
        RowData.FieldGetter[] fieldGetters = (RowData.FieldGetter[])IntStream.range(0, fields.size()).mapToObj(pos -> RowData.createFieldGetter(((DataType)fields.get(pos)).getLogicalType(), pos)).toArray(RowData.FieldGetter[]::new);
        return new RowRowConverter(fieldConverters, fieldGetters);
    }
}

