/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StaticFileSplitEnumerator
implements SplitEnumerator<FileSourceSplit, PendingSplitsCheckpoint<FileSourceSplit>> {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFileSplitEnumerator.class);
    private final SplitEnumeratorContext<FileSourceSplit> context;
    private final FileSplitAssigner splitAssigner;

    public StaticFileSplitEnumerator(SplitEnumeratorContext<FileSourceSplit> context, FileSplitAssigner splitAssigner) {
        this.context = (SplitEnumeratorContext)Preconditions.checkNotNull(context);
        this.splitAssigner = (FileSplitAssigner)Preconditions.checkNotNull((Object)splitAssigner);
    }

    public void start() {
    }

    public void close() throws IOException {
    }

    public void addReader(int subtaskId) {
    }

    public void handleSplitRequest(int subtask, @Nullable String hostname) {
        Optional<FileSourceSplit> nextSplit;
        if (!this.context.registeredReaders().containsKey(subtask)) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            String hostInfo = hostname == null ? "(no host locality info)" : "(on host '" + hostname + "')";
            LOG.info("Subtask {} {} is requesting a file source split", (Object)subtask, (Object)hostInfo);
        }
        if ((nextSplit = this.splitAssigner.getNext(hostname)).isPresent()) {
            FileSourceSplit split = nextSplit.get();
            this.context.assignSplit((SourceSplit)split, subtask);
            LOG.info("Assigned split to subtask {} : {}", (Object)subtask, (Object)split);
        } else {
            this.context.signalNoMoreSplits(subtask);
            LOG.info("No more splits available for subtask {}", (Object)subtask);
        }
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        LOG.error("Received unrecognized event: {}", (Object)sourceEvent);
    }

    public void addSplitsBack(List<FileSourceSplit> splits, int subtaskId) {
        LOG.debug("File Source Enumerator adds splits back: {}", splits);
        this.splitAssigner.addSplits(splits);
    }

    public PendingSplitsCheckpoint<FileSourceSplit> snapshotState() {
        return PendingSplitsCheckpoint.fromCollectionSnapshot(this.splitAssigner.remainingSplits());
    }
}

