/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;

public class RexProgramBuilder {
    private final RexBuilder rexBuilder;
    private final RelDataType inputRowType;
    private final List<RexNode> exprList = new ArrayList<RexNode>();
    private final Map<Pair<RexNode, String>, RexLocalRef> exprMap = new HashMap<Pair<RexNode, String>, RexLocalRef>();
    private final List<RexLocalRef> localRefList = new ArrayList<RexLocalRef>();
    private final List<RexLocalRef> projectRefList = new ArrayList<RexLocalRef>();
    private final List<String> projectNameList = new ArrayList<String>();
    private final RexSimplify simplify;
    private RexLocalRef conditionRef = null;
    private boolean validating;

    public RexProgramBuilder(RelDataType inputRowType, RexBuilder rexBuilder) {
        this(inputRowType, rexBuilder, null);
    }

    private RexProgramBuilder(RelDataType inputRowType, RexBuilder rexBuilder, RexSimplify simplify) {
        this.inputRowType = Objects.requireNonNull(inputRowType);
        this.rexBuilder = Objects.requireNonNull(rexBuilder);
        this.simplify = simplify;
        this.validating = RexProgramBuilder.assertionsAreEnabled();
        if (inputRowType.isStruct()) {
            List<RelDataTypeField> fields = inputRowType.getFieldList();
            for (int i = 0; i < fields.size(); ++i) {
                this.registerInternal(RexInputRef.of(i, fields), false);
            }
        }
    }

    private RexProgramBuilder(RexBuilder rexBuilder, RelDataType inputRowType, List<RexNode> exprList, Iterable<? extends RexNode> projectList, RexNode condition, RelDataType outputRowType, boolean normalize, RexSimplify simplify) {
        this(inputRowType, rexBuilder, simplify);
        RegisterMidputShuttle shuttle = new RegisterMidputShuttle(true, exprList);
        if (!normalize) {
            shuttle.visitEach(exprList);
        }
        RexProgram.ExpansionShuttle expander = new RexProgram.ExpansionShuttle(exprList);
        List<RelDataTypeField> fieldList = outputRowType.getFieldList();
        for (Pair<? extends RexNode, RelDataTypeField> pair : Pair.zip(projectList, fieldList)) {
            RexNode project = simplify != null ? simplify.simplify(((RexNode)pair.left).accept(expander)) : (RexNode)pair.left;
            String name = ((RelDataTypeField)pair.right).getName();
            RexLocalRef ref = (RexLocalRef)project.accept(shuttle);
            this.addProject(ref.getIndex(), name);
        }
        if (condition != null) {
            if (simplify != null && (condition = simplify.simplify(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, condition.accept(expander)))).isAlwaysTrue()) {
                condition = null;
            }
            if (condition != null) {
                RexLocalRef ref = (RexLocalRef)condition.accept(shuttle);
                this.addCondition(ref);
            }
        }
    }

    private static boolean assertionsAreEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    private void validate(final RexNode expr, final int fieldOrdinal) {
        RexVisitorImpl<Void> validator = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef input) {
                List<RelDataTypeField> fields;
                int index = input.getIndex();
                if (index < (fields = RexProgramBuilder.this.inputRowType.getFieldList()).size()) {
                    RelDataTypeField inputField = fields.get(index);
                    if (input.getType() != inputField.getType()) {
                        throw new AssertionError((Object)("in expression " + expr + ", field reference " + input + " has inconsistent type"));
                    }
                } else {
                    if (index >= fieldOrdinal) {
                        throw new AssertionError((Object)("in expression " + expr + ", field reference " + input + " is out of bounds"));
                    }
                    RexNode refExpr = (RexNode)RexProgramBuilder.this.exprList.get(index);
                    if (refExpr.getType() != input.getType()) {
                        throw new AssertionError((Object)("in expression " + expr + ", field reference " + input + " has inconsistent type"));
                    }
                }
                return null;
            }
        };
        expr.accept(validator);
    }

    public RexLocalRef addProject(RexNode expr, String name) {
        RexLocalRef ref = this.registerInput(expr);
        return this.addProject(ref.getIndex(), name);
    }

    public RexLocalRef addProject(int ordinal, String name) {
        RexLocalRef ref = this.localRefList.get(ordinal);
        this.projectRefList.add(ref);
        this.projectNameList.add(name);
        return ref;
    }

    public RexLocalRef addProject(int at, RexNode expr, String name) {
        RexLocalRef ref = this.registerInput(expr);
        this.projectRefList.add(at, ref);
        this.projectNameList.add(at, name);
        return ref;
    }

    public RexLocalRef addProject(int at, int ordinal, String name) {
        return this.addProject(at, this.localRefList.get(ordinal), name);
    }

    public void addCondition(RexNode expr) {
        assert (expr != null);
        if (this.conditionRef == null) {
            this.conditionRef = this.registerInput(expr);
        } else {
            RexLocalRef ref = this.registerInput(expr);
            if (!ref.equals(this.conditionRef)) {
                this.conditionRef = this.registerInput(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, this.conditionRef, ref));
            }
        }
    }

    public RexLocalRef registerInput(RexNode expr) {
        RegisterInputShuttle shuttle = new RegisterInputShuttle(true);
        RexNode ref = expr.accept(shuttle);
        return (RexLocalRef)ref;
    }

    public RexLocalRef registerOutput(RexNode expr) {
        RegisterOutputShuttle shuttle = new RegisterOutputShuttle(this.exprList);
        RexNode ref = expr.accept(shuttle);
        return (RexLocalRef)ref;
    }

    private RexLocalRef registerInternal(RexNode expr, boolean force) {
        int index;
        RexNode expr2;
        RexLocalRef ref;
        Pair<RexNode, String> key;
        RexSimplify simplify = new RexSimplify(this.rexBuilder, RelOptPredicateList.EMPTY, RexUtil.EXECUTOR);
        if ((expr = simplify.simplifyPreservingType(expr)) instanceof RexLocalRef) {
            key = null;
            ref = (RexLocalRef)expr;
        } else {
            key = RexUtil.makeKey(expr);
            ref = this.exprMap.get(key);
        }
        if (ref == null) {
            if (this.validating) {
                this.validate(expr, this.exprList.size());
            }
            ref = this.addExpr(expr);
            this.exprMap.put(key, ref);
        } else if (force) {
            this.addExpr(expr);
        }
        while ((expr2 = this.exprList.get(index = ref.index)) instanceof RexLocalRef) {
            ref = (RexLocalRef)expr2;
        }
        return ref;
    }

    public RexLocalRef addExpr(RexNode expr) {
        int index = this.exprList.size();
        this.exprList.add(expr);
        RexLocalRef ref = new RexLocalRef(index, expr.getType());
        this.localRefList.add(ref);
        return ref;
    }

    public RexProgram getProgram() {
        return this.getProgram(true);
    }

    public RexProgram getProgram(boolean normalize) {
        assert (this.projectRefList.size() == this.projectNameList.size());
        this.generateMissingNames();
        RelDataType outputRowType = this.computeOutputRowType();
        if (normalize) {
            return RexProgramBuilder.create(this.rexBuilder, this.inputRowType, this.exprList, this.projectRefList, this.conditionRef, outputRowType, true).getProgram(false);
        }
        return new RexProgram(this.inputRowType, this.exprList, this.projectRefList, this.conditionRef, outputRowType);
    }

    private RelDataType computeOutputRowType() {
        return RexUtil.createStructType(this.rexBuilder.typeFactory, this.projectRefList, this.projectNameList, null);
    }

    private void generateMissingNames() {
        int i = -1;
        int j = 0;
        for (String projectName : this.projectNameList) {
            String candidateName;
            ++i;
            if (projectName != null) continue;
            while (this.projectNameList.contains(candidateName = "$" + j++)) {
            }
            this.projectNameList.set(i, candidateName);
        }
    }

    public static RexProgramBuilder forProgram(RexProgram program, RexBuilder rexBuilder, boolean normalize) {
        assert (program.isValid(Litmus.THROW, null));
        RelDataType inputRowType = program.getInputRowType();
        List<RexLocalRef> projectRefs = program.getProjectList();
        RexLocalRef conditionRef = program.getCondition();
        List<RexNode> exprs = program.getExprList();
        RelDataType outputRowType = program.getOutputRowType();
        return RexProgramBuilder.create(rexBuilder, inputRowType, exprs, projectRefs, (RexNode)conditionRef, outputRowType, normalize, false);
    }

    public static RexProgramBuilder create(RexBuilder rexBuilder, RelDataType inputRowType, List<RexNode> exprList, List<? extends RexNode> projectList, RexNode condition, RelDataType outputRowType, boolean normalize, RexSimplify simplify) {
        return new RexProgramBuilder(rexBuilder, inputRowType, exprList, projectList, condition, outputRowType, normalize, simplify);
    }

    @Deprecated
    public static RexProgramBuilder create(RexBuilder rexBuilder, RelDataType inputRowType, List<RexNode> exprList, List<? extends RexNode> projectList, RexNode condition, RelDataType outputRowType, boolean normalize, boolean simplify_) {
        RexSimplify simplify = null;
        if (simplify_) {
            simplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, RexUtil.EXECUTOR);
        }
        return new RexProgramBuilder(rexBuilder, inputRowType, exprList, projectList, condition, outputRowType, normalize, simplify);
    }

    @Deprecated
    public static RexProgramBuilder create(RexBuilder rexBuilder, RelDataType inputRowType, List<RexNode> exprList, List<? extends RexNode> projectList, RexNode condition, RelDataType outputRowType, boolean normalize) {
        return RexProgramBuilder.create(rexBuilder, inputRowType, exprList, projectList, condition, outputRowType, normalize, null);
    }

    public static RexProgramBuilder create(RexBuilder rexBuilder, RelDataType inputRowType, List<RexNode> exprList, List<RexLocalRef> projectRefList, RexLocalRef conditionRef, RelDataType outputRowType, RexShuttle shuttle, boolean updateRefs) {
        RexProgramBuilder progBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        progBuilder.add(exprList, projectRefList, conditionRef, outputRowType, shuttle, updateRefs);
        return progBuilder;
    }

    @Deprecated
    public static RexProgram normalize(RexBuilder rexBuilder, RexProgram program) {
        return program.normalize(rexBuilder, null);
    }

    private void add(List<RexNode> exprList, List<RexLocalRef> projectRefList, RexLocalRef conditionRef, RelDataType outputRowType, RexShuttle shuttle, boolean updateRefs) {
        List<RelDataTypeField> outFields = outputRowType.getFieldList();
        RegisterInputShuttle registerInputShuttle = new RegisterInputShuttle(false);
        ArrayList<RexLocalRef> newRefs = new ArrayList<RexLocalRef>(exprList.size());
        UpdateRefShuttle refShuttle = new UpdateRefShuttle(newRefs);
        int i = 0;
        Iterator<RexNode> iterator = exprList.iterator();
        while (iterator.hasNext()) {
            RexNode expr;
            RexNode newExpr = expr = iterator.next();
            if (updateRefs) {
                newExpr = expr.accept(refShuttle);
            }
            newExpr = newExpr.accept(shuttle);
            newRefs.add(i++, (RexLocalRef)newExpr.accept(registerInputShuttle));
        }
        i = -1;
        for (RexLocalRef oldRef : projectRefList) {
            ++i;
            RexLocalRef ref = oldRef;
            if (updateRefs) {
                ref = (RexLocalRef)oldRef.accept(refShuttle);
            }
            ref = (RexLocalRef)ref.accept(shuttle);
            this.projectRefList.add(ref);
            String name = outFields.get(i).getName();
            assert (name != null);
            this.projectNameList.add(name);
        }
        if (conditionRef != null) {
            if (updateRefs) {
                conditionRef = (RexLocalRef)conditionRef.accept(refShuttle);
            }
            conditionRef = (RexLocalRef)conditionRef.accept(shuttle);
            this.addCondition(conditionRef);
        }
    }

    public static RexProgram mergePrograms(RexProgram topProgram, RexProgram bottomProgram, RexBuilder rexBuilder) {
        return RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder, true);
    }

    public static RexProgram mergePrograms(RexProgram topProgram, RexProgram bottomProgram, RexBuilder rexBuilder, boolean normalize) {
        assert (bottomProgram.isValid(Litmus.THROW, null));
        assert (topProgram.isValid(Litmus.THROW, null));
        RexProgramBuilder progBuilder = RexProgramBuilder.forProgram(bottomProgram, rexBuilder, false);
        List<RexLocalRef> projectRefList = progBuilder.registerProjectsAndCondition(topProgram);
        progBuilder.clearProjects();
        RelDataType outputRowType = topProgram.getOutputRowType();
        for (Pair<RexLocalRef, String> pair : Pair.zip(projectRefList, outputRowType.getFieldNames(), true)) {
            progBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        RexProgram mergedProg = progBuilder.getProgram(normalize);
        assert (mergedProg.isValid(Litmus.THROW, null));
        assert (mergedProg.getOutputRowType() == topProgram.getOutputRowType());
        return mergedProg;
    }

    private List<RexLocalRef> registerProjectsAndCondition(RexProgram program) {
        List<RexNode> exprList = program.getExprList();
        ArrayList<RexLocalRef> projectRefList = new ArrayList<RexLocalRef>();
        RegisterOutputShuttle shuttle = new RegisterOutputShuttle(exprList);
        for (RexLocalRef topProject : program.getProjectList()) {
            RexNode topExpr = exprList.get(topProject.getIndex());
            RexLocalRef expanded = (RexLocalRef)topExpr.accept(shuttle);
            projectRefList.add(expanded);
        }
        RexLocalRef topCondition = program.getCondition();
        if (topCondition != null) {
            RexNode topExpr = exprList.get(topCondition.getIndex());
            RexLocalRef expanded = (RexLocalRef)topExpr.accept(shuttle);
            this.addCondition(this.registerInput(expanded));
        }
        return projectRefList;
    }

    public void clearProjects() {
        this.projectRefList.clear();
        this.projectNameList.clear();
    }

    public void clearCondition() {
        this.conditionRef = null;
    }

    public void addIdentity() {
        assert (this.projectRefList.isEmpty());
        for (RelDataTypeField field : this.inputRowType.getFieldList()) {
            this.addProject(new RexInputRef(field.getIndex(), field.getType()), field.getName());
        }
    }

    public RexLocalRef makeInputRef(int index) {
        List<RelDataTypeField> fields = this.inputRowType.getFieldList();
        assert (index < fields.size());
        RelDataTypeField field = fields.get(index);
        return new RexLocalRef(index, field.getType());
    }

    public RelDataType getInputRowType() {
        return this.inputRowType;
    }

    public List<RexLocalRef> getProjectList() {
        return this.projectRefList;
    }

    private class UpdateRefShuttle
    extends RexShuttle {
        private List<RexLocalRef> newRefs;

        private UpdateRefShuttle(List<RexLocalRef> newRefs) {
            this.newRefs = newRefs;
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef localRef) {
            return this.newRefs.get(localRef.getIndex());
        }
    }

    private class RegisterOutputShuttle
    extends RegisterShuttle {
        private final List<RexNode> localExprList;

        RegisterOutputShuttle(List<RexNode> localExprList) {
            this.localExprList = localExprList;
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            int index = input.getIndex();
            RexLocalRef local = (RexLocalRef)RexProgramBuilder.this.projectRefList.get(index);
            assert (RelOptUtil.eq("type1", local.getType(), "type2", input.getType(), Litmus.THROW));
            return local;
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef local) {
            int index = local.getIndex();
            return this.localExprList.get(index).accept(this);
        }
    }

    private class RegisterMidputShuttle
    extends RegisterInputShuttle {
        private final List<RexNode> localExprList;

        protected RegisterMidputShuttle(boolean valid, List<RexNode> localExprList) {
            super(valid);
            this.localExprList = localExprList;
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef local) {
            int index = local.getIndex();
            return this.localExprList.get(index).accept(this);
        }
    }

    private class RegisterInputShuttle
    extends RegisterShuttle {
        private final boolean valid;

        protected RegisterInputShuttle(boolean valid) {
            this.valid = valid;
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            int index = input.getIndex();
            if (this.valid) {
                if (index < 0 || index >= RexProgramBuilder.this.inputRowType.getFieldCount()) assert (false) : "RexInputRef index " + index + " out of range 0.." + (RexProgramBuilder.access$000(RexProgramBuilder.this).getFieldCount() - 1);
                assert (input.getType().isStruct() || RelOptUtil.eq("type1", input.getType(), "type2", RexProgramBuilder.this.inputRowType.getFieldList().get(index).getType(), Litmus.THROW));
            }
            RexLocalRef ref = (RexLocalRef)RexProgramBuilder.this.localRefList.get(index);
            return ref;
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef local) {
            block5: {
                int index;
                if (this.valid) {
                    index = local.getIndex();
                    assert (index >= 0) : index;
                    assert (index < RexProgramBuilder.this.exprList.size()) : "index=" + index + ", exprList=" + RexProgramBuilder.access$100(RexProgramBuilder.this);
                    assert (RelOptUtil.eq("expr type", ((RexNode)RexProgramBuilder.this.exprList.get(index)).getType(), "ref type", local.getType(), Litmus.THROW));
                }
                do {
                    index = local.getIndex();
                    RexNode expr = (RexNode)RexProgramBuilder.this.exprList.get(index);
                    if (!(expr instanceof RexLocalRef)) break block5;
                    local = (RexLocalRef)expr;
                } while (local.index < index);
                throw new AssertionError((Object)("expr " + local + " references later expr " + local.index));
            }
            return RexProgramBuilder.this.registerInternal(local, false);
        }
    }

    private abstract class RegisterShuttle
    extends RexShuttle {
        private RegisterShuttle() {
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode expr = super.visitCall(call);
            return RexProgramBuilder.this.registerInternal(expr, false);
        }

        @Override
        public RexNode visitOver(RexOver over) {
            RexNode expr = super.visitOver(over);
            return RexProgramBuilder.this.registerInternal(expr, false);
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            RexNode expr = super.visitLiteral(literal);
            return RexProgramBuilder.this.registerInternal(expr, false);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode expr = super.visitFieldAccess(fieldAccess);
            return RexProgramBuilder.this.registerInternal(expr, false);
        }

        @Override
        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            RexNode expr = super.visitDynamicParam(dynamicParam);
            return RexProgramBuilder.this.registerInternal(expr, false);
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            RexNode expr = super.visitCorrelVariable(variable);
            return RexProgramBuilder.this.registerInternal(expr, false);
        }
    }
}

