/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

@Internal
public class LogicalTypeDuplicator
extends LogicalTypeDefaultVisitor<LogicalType> {
    @Override
    public LogicalType visit(ArrayType arrayType) {
        return new ArrayType(arrayType.isNullable(), arrayType.getElementType().accept(this));
    }

    @Override
    public LogicalType visit(MultisetType multisetType) {
        return new MultisetType(multisetType.isNullable(), multisetType.getElementType().accept(this));
    }

    @Override
    public LogicalType visit(MapType mapType) {
        return new MapType(mapType.isNullable(), mapType.getKeyType().accept(this), mapType.getValueType().accept(this));
    }

    @Override
    public LogicalType visit(RowType rowType) {
        List<RowType.RowField> fields2 = rowType.getFields().stream().map(f -> {
            if (f.getDescription().isPresent()) {
                return new RowType.RowField(f.getName(), f.getType().accept(this), f.getDescription().get());
            }
            return new RowType.RowField(f.getName(), f.getType().accept(this));
        }).collect(Collectors.toList());
        return new RowType(rowType.isNullable(), fields2);
    }

    @Override
    public LogicalType visit(DistinctType distinctType) {
        DistinctType.Builder builder = DistinctType.newBuilder(distinctType.getObjectIdentifier().orElseThrow(IllegalStateException::new), distinctType.getSourceType().accept(this));
        distinctType.getDescription().ifPresent(builder::description);
        return builder.build();
    }

    @Override
    public LogicalType visit(StructuredType structuredType) {
        StructuredType.Builder builder = this.instantiateStructuredBuilder(structuredType);
        builder.attributes(this.duplicateStructuredAttributes(structuredType));
        builder.setNullable(structuredType.isNullable());
        builder.setFinal(structuredType.isFinal());
        builder.setInstantiable(structuredType.isInstantiable());
        builder.comparision(structuredType.getComparision());
        structuredType.getSuperType().ifPresent(st -> {
            LogicalType visited = st.accept(this);
            if (!(visited instanceof StructuredType)) {
                throw new TableException("Unexpected super type. Structured type expected but was: " + visited);
            }
            builder.superType((StructuredType)visited);
        });
        structuredType.getDescription().ifPresent(builder::description);
        return builder.build();
    }

    @Override
    protected LogicalType defaultMethod(LogicalType logicalType) {
        return logicalType.copy();
    }

    private StructuredType.Builder instantiateStructuredBuilder(StructuredType structuredType) {
        Optional<ObjectIdentifier> identifier = structuredType.getObjectIdentifier();
        Optional<Class<?>> implementationClass = structuredType.getImplementationClass();
        if (identifier.isPresent() && implementationClass.isPresent()) {
            return StructuredType.newBuilder(identifier.get(), implementationClass.get());
        }
        if (identifier.isPresent()) {
            return StructuredType.newBuilder(identifier.get());
        }
        if (implementationClass.isPresent()) {
            return StructuredType.newBuilder(implementationClass.get());
        }
        throw new TableException("Invalid structured type.");
    }

    private List<StructuredType.StructuredAttribute> duplicateStructuredAttributes(StructuredType structuredType) {
        return structuredType.getAttributes().stream().map(a -> {
            if (a.getDescription().isPresent()) {
                return new StructuredType.StructuredAttribute(a.getName(), a.getType().accept(this), a.getDescription().get());
            }
            return new StructuredType.StructuredAttribute(a.getName(), a.getType().accept(this));
        }).collect(Collectors.toList());
    }
}

