/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.runtime.util.SegmentsUtil;

public class StringUtf8Utils {
    private static final int MAX_BYTES_PER_CHAR = 3;

    public static byte[] encodeUTF8(String str) {
        byte[] bytes = SegmentsUtil.allocateReuseBytes(str.length() * 3);
        int len = StringUtf8Utils.encodeUTF8(str, bytes);
        return Arrays.copyOf(bytes, len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(String str, byte[] bytes) {
        int offset = 0;
        int len = str.length();
        int sl = offset + len;
        int dp = 0;
        int dlASCII = dp + Math.min(len, bytes.length);
        while (dp < dlASCII && str.charAt(offset) < '\u0080') {
            bytes[dp++] = (byte)str.charAt(offset++);
        }
        while (offset < sl) {
            char c;
            if ((c = str.charAt(offset++)) < '\u0080') {
                bytes[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[dp++] = (byte)(0xC0 | c >> 6);
                bytes[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char c2;
                int ip = offset - 1;
                if (Character.isHighSurrogate(c)) {
                    if (sl - ip < 2) {
                        c2 = '\uffffffff';
                    } else {
                        char d = str.charAt(ip + 1);
                        if (!Character.isLowSurrogate(d)) return StringUtf8Utils.defaultEncodeUTF8(str, bytes);
                        c2 = Character.toCodePoint(c, d);
                    }
                } else {
                    if (Character.isLowSurrogate(c)) {
                        return StringUtf8Utils.defaultEncodeUTF8(str, bytes);
                    }
                    c2 = c;
                }
                if (c2 < '\u0000') {
                    bytes[dp++] = 63;
                    continue;
                }
                bytes[dp++] = (byte)(0xF0 | c2 >> 18);
                bytes[dp++] = (byte)(0x80 | c2 >> 12 & 0x3F);
                bytes[dp++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytes[dp++] = (byte)(0x80 | c2 & 0x3F);
                ++offset;
                continue;
            }
            bytes[dp++] = (byte)(0xE0 | c >> 12);
            bytes[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[dp++] = (byte)(0x80 | c & 0x3F);
        }
        return dp;
    }

    public static int defaultEncodeUTF8(String str, byte[] bytes) {
        try {
            byte[] buffer = str.getBytes("UTF-8");
            System.arraycopy(buffer, 0, bytes, 0, buffer.length);
            return buffer.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encodeUTF8 error", e);
        }
    }

    public static String decodeUTF8(byte[] input, int offset, int byteLen) {
        char[] chars = SegmentsUtil.allocateReuseChars(byteLen);
        int len = StringUtf8Utils.decodeUTF8Strict(input, offset, byteLen, chars);
        if (len < 0) {
            return StringUtf8Utils.defaultDecodeUTF8(input, offset, byteLen);
        }
        return new String(chars, 0, len);
    }

    public static int decodeUTF8Strict(byte[] sa, int sp2, int len, char[] da) {
        int sl = sp2 + len;
        int dp = 0;
        int dlASCII = Math.min(len, da.length);
        while (dp < dlASCII && sa[sp2] >= 0) {
            da[dp++] = (char)sa[sp2++];
        }
        while (sp2 < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = sa[sp2++]) >= 0) {
                da[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (sp2 < sl) {
                    if (((b2 = sa[sp2++]) & 0xC0) != 128) {
                        return -1;
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (sp2 + 1 < sl) {
                    b2 = sa[sp2++];
                    b3 = sa[sp2++];
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return -1;
                    }
                    da[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (sp2 + 2 < sl) {
                    b2 = sa[sp2++];
                    b3 = sa[sp2++];
                    byte b4 = sa[sp2++];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(uc)) {
                        return -1;
                    }
                    da[dp++] = Character.highSurrogate(uc);
                    da[dp++] = Character.lowSurrogate(uc);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static String decodeUTF8(MemorySegment input, int offset, int byteLen) {
        char[] chars = SegmentsUtil.allocateReuseChars(byteLen);
        int len = StringUtf8Utils.decodeUTF8Strict(input, offset, byteLen, chars);
        if (len < 0) {
            byte[] bytes = SegmentsUtil.allocateReuseBytes(byteLen);
            input.get(offset, bytes, 0, byteLen);
            return StringUtf8Utils.defaultDecodeUTF8(bytes, 0, byteLen);
        }
        return new String(chars, 0, len);
    }

    public static int decodeUTF8Strict(MemorySegment segment, int sp2, int len, char[] da) {
        int sl = sp2 + len;
        int dp = 0;
        int dlASCII = Math.min(len, da.length);
        while (dp < dlASCII && segment.get(sp2) >= 0) {
            da[dp++] = (char)segment.get(sp2++);
        }
        while (sp2 < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = segment.get(sp2++)) >= 0) {
                da[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (sp2 < sl) {
                    if (((b2 = segment.get(sp2++)) & 0xC0) != 128) {
                        return -1;
                    }
                    da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (sp2 + 1 < sl) {
                    b2 = segment.get(sp2++);
                    b3 = segment.get(sp2++);
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return -1;
                    }
                    da[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (sp2 + 2 < sl) {
                    b2 = segment.get(sp2++);
                    b3 = segment.get(sp2++);
                    byte b4 = segment.get(sp2++);
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || !Character.isSupplementaryCodePoint(uc)) {
                        return -1;
                    }
                    da[dp++] = Character.highSurrogate(uc);
                    da[dp++] = Character.lowSurrogate(uc);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static String defaultDecodeUTF8(byte[] bytes, int offset, int len) {
        return new String(bytes, offset, len, StandardCharsets.UTF_8);
    }
}

