/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;

public class SinkNotNullEnforcer
implements FilterFunction<RowData> {
    private static final long serialVersionUID = 1L;
    private final ExecutionConfigOptions.NotNullEnforcer notNullEnforcer;
    private final int[] notNullFieldIndices;
    private final boolean notNullCheck;
    private final String[] allFieldNames;

    public SinkNotNullEnforcer(ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, int[] notNullFieldIndices, String[] allFieldNames) {
        this.notNullFieldIndices = notNullFieldIndices;
        this.notNullEnforcer = notNullEnforcer;
        this.notNullCheck = notNullFieldIndices.length > 0;
        this.allFieldNames = allFieldNames;
    }

    public boolean filter(RowData row) {
        if (!this.notNullCheck) {
            return true;
        }
        for (int index : this.notNullFieldIndices) {
            if (!row.isNullAt(index)) continue;
            if (this.notNullEnforcer == ExecutionConfigOptions.NotNullEnforcer.ERROR) {
                String optionKey = ExecutionConfigOptions.TABLE_EXEC_SINK_NOT_NULL_ENFORCER.key();
                throw new TableException(String.format("Column '%s' is NOT NULL, however, a null value is being written into it. You can set job configuration '" + optionKey + "'='drop' to suppress this exception and drop such records silently.", this.allFieldNames[index]));
            }
            return false;
        }
        return true;
    }
}

