/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.context.ExecutionContextImpl;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.runtime.util.StreamRecordCollector;

public class BufferDataOverWindowOperator
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData>,
BoundedOneInput {
    private final OverWindowFrame[] overWindowFrames;
    private GeneratedRecordComparator genComparator;
    private final boolean isRowAllInFixedPart;
    private RecordComparator partitionComparator;
    private RowData lastInput;
    private JoinedRowData[] joinedRows;
    private StreamRecordCollector<RowData> collector;
    private AbstractRowDataSerializer<RowData> serializer;
    private ResettableExternalBuffer currentData;

    public BufferDataOverWindowOperator(OverWindowFrame[] overWindowFrames, GeneratedRecordComparator genComparator, boolean isRowAllInFixedPart) {
        this.overWindowFrames = overWindowFrames;
        this.genComparator = genComparator;
        this.isRowAllInFixedPart = isRowAllInFixedPart;
    }

    public void open() throws Exception {
        super.open();
        ClassLoader cl = this.getUserCodeClassloader();
        this.serializer = (AbstractRowDataSerializer)this.getOperatorConfig().getTypeSerializerIn1(cl);
        this.partitionComparator = (RecordComparator)this.genComparator.newInstance(cl);
        this.genComparator = null;
        MemoryManager memManager = this.getContainingTask().getEnvironment().getMemoryManager();
        LazyMemorySegmentPool pool = new LazyMemorySegmentPool((Object)this, memManager, (int)(this.computeMemorySize() / (long)memManager.getPageSize()));
        this.currentData = new ResettableExternalBuffer(this.getContainingTask().getEnvironment().getIOManager(), pool, this.serializer, this.isRowAllInFixedPart);
        this.collector = new StreamRecordCollector(this.output);
        this.joinedRows = new JoinedRowData[this.overWindowFrames.length];
        for (int i = 0; i < this.overWindowFrames.length; ++i) {
            this.overWindowFrames[i].open(new ExecutionContextImpl(this, (RuntimeContext)this.getRuntimeContext()));
            this.joinedRows[i] = new JoinedRowData();
        }
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData input = (RowData)element.getValue();
        if (this.lastInput != null && this.partitionComparator.compare(this.lastInput, input) != 0) {
            this.processCurrentData();
        }
        this.lastInput = (RowData)this.serializer.copy(input);
        this.currentData.add(this.lastInput);
    }

    public void endInput() throws Exception {
        if (this.currentData.size() > 0) {
            this.processCurrentData();
        }
    }

    private void processCurrentData() throws Exception {
        this.currentData.complete();
        for (OverWindowFrame frame : this.overWindowFrames) {
            frame.prepare(this.currentData);
        }
        int rowIndex = 0;
        ResettableExternalBuffer.BufferIterator bufferIterator = this.currentData.newIterator();
        while (bufferIterator.advanceNext()) {
            BinaryRowData currentRow2;
            RowData output = currentRow2 = bufferIterator.getRow();
            for (int i = 0; i < this.overWindowFrames.length; ++i) {
                OverWindowFrame frame = this.overWindowFrames[i];
                RowData value = frame.process(rowIndex, currentRow2);
                output = this.joinedRows[i].replace(output, value);
            }
            this.collector.collect(output);
            ++rowIndex;
        }
        bufferIterator.close();
        this.currentData.reset();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.currentData.close();
    }
}

