/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.hashtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.ChannelReaderInputViewIterator;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.HeaderlessChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.util.BitSet;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryRowDataUtil;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.hashtable.BaseHybridHashTable;
import org.apache.flink.table.runtime.hashtable.BinaryHashBucketArea;
import org.apache.flink.table.runtime.hashtable.BinaryHashPartition;
import org.apache.flink.table.runtime.hashtable.BuildSideIterator;
import org.apache.flink.table.runtime.hashtable.LookupBucketIterator;
import org.apache.flink.table.runtime.hashtable.ProbeIterator;
import org.apache.flink.table.runtime.hashtable.WrappedRowIterator;
import org.apache.flink.table.runtime.io.BinaryRowChannelInputViewIterator;
import org.apache.flink.table.runtime.io.ChannelWithMeta;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.operators.join.NullAwareJoinHelper;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.FileChannelUtil;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

public class BinaryHashTable
extends BaseHybridHashTable {
    final BinaryRowDataSerializer binaryBuildSideSerializer;
    private final AbstractRowDataSerializer originBuildSideSerializer;
    private final BinaryRowDataSerializer binaryProbeSideSerializer;
    private final AbstractRowDataSerializer originProbeSideSerializer;
    private final Projection<RowData, BinaryRowData> buildSideProjection;
    private final Projection<RowData, BinaryRowData> probeSideProjection;
    final int bucketsPerSegment;
    final int bucketsPerSegmentMask;
    final int bucketsPerSegmentBits;
    final boolean useBloomFilters;
    final ArrayList<BinaryHashPartition> partitionsBeingBuilt;
    final BitSet probedSet = new BitSet(2);
    private final ArrayList<BinaryHashPartition> partitionsPending;
    private final JoinCondition condFunc;
    private final boolean reverseJoin;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;
    LookupBucketIterator bucketIterator;
    private ProbeIterator probeIterator;
    final HashJoinType type;
    private RowIterator<BinaryRowData> buildIterator;
    private boolean probeMatchedPhase = true;
    private boolean buildIterVisited = false;
    private BinaryRowData probeKey;
    private RowData probeRow;
    BinaryRowData reuseBuildRow;

    public BinaryHashTable(Configuration conf, Object owner, AbstractRowDataSerializer buildSideSerializer, AbstractRowDataSerializer probeSideSerializer, Projection<RowData, BinaryRowData> buildSideProjection, Projection<RowData, BinaryRowData> probeSideProjection, MemoryManager memManager, long reservedMemorySize, IOManager ioManager, int avgRecordLen, long buildRowCount, boolean useBloomFilters, HashJoinType type, JoinCondition condFunc, boolean reverseJoin, boolean[] filterNulls2, boolean tryDistinctBuildRow) {
        super(conf, owner, memManager, reservedMemorySize, ioManager, avgRecordLen, buildRowCount, !type.buildLeftSemiOrAnti() && tryDistinctBuildRow);
        this.originBuildSideSerializer = buildSideSerializer;
        this.binaryBuildSideSerializer = new BinaryRowDataSerializer(buildSideSerializer.getArity());
        this.reuseBuildRow = this.binaryBuildSideSerializer.createInstance();
        this.originProbeSideSerializer = probeSideSerializer;
        this.binaryProbeSideSerializer = new BinaryRowDataSerializer(this.originProbeSideSerializer.getArity());
        this.buildSideProjection = buildSideProjection;
        this.probeSideProjection = probeSideProjection;
        this.useBloomFilters = useBloomFilters;
        this.type = type;
        this.condFunc = condFunc;
        this.reverseJoin = reverseJoin;
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNulls2);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNulls2.length;
        this.bucketsPerSegment = this.segmentSize >> 7;
        Preconditions.checkArgument((this.bucketsPerSegment != 0 ? 1 : 0) != 0, (Object)"Hash Table requires buffers of at least 128 bytes.");
        this.bucketsPerSegmentMask = this.bucketsPerSegment - 1;
        this.bucketsPerSegmentBits = MathUtils.log2strict((int)this.bucketsPerSegment);
        this.partitionsBeingBuilt = new ArrayList();
        this.partitionsPending = new ArrayList();
        this.createPartitions(this.initPartitionFanOut, 0);
    }

    public void putBuildRow(RowData row) throws IOException {
        int hashCode2 = BinaryHashTable.hash(this.buildSideProjection.apply(row).hashCode(), 0);
        this.insertIntoTable(this.originBuildSideSerializer.toBinaryRow(row), hashCode2);
    }

    public void endBuild() throws IOException {
        int buildWriteBuffers = 0;
        for (BinaryHashPartition p : this.partitionsBeingBuilt) {
            buildWriteBuffers += p.finalizeBuildPhase(this.ioManager, this.currentEnumerator);
        }
        this.buildSpillRetBufferNumbers += buildWriteBuffers;
        this.probeIterator = new ProbeIterator(this.binaryProbeSideSerializer.createInstance());
        this.bucketIterator = new LookupBucketIterator(this);
    }

    public boolean tryProbe(RowData record) throws IOException {
        BinaryRowData probeKey;
        int hash2;
        BinaryHashPartition p;
        if (!this.probeIterator.hasSource()) {
            this.probeIterator.setInstance(record);
        }
        if ((p = this.partitionsBeingBuilt.get((hash2 = BinaryHashTable.hash((probeKey = this.probeSideProjection.apply(record)).hashCode(), this.currentRecursionDepth)) % this.partitionsBeingBuilt.size())).isInMemory()) {
            this.probeKey = probeKey;
            this.probeRow = record;
            p.bucketArea.startLookup(hash2);
            return true;
        }
        if (p.testHashBloomFilter(hash2)) {
            BinaryRowData row = this.originProbeSideSerializer.toBinaryRow(record);
            p.insertIntoProbeBuffer(row);
        }
        return false;
    }

    public boolean nextMatching() throws IOException {
        if (this.type.needSetProbed()) {
            return this.processProbeIter() || this.processBuildIter() || this.prepareNextPartition();
        }
        return this.processProbeIter() || this.prepareNextPartition();
    }

    public RowData getCurrentProbeRow() {
        if (this.probeMatchedPhase) {
            return this.probeIterator.current();
        }
        return null;
    }

    public RowIterator<BinaryRowData> getBuildSideIterator() {
        return this.probeMatchedPhase ? this.bucketIterator : this.buildIterator;
    }

    @VisibleForTesting
    static int getNumWriteBehindBuffers(int numBuffers) {
        int numIOBufs = (int)(Math.log(numBuffers) / Math.log(4.0) - 1.5);
        return numIOBufs > 6 ? 6 : numIOBufs;
    }

    private boolean processProbeIter() throws IOException {
        if (this.probeIterator.hasSource()) {
            BinaryRowData next;
            ProbeIterator probeIter = this.probeIterator;
            if (!this.probeMatchedPhase) {
                return false;
            }
            while ((next = probeIter.next()) != null) {
                BinaryRowData probeKey = this.probeSideProjection.apply(next);
                int hash2 = BinaryHashTable.hash(probeKey.hashCode(), this.currentRecursionDepth);
                BinaryHashPartition p = this.partitionsBeingBuilt.get(hash2 % this.partitionsBeingBuilt.size());
                if (p.isInMemory()) {
                    this.probeKey = probeKey;
                    this.probeRow = next;
                    p.bucketArea.startLookup(hash2);
                    return true;
                }
                p.insertIntoProbeBuffer(next);
            }
            return false;
        }
        return false;
    }

    private boolean processBuildIter() throws IOException {
        if (this.buildIterVisited) {
            return false;
        }
        this.probeMatchedPhase = false;
        this.buildIterator = new BuildSideIterator(this.binaryBuildSideSerializer, this.reuseBuildRow, this.partitionsBeingBuilt, this.probedSet, this.type.equals((Object)HashJoinType.BUILD_LEFT_SEMI));
        this.buildIterVisited = true;
        return true;
    }

    private boolean prepareNextPartition() throws IOException {
        for (BinaryHashPartition p : this.partitionsBeingBuilt) {
            p.finalizeProbePhase(this.internalPool, this.partitionsPending, this.type.needSetProbed());
        }
        this.partitionsBeingBuilt.clear();
        if (this.currentSpilledBuildSide != null) {
            this.currentSpilledBuildSide.getChannel().closeAndDelete();
            this.currentSpilledBuildSide = null;
        }
        if (this.currentSpilledProbeSide != null) {
            this.currentSpilledProbeSide.getChannel().closeAndDelete();
            this.currentSpilledProbeSide = null;
        }
        if (this.partitionsPending.isEmpty()) {
            return false;
        }
        BinaryHashPartition p = this.partitionsPending.get(0);
        LOG.info(String.format("Begin to process spilled partition [%d]", p.getPartitionNumber()));
        if (p.probeSideRecordCounter == 0L) {
            this.currentSpilledBuildSide = this.createInputView(p.getBuildSideChannel().getChannelID(), p.getBuildSideBlockCount(), p.getLastSegmentLimit());
            this.buildIterator = new WrappedRowIterator<BinaryRowData>(new BinaryRowChannelInputViewIterator((ChannelReaderInputView)this.currentSpilledBuildSide, this.binaryBuildSideSerializer), this.binaryBuildSideSerializer.createInstance());
            this.partitionsPending.remove(0);
            return true;
        }
        this.probeMatchedPhase = true;
        this.buildIterVisited = false;
        this.buildTableFromSpilledPartition(p);
        ChannelWithMeta channelWithMeta = new ChannelWithMeta(p.probeSideBuffer.getChannel().getChannelID(), p.probeSideBuffer.getBlockCount(), p.probeNumBytesInLastSeg);
        this.currentSpilledProbeSide = FileChannelUtil.createInputView(this.ioManager, channelWithMeta, new ArrayList<FileIOChannel>(), this.compressionEnable, this.compressionCodecFactory, this.compressionBlockSize, this.segmentSize);
        ChannelReaderInputViewIterator probeReader = new ChannelReaderInputViewIterator(this.currentSpilledProbeSide, new ArrayList(), (TypeSerializer)this.binaryProbeSideSerializer);
        this.probeIterator.set((ChannelReaderInputViewIterator<BinaryRowData>)probeReader);
        this.probeIterator.setReuse(this.binaryProbeSideSerializer.createInstance());
        this.partitionsPending.remove(0);
        this.currentRecursionDepth = p.getRecursionLevel() + 1;
        return this.nextMatching();
    }

    private void buildTableFromSpilledPartition(BinaryHashPartition p) throws IOException {
        int totalBuffersAvailable;
        int nextRecursionLevel = p.getRecursionLevel() + 1;
        if (nextRecursionLevel == 2) {
            LOG.info("Recursive hash join: partition number is " + p.getPartitionNumber());
        } else if (nextRecursionLevel > 3) {
            throw new RuntimeException("Hash join exceeded maximum number of recursions, without reducing partitions enough to be memory resident. Probably cause: Too many duplicate keys.");
        }
        if (p.getBuildSideBlockCount() > p.getProbeSideBlockCount()) {
            LOG.info(String.format("Hash join: Partition(%d) build side block [%d] more than probe side block [%d]", p.getPartitionNumber(), p.getBuildSideBlockCount(), p.getProbeSideBlockCount()));
        }
        if ((totalBuffersAvailable = this.internalPool.freePages() + this.buildSpillRetBufferNumbers) != this.totalNumBuffers) {
            throw new RuntimeException(String.format("Hash Join bug in memory management: Memory buffers leaked. availableMemory(%s), buildSpillRetBufferNumbers(%s), reservedNumBuffers(%s)", this.internalPool.freePages(), this.buildSpillRetBufferNumbers, this.totalNumBuffers));
        }
        long numBuckets = p.getBuildSideRecordCount() / 15L + 1L;
        int maxBucketAreaBuffers = Math.max((int)(2L * (numBuckets / (long)(this.bucketsPerSegmentMask + 1))), 1);
        long totalBuffersNeeded = maxBucketAreaBuffers + p.getBuildSideBlockCount() + 2;
        if (totalBuffersNeeded < (long)totalBuffersAvailable) {
            LOG.info(String.format("Build in memory hash table from spilled partition [%d]", p.getPartitionNumber()));
            List<MemorySegment> partitionBuffers = this.readAllBuffers(p.getBuildSideChannel().getChannelID(), p.getBuildSideBlockCount());
            BinaryHashBucketArea area = new BinaryHashBucketArea(this, (int)p.getBuildSideRecordCount(), maxBucketAreaBuffers, false);
            BinaryHashPartition newPart = new BinaryHashPartition(area, this.binaryBuildSideSerializer, this.binaryProbeSideSerializer, 0, nextRecursionLevel, partitionBuffers, p.getBuildSideRecordCount(), this.segmentSize, p.getLastSegmentLimit());
            area.setPartition(newPart);
            this.partitionsBeingBuilt.add(newPart);
            BinaryHashPartition.PartitionIterator pIter = newPart.newPartitionIterator();
            while (pIter.advanceNext()) {
                int hashCode2 = BinaryHashTable.hash(this.buildSideProjection.apply(pIter.getRow()).hashCode(), nextRecursionLevel);
                int pointer = (int)pIter.getPointer();
                area.insertToBucket(hashCode2, pointer, true);
            }
        } else {
            int splits = (int)(totalBuffersNeeded / (long)totalBuffersAvailable) + 1;
            int partitionFanOut = Math.min(Math.min(10 * splits, 127), this.maxNumPartition());
            this.createPartitions(partitionFanOut, nextRecursionLevel);
            LOG.info(String.format("Build hybrid hash table from spilled partition [%d] with recursion level [%d]", p.getPartitionNumber(), nextRecursionLevel));
            HeaderlessChannelReaderInputView inView = this.createInputView(p.getBuildSideChannel().getChannelID(), p.getBuildSideBlockCount(), p.getLastSegmentLimit());
            BinaryRowChannelInputViewIterator inIter = new BinaryRowChannelInputViewIterator((ChannelReaderInputView)inView, this.binaryBuildSideSerializer);
            BinaryRowData rec = this.binaryBuildSideSerializer.createInstance();
            while ((rec = inIter.next(rec)) != null) {
                int hashCode3 = BinaryHashTable.hash(this.buildSideProjection.apply(rec).hashCode(), nextRecursionLevel);
                this.insertIntoTable(rec, hashCode3);
            }
            inView.getChannel().closeAndDelete();
            int buildWriteBuffers = 0;
            for (BinaryHashPartition part : this.partitionsBeingBuilt) {
                buildWriteBuffers += part.finalizeBuildPhase(this.ioManager, this.currentEnumerator);
            }
            this.buildSpillRetBufferNumbers += buildWriteBuffers;
        }
    }

    private void insertIntoTable(BinaryRowData record, int hashCode2) throws IOException {
        BinaryHashPartition p = this.partitionsBeingBuilt.get(hashCode2 % this.partitionsBeingBuilt.size());
        if (p.isInMemory()) {
            if (!p.bucketArea.appendRecordAndInsert(record, hashCode2)) {
                p.addHashBloomFilter(hashCode2);
            }
        } else {
            p.insertIntoBuildBuffer(record);
            p.addHashBloomFilter(hashCode2);
        }
    }

    private void createPartitions(int numPartitions, int recursionLevel) {
        this.ensureNumBuffersReturned(numPartitions);
        this.currentEnumerator = this.ioManager.createChannelEnumerator();
        this.partitionsBeingBuilt.clear();
        double numRecordPerPartition = (double)this.buildRowCount / (double)numPartitions;
        int maxBuffer = this.maxInitBufferOfBucketArea(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            BinaryHashBucketArea area = new BinaryHashBucketArea(this, numRecordPerPartition, maxBuffer);
            BinaryHashPartition p = new BinaryHashPartition(area, this.binaryBuildSideSerializer, this.binaryProbeSideSerializer, i, recursionLevel, this.getNotNullNextBuffer(), this, this.segmentSize, this.compressionEnable, this.compressionCodecFactory, this.compressionBlockSize);
            area.setPartition(p);
            this.partitionsBeingBuilt.add(p);
        }
    }

    @Override
    public void clearPartitions() {
        this.bucketIterator = null;
        this.probeIterator = null;
        for (int i = this.partitionsBeingBuilt.size() - 1; i >= 0; --i) {
            BinaryHashPartition p = this.partitionsBeingBuilt.get(i);
            try {
                p.clearAllMemory(this.internalPool);
                continue;
            }
            catch (Exception e) {
                LOG.error("Error during partition cleanup.", (Throwable)e);
            }
        }
        this.partitionsBeingBuilt.clear();
        for (BinaryHashPartition p : this.partitionsPending) {
            p.clearAllMemory(this.internalPool);
        }
    }

    @Override
    protected int spillPartition() throws IOException {
        MemorySegment currBuff;
        int largestNumBlocks = 0;
        int largestPartNum = -1;
        for (int i = 0; i < this.partitionsBeingBuilt.size(); ++i) {
            BinaryHashPartition p = this.partitionsBeingBuilt.get(i);
            if (!p.isInMemory() || p.getNumOccupiedMemorySegments() <= largestNumBlocks) continue;
            largestNumBlocks = p.getNumOccupiedMemorySegments();
            largestPartNum = i;
        }
        BinaryHashPartition p = this.partitionsBeingBuilt.get(largestPartNum);
        int numBuffersFreed = p.spillPartition(this.ioManager, this.currentEnumerator.next(), this.buildSpillReturnBuffers);
        this.buildSpillRetBufferNumbers += numBuffersFreed;
        LOG.info(String.format("Grace hash join: Ran out memory, choosing partition [%d] to spill, %d memory segments being freed", largestPartNum, numBuffersFreed));
        while (this.buildSpillRetBufferNumbers > 0 && (currBuff = (MemorySegment)this.buildSpillReturnBuffers.poll()) != null) {
            this.returnPage(currBuff);
            --this.buildSpillRetBufferNumbers;
        }
        ++this.numSpillFiles;
        this.spillInBytes += (long)(numBuffersFreed * this.segmentSize);
        p.buildBloomFilterAndFreeBucket();
        return largestPartNum;
    }

    boolean applyCondition(BinaryRowData candidate) {
        boolean equal;
        BinaryRowData buildKey = this.buildSideProjection.apply(candidate);
        boolean bl = equal = buildKey.getSizeInBytes() == this.probeKey.getSizeInBytes() && BinaryRowDataUtil.byteArrayEquals(buildKey.getSegments()[0].getHeapMemory(), this.probeKey.getSegments()[0].getHeapMemory(), buildKey.getSizeInBytes());
        if (!this.nullSafe) {
            boolean bl2 = equal && !(!this.filterAllNulls ? buildKey.anyNull(this.nullFilterKeys) : buildKey.anyNull()) ? true : (equal = false);
        }
        return this.condFunc == null ? equal : equal && (this.reverseJoin ? this.condFunc.apply(this.probeRow, candidate) : this.condFunc.apply(candidate, this.probeRow));
    }
}

