/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalSink;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class DynamicSinkUtils {
    public static RelNode toRel(FlinkRelBuilder relBuilder, RelNode input, CatalogSinkModifyOperation sinkOperation, DynamicTableSink sink, CatalogTable table) {
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(relBuilder);
        TableSchema schema = table.getSchema();
        DynamicSinkUtils.prepareDynamicSink(sinkOperation, sink, table);
        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, schema, sinkOperation.getTableIdentifier(), typeFactory);
        relBuilder.push(query);
        List<Integer> metadataColumns = DynamicSinkUtils.extractPersistedMetadataColumns(schema);
        if (!metadataColumns.isEmpty()) {
            DynamicSinkUtils.pushMetadataProjection(relBuilder, typeFactory, schema, sink);
        }
        RelNode finalQuery = relBuilder.build();
        return LogicalSink.create(finalQuery, sinkOperation.getTableIdentifier(), table, sink, sinkOperation.getStaticPartitions());
    }

    public static RelNode validateSchemaAndApplyImplicitCast(RelNode query, TableSchema sinkSchema, @Nullable ObjectIdentifier sinkIdentifier, FlinkTypeFactory typeFactory) {
        RowType queryType = FlinkTypeFactory.toLogicalRowType(query.getRowType());
        List<RowType.RowField> queryFields = queryType.getFields();
        RowType sinkType = (RowType)DynamicSinkUtils.fixSinkDataType(sinkSchema.toPersistedRowDataType()).getLogicalType();
        List<RowType.RowField> sinkFields = sinkType.getFields();
        if (queryFields.size() != sinkFields.size()) {
            throw DynamicSinkUtils.createSchemaMismatchException("Different number of columns.", sinkIdentifier, queryFields, sinkFields);
        }
        boolean requiresCasting = false;
        for (int i = 0; i < sinkFields.size(); ++i) {
            LogicalType sinkColumnType;
            LogicalType queryColumnType = queryFields.get(i).getType();
            if (!LogicalTypeCasts.supportsImplicitCast(queryColumnType, sinkColumnType = sinkFields.get(i).getType())) {
                throw DynamicSinkUtils.createSchemaMismatchException(String.format("Incompatible types for sink column '%s' at position %s.", sinkFields.get(i).getName(), i), sinkIdentifier, queryFields, sinkFields);
            }
            if (LogicalTypeCasts.supportsAvoidingCast(queryColumnType, sinkColumnType)) continue;
            requiresCasting = true;
        }
        if (requiresCasting) {
            RelDataType castRelDataType = typeFactory.buildRelNodeRowType(sinkType);
            return RelOptUtil.createCastRel(query, castRelDataType, true);
        }
        return query;
    }

    private static void pushMetadataProjection(FlinkRelBuilder relBuilder, FlinkTypeFactory typeFactory, TableSchema schema, DynamicTableSink sink) {
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        List<TableColumn> tableColumns = schema.getTableColumns();
        List<Integer> physicalColumns = DynamicSinkUtils.extractPhysicalColumns(schema);
        Map keyToMetadataColumn = DynamicSinkUtils.extractPersistedMetadataColumns(schema).stream().collect(Collectors.toMap(pos -> {
            TableColumn.MetadataColumn metadataColumn = (TableColumn.MetadataColumn)tableColumns.get((int)pos);
            return metadataColumn.getMetadataAlias().orElse(metadataColumn.getName());
        }, Function.identity()));
        List metadataColumns = DynamicSinkUtils.createRequiredMetadataKeys(schema, sink).stream().map(keyToMetadataColumn::get).collect(Collectors.toList());
        List<String> fieldNames = Stream.concat(physicalColumns.stream().map(tableColumns::get).map(TableColumn::getName), metadataColumns.stream().map(tableColumns::get).map(TableColumn.MetadataColumn.class::cast).map(c -> c.getMetadataAlias().orElse(c.getName()))).collect(Collectors.toList());
        Map<String, DataType> metadataMap = DynamicSinkUtils.extractMetadataMap(sink);
        List fieldNodes = Stream.concat(physicalColumns.stream().map(pos -> {
            int posAdjusted = DynamicSinkUtils.adjustByVirtualColumns(tableColumns, pos);
            return relBuilder.field(posAdjusted);
        }), metadataColumns.stream().map(pos -> {
            TableColumn.MetadataColumn metadataColumn = (TableColumn.MetadataColumn)tableColumns.get((int)pos);
            String metadataKey = metadataColumn.getMetadataAlias().orElse(metadataColumn.getName());
            LogicalType expectedType = ((DataType)metadataMap.get(metadataKey)).getLogicalType();
            RelDataType expectedRelDataType = typeFactory.createFieldTypeFromLogicalType(expectedType);
            int posAdjusted = DynamicSinkUtils.adjustByVirtualColumns(tableColumns, pos);
            return rexBuilder.makeAbstractCast(expectedRelDataType, relBuilder.field(posAdjusted));
        })).collect(Collectors.toList());
        relBuilder.projectNamed(fieldNodes, fieldNames, true);
    }

    private static void prepareDynamicSink(CatalogSinkModifyOperation sinkOperation, DynamicTableSink sink, CatalogTable table) {
        ObjectIdentifier sinkIdentifier = sinkOperation.getTableIdentifier();
        DynamicSinkUtils.validatePartitioning(sinkOperation, sinkIdentifier, sink, table.getPartitionKeys());
        DynamicSinkUtils.validateAndApplyOverwrite(sinkOperation, sinkIdentifier, sink);
        DynamicSinkUtils.validateAndApplyMetadata(sinkIdentifier, sink, table.getSchema());
    }

    private static List<String> createRequiredMetadataKeys(TableSchema schema, DynamicTableSink sink) {
        List<TableColumn> tableColumns = schema.getTableColumns();
        List<Integer> metadataColumns = DynamicSinkUtils.extractPersistedMetadataColumns(schema);
        Set requiredMetadataKeys = metadataColumns.stream().map(tableColumns::get).map(TableColumn.MetadataColumn.class::cast).map(c -> c.getMetadataAlias().orElse(c.getName())).collect(Collectors.toSet());
        Map<String, DataType> metadataMap = DynamicSinkUtils.extractMetadataMap(sink);
        return metadataMap.keySet().stream().filter(requiredMetadataKeys::contains).collect(Collectors.toList());
    }

    private static ValidationException createSchemaMismatchException(String cause, @Nullable ObjectIdentifier sinkIdentifier, List<RowType.RowField> queryFields, List<RowType.RowField> sinkFields) {
        String querySchema = queryFields.stream().map(f -> f.getName() + ": " + f.getType().asSummaryString()).collect(Collectors.joining(", ", "[", "]"));
        String sinkSchema = sinkFields.stream().map(sinkField -> sinkField.getName() + ": " + sinkField.getType().asSummaryString()).collect(Collectors.joining(", ", "[", "]"));
        String tableName = sinkIdentifier != null ? "registered table '" + sinkIdentifier.asSummaryString() + "'" : "unregistered table";
        return new ValidationException(String.format("Column types of query result and sink for %s do not match.\nCause: %s\n\nQuery schema: %s\nSink schema:  %s", tableName, cause, querySchema, sinkSchema));
    }

    private static DataType fixSinkDataType(DataType sinkDataType) {
        return DataTypeUtils.transform(sinkDataType, TypeTransformations.legacyDecimalToDefaultDecimal(), TypeTransformations.legacyRawToTypeInfoRaw(), TypeTransformations.toNullable());
    }

    private static void validatePartitioning(CatalogSinkModifyOperation sinkOperation, ObjectIdentifier sinkIdentifier, DynamicTableSink sink, List<String> partitionKeys) {
        if (!partitionKeys.isEmpty() && !(sink instanceof SupportsPartitioning)) {
            throw new TableException(String.format("Table '%s' is a partitioned table, but the underlying %s doesn't implement the %s interface.", sinkIdentifier.asSummaryString(), DynamicTableSink.class.getSimpleName(), SupportsPartitioning.class.getSimpleName()));
        }
        Map<String, String> staticPartitions = sinkOperation.getStaticPartitions();
        staticPartitions.keySet().forEach(p -> {
            if (!partitionKeys.contains(p)) {
                throw new ValidationException(String.format("Static partition column '%s' should be in the partition keys list %s for table '%s'.", p, partitionKeys, sinkIdentifier.asSummaryString()));
            }
        });
    }

    private static void validateAndApplyOverwrite(CatalogSinkModifyOperation sinkOperation, ObjectIdentifier sinkIdentifier, DynamicTableSink sink) {
        if (!sinkOperation.isOverwrite()) {
            return;
        }
        if (!(sink instanceof SupportsOverwrite)) {
            throw new ValidationException(String.format("INSERT OVERWRITE requires that the underlying %s of table '%s' implements the %s interface.", DynamicTableSink.class.getSimpleName(), sinkIdentifier.asSummaryString(), SupportsOverwrite.class.getSimpleName()));
        }
        SupportsOverwrite overwriteSink = (SupportsOverwrite)((Object)sink);
        overwriteSink.applyOverwrite(sinkOperation.isOverwrite());
    }

    private static List<Integer> extractPhysicalColumns(TableSchema schema) {
        List<TableColumn> tableColumns = schema.getTableColumns();
        return IntStream.range(0, schema.getFieldCount()).filter(pos -> ((TableColumn)tableColumns.get(pos)).isPhysical()).boxed().collect(Collectors.toList());
    }

    private static List<Integer> extractPersistedMetadataColumns(TableSchema schema) {
        List<TableColumn> tableColumns = schema.getTableColumns();
        return IntStream.range(0, schema.getFieldCount()).filter(pos -> {
            TableColumn tableColumn = (TableColumn)tableColumns.get(pos);
            return tableColumn instanceof TableColumn.MetadataColumn && tableColumn.isPersisted();
        }).boxed().collect(Collectors.toList());
    }

    private static int adjustByVirtualColumns(List<TableColumn> tableColumns, int pos) {
        return pos - (int)IntStream.range(0, pos).filter(i -> !((TableColumn)tableColumns.get(i)).isPersisted()).count();
    }

    private static Map<String, DataType> extractMetadataMap(DynamicTableSink sink) {
        if (sink instanceof SupportsWritingMetadata) {
            return ((SupportsWritingMetadata)((Object)sink)).listWritableMetadata();
        }
        return Collections.emptyMap();
    }

    private static void validateAndApplyMetadata(ObjectIdentifier sinkIdentifier, DynamicTableSink sink, TableSchema schema) {
        List<TableColumn> tableColumns = schema.getTableColumns();
        List<Integer> metadataColumns = DynamicSinkUtils.extractPersistedMetadataColumns(schema);
        if (metadataColumns.isEmpty()) {
            return;
        }
        if (!(sink instanceof SupportsWritingMetadata)) {
            throw new ValidationException(String.format("Table '%s' declares persistable metadata columns, but the underlying %s doesn't implement the %s interface. If the column should not be persisted, it can be declared with the VIRTUAL keyword.", sinkIdentifier.asSummaryString(), DynamicTableSink.class.getSimpleName(), SupportsWritingMetadata.class.getSimpleName()));
        }
        SupportsWritingMetadata metadataSink = (SupportsWritingMetadata)((Object)sink);
        Map<String, DataType> metadataMap = ((SupportsWritingMetadata)((Object)sink)).listWritableMetadata();
        metadataColumns.forEach(pos -> {
            TableColumn.MetadataColumn metadataColumn = (TableColumn.MetadataColumn)tableColumns.get((int)pos);
            String metadataKey = metadataColumn.getMetadataAlias().orElse(metadataColumn.getName());
            LogicalType metadataType = metadataColumn.getType().getLogicalType();
            DataType expectedMetadataDataType = (DataType)metadataMap.get(metadataKey);
            if (expectedMetadataDataType == null) {
                throw new ValidationException(String.format("Invalid metadata key '%s' in column '%s' of table '%s'. The %s class '%s' supports the following metadata keys for writing:\n%s", metadataKey, metadataColumn.getName(), sinkIdentifier.asSummaryString(), DynamicTableSink.class.getSimpleName(), sink.getClass().getName(), String.join((CharSequence)"\n", metadataMap.keySet())));
            }
            if (!LogicalTypeCasts.supportsExplicitCast(metadataType, expectedMetadataDataType.getLogicalType())) {
                if (metadataKey.equals(metadataColumn.getName())) {
                    throw new ValidationException(String.format("Invalid data type for metadata column '%s' of table '%s'. The column cannot be declared as '%s' because the type must be castable to metadata type '%s'.", metadataColumn.getName(), sinkIdentifier.asSummaryString(), metadataType, expectedMetadataDataType.getLogicalType()));
                }
                throw new ValidationException(String.format("Invalid data type for metadata column '%s' with metadata key '%s' of table '%s'. The column cannot be declared as '%s' because the type must be castable to metadata type '%s'.", metadataColumn.getName(), metadataKey, sinkIdentifier.asSummaryString(), metadataType, expectedMetadataDataType.getLogicalType()));
            }
        });
        metadataSink.applyWritableMetadata(DynamicSinkUtils.createRequiredMetadataKeys(schema, sink), TypeConversions.fromLogicalToDataType(DynamicSinkUtils.createConsumedType(schema, sink)));
    }

    private static RowType createConsumedType(TableSchema schema, DynamicTableSink sink) {
        Map<String, DataType> metadataMap = DynamicSinkUtils.extractMetadataMap(sink);
        Stream<RowType.RowField> physicalFields = schema.getTableColumns().stream().filter(TableColumn::isPhysical).map(c -> new RowType.RowField(c.getName(), c.getType().getLogicalType()));
        Stream<RowType.RowField> metadataFields = DynamicSinkUtils.createRequiredMetadataKeys(schema, sink).stream().map(k -> new RowType.RowField((String)k, ((DataType)metadataMap.get(k)).getLogicalType()));
        List<RowType.RowField> rowFields = Stream.concat(physicalFields, metadataFields).collect(Collectors.toList());
        return new RowType(false, rowFields);
    }

    private DynamicSinkUtils() {
    }
}

