/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecLocalHashAggregate;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecJoinRuleBase;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchExecJoinRuleBase$;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import scala.Array$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public abstract class BatchExecJoinRuleBase$class {
    public static RelNode addLocalDistinctAgg(BatchExecJoinRuleBase $this, RelNode node, Seq distinctKeys, RelBuilder relBuilder) {
        RelTraitSet localRequiredTraitSet = node.getTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL());
        RelNode newInput = RelOptRule.convert(node, localRequiredTraitSet);
        RelTraitSet providedTraitSet = localRequiredTraitSet;
        return new BatchExecLocalHashAggregate(node.getCluster(), relBuilder, providedTraitSet, newInput, node.getRowType(), node.getRowType(), (int[])distinctKeys.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (Seq<Tuple2<AggregateCall, UserDefinedFunction>>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public static boolean chooseSemiBuildDistinct(BatchExecJoinRuleBase $this, RelNode buildRel, Seq distinctKeys) {
        TableConfig tableConfig = FlinkRelOptUtil$.MODULE$.getTableConfigFromContext(buildRel);
        RelMetadataQuery mq = buildRel.getCluster().getMetadataQuery();
        double ratioConf = tableConfig.getConfiguration().getDouble(BatchExecJoinRuleBase$.MODULE$.TABLE_OPTIMIZER_SEMI_JOIN_BUILD_DISTINCT_NDV_RATIO());
        Double inputRows = mq.getRowCount(buildRel);
        Double ndvOfGroupKey = mq.getDistinctRowCount(buildRel, ImmutableBitSet.of((int[])distinctKeys.toArray(ClassTag$.MODULE$.Int())), null);
        return ndvOfGroupKey == null ? false : Predef$.MODULE$.Double2double(ndvOfGroupKey) / Predef$.MODULE$.Double2double(inputRows) < ratioConf;
    }

    public static Double binaryRowRelNodeSize(BatchExecJoinRuleBase $this, RelNode relNode) {
        RelMetadataQuery mq = relNode.getCluster().getMetadataQuery();
        Double rowCount = mq.getRowCount(relNode);
        return rowCount == null ? null : Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(relNode)));
    }

    public static void $init$(BatchExecJoinRuleBase $this) {
    }
}

