/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalWindowAggregateRuleBase;
import org.apache.flink.table.planner.plan.rules.logical.StreamLogicalWindowAggregateRule$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001'\t\u00013\u000b\u001e:fC6dunZ5dC2<\u0016N\u001c3po\u0006;wM]3hCR,'+\u001e7f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\tqBj\\4jG\u0006dw+\u001b8e_^\fum\u001a:fO\u0006$XMU;mK\n\u000b7/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\ru\u0001A\u0011\t\u0006\u001f\u0003u9W\r^%o\u0003\u001e<'/Z4bi\u0016<%o\\;q\u000bb\u0004(/Z:tS>tGcA\u0010(YA\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0004e\u0016D(B\u0001\u0013\u000f\u0003\u001d\u0019\u0017\r\\2ji\u0016L!AJ\u0011\u0003\u000fI+\u0007PT8eK\")\u0001\u0006\ba\u0001S\u0005Q!/\u001a=Ck&dG-\u001a:\u0011\u0005\u0001R\u0013BA\u0016\"\u0005)\u0011V\r\u001f\"vS2$WM\u001d\u0005\u0006[q\u0001\rAL\u0001\u0011o&tGm\\<FqB\u0014Xm]:j_:\u0004\"\u0001I\u0018\n\u0005A\n#a\u0002*fq\u000e\u000bG\u000e\u001c\u0005\u0007e\u0001!\tEC\u001a\u0002=\u001d,GoT;u\u0003\u001e<'/Z4bi\u0016<%o\\;q\u000bb\u0004(/Z:tS>tGcA\u00105k!)\u0001&\ra\u0001S!)Q&\ra\u0001]!1q\u0007\u0001C!\u0015a\nQcZ3u)&lWMR5fY\u0012\u0014VMZ3sK:\u001cW\r\u0006\u0003:\u007f\u0005K\u0005C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u000b\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005yZ$\u0001\u0007$jK2$'+\u001a4fe\u0016t7-Z#yaJ,7o]5p]\")\u0001I\u000ea\u0001?\u00059q\u000e]3sC:$\u0007\"\u0002\"7\u0001\u0004\u0019\u0015A\u0005;j[\u0016\fE\u000f\u001e:jEV$X-\u00138eKb\u0004\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u00131!\u00138u\u0011\u0015Qe\u00071\u0001L\u0003\u001d\u0011xn\u001e+za\u0016\u0004\"\u0001T)\u000e\u00035S!AT(\u0002\tQL\b/\u001a\u0006\u0003!\u000e\n1A]3m\u0013\t\u0011VJA\u0006SK2$\u0015\r^1UsB,\u0007\"\u0002+\u0001\t\u0003)\u0016\u0001E4fi>\u0003XM]1oI\u0006\u001bHj\u001c8h)\r1\u0016l\u0017\t\u0003\t^K!\u0001W#\u0003\t1{gn\u001a\u0005\u00065N\u0003\rAL\u0001\u0005G\u0006dG\u000eC\u0003]'\u0002\u00071)A\u0002jIb<QA\u0018\u0002\t\u0002}\u000b\u0001e\u0015;sK\u0006lGj\\4jG\u0006dw+\u001b8e_^\fum\u001a:fO\u0006$XMU;mKB\u0011Q\u0003\u0019\u0004\u0006\u0003\tA\t!Y\n\u0003A\n\u0004\"\u0001R2\n\u0005\u0011,%AB!osJ+g\rC\u0003\u001aA\u0012\u0005a\rF\u0001`\u0011\u001dA\u0007M1A\u0005\u0002%\f\u0001\"\u0013(T)\u0006s5)R\u000b\u00027!11\u000e\u0019Q\u0001\nm\t\u0011\"\u0013(T)\u0006s5)\u0012\u0011")
public class StreamLogicalWindowAggregateRule
extends LogicalWindowAggregateRuleBase {
    public static StreamLogicalWindowAggregateRule INSTANCE() {
        return StreamLogicalWindowAggregateRule$.MODULE$.INSTANCE();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RexNode getInAggregateGroupExpression(RexBuilder rexBuilder, RexCall windowExpression) {
        void var3_3;
        RexNode timeAttribute = (RexNode)windowExpression.operands.get(0);
        if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(timeAttribute.getType())) {
            return var3_3;
        }
        throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Window aggregate can only be defined over a "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time attribute column, but ", " encountered."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getType()}))).toString());
    }

    @Override
    public RexNode getOutAggregateGroupExpression(RexBuilder rexBuilder, RexCall windowExpression) {
        return rexBuilder.makeLiteral((Object)BoxesRunTime.boxToLong((long)0L), rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP, windowExpression.getType().getPrecision()), true);
    }

    @Override
    public FieldReferenceExpression getTimeFieldReference(RexNode operand, int timeAttributeIndex, RelDataType rowType) {
        if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(operand.getType())) {
            String fieldName = rowType.getFieldList().get(timeAttributeIndex).getName();
            RelDataType fieldType = rowType.getFieldList().get(timeAttributeIndex).getType();
            return new FieldReferenceExpression(fieldName, LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(FlinkTypeFactory$.MODULE$.toLogicalType(fieldType)), 0, timeAttributeIndex);
        }
        throw new ValidationException("Window can only be defined over a time attribute column.");
    }

    @Override
    public long getOperandAsLong(RexCall call, int idx) {
        boolean bl = false;
        RexLiteral rexLiteral = null;
        RexNode rexNode = call.getOperands().get(idx);
        if (rexNode instanceof RexLiteral) {
            bl = true;
            rexLiteral = (RexLiteral)rexNode;
            SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
            SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
            if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) {
                long l = ((BigDecimal)rexLiteral.getValue()).longValue();
                return l;
            }
        }
        if (bl) {
            throw new TableException("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
        }
        throw new TableException("Only constant window descriptors are supported.");
    }

    public StreamLogicalWindowAggregateRule() {
        super("StreamLogicalWindowAggregateRule");
    }
}

