/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableRule;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001%4Q!\u0001\u0002\u0002\u0002M\u0011!\u0007T8hS\u000e\fGnQ8se\u0016d\u0017\r^3U_*{\u0017N\u001c$s_6<UM\\3sC2$V-\u001c9pe\u0006dG+\u00192mKJ+H.\u001a\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003W1{w-[2bY\u000e{'O]3mCR,Gk\u001c&pS:4%o\\7UK6\u0004xN]1m)\u0006\u0014G.\u001a*vY\u0016D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\b_B,'/\u00198e!\tYr$D\u0001\u001d\u0015\t9QD\u0003\u0002\u001f\u001d\u000591-\u00197dSR,\u0017B\u0001\u0011\u001d\u0005E\u0011V\r\\(qiJ+H.Z(qKJ\fg\u000e\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005YA-Z:de&\u0004H/[8o!\t!#F\u0004\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIc%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015'\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019a\u0014N\\5u}Q\u0019\u0001'\r\u001a\u0011\u0005U\u0001\u0001\"B\r.\u0001\u0004Q\u0002\"\u0002\u0012.\u0001\u0004\u0019\u0003\"\u0002\u001b\u0001\t#)\u0014!H3yiJ\f7\r\u001e*jO\"$XI^3oiRKW.Z%oaV$(+\u001a4\u0015\u0007Yzt\tE\u0002&oeJ!\u0001\u000f\u0014\u0003\r=\u0003H/[8o!\tQT(D\u0001<\u0015\taT$A\u0002sKbL!AP\u001e\u0003\u000fI+\u0007PT8eK\")\u0001i\ra\u0001\u0003\u0006IA.\u001a4u\u0013:\u0004X\u000f\u001e\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tv\t1A]3m\u0013\t15IA\u0004SK2tu\u000eZ3\t\u000b!\u001b\u0004\u0019A%\u0002\u0011Mt\u0017\r]:i_R\u0004\"A\u0013'\u000e\u0003-S!aA\"\n\u00055[%a\u0004'pO&\u001c\u0017\r\\*oCB\u001c\bn\u001c;\t\u000b=\u0003A\u0011\u0003)\u00027\u0015DHO]1diNs\u0017\r]:i_R$\u0016.\\3J]B,HOU3g)\r\tVK\u0016\t\u0004K]\u0012\u0006C\u0001\u001eT\u0013\t!6HA\u0006SKbLe\u000e];u%\u00164\u0007\"\u0002!O\u0001\u0004\t\u0005\"\u0002%O\u0001\u0004I\u0005\"\u0002-\u0001\t\u0003J\u0016aB8o\u001b\u0006$8\r\u001b\u000b\u00035v\u0003\"!J.\n\u0005q3#\u0001B+oSRDQAX,A\u0002}\u000bAaY1mYB\u00111\u0004Y\u0005\u0003Cr\u0011aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003d\u0001\u0011%A-\u0001\u000ejgJ{w\u000fV5nKR+W\u000e]8sC2$\u0016M\u00197f\u0015>Lg\u000e\u0006\u0002fQB\u0011QEZ\u0005\u0003O\u001a\u0012qAQ8pY\u0016\fg\u000eC\u0003IE\u0002\u0007\u0011\n")
public abstract class LogicalCorrelateToJoinFromGeneralTemporalTableRule
extends LogicalCorrelateToJoinFromTemporalTableRule {
    public Option<RexNode> extractRightEventTimeInputRef(RelNode leftInput, LogicalSnapshot snapshot) {
        None$ none$;
        Buffer rightFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(snapshot.getRowType().getFieldList()).asScala();
        Buffer timeAttributeFields = (Buffer)rightFields.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelDataTypeField f) {
                return f.getType() instanceof TimeIndicatorRelDataType && ((TimeIndicatorRelDataType)f.getType()).isEventTime();
            }
        });
        if (timeAttributeFields.length() == 1) {
            int timeColIndex = leftInput.getRowType().getFieldCount() + rightFields.indexOf(JavaConversions$.MODULE$.bufferAsJavaList(timeAttributeFields).get(0));
            RelDataType timeColDataType = ((RelDataTypeField)JavaConversions$.MODULE$.bufferAsJavaList(timeAttributeFields).get(0)).getType();
            RexBuilder rexBuilder = snapshot.getCluster().getRexBuilder();
            none$ = new Some((Object)rexBuilder.makeInputRef(timeColDataType, timeColIndex));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexInputRef> extractSnapshotTimeInputRef(RelNode leftInput, LogicalSnapshot snapshot) {
        None$ none$;
        RelDataTypeField periodField;
        RelDataType leftRowType = leftInput.getRowType();
        List<RelDataTypeField> leftFields = leftRowType.getFieldList();
        if (leftFields.contains(periodField = ((RexFieldAccess)snapshot.getPeriod()).getField())) {
            int index = leftRowType.getFieldList().indexOf(periodField);
            none$ = new Some((Object)RexInputRef.of(index, leftRowType));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMatch(RelOptRuleCall call) {
        RexNode rexNode;
        Tuple2 tuple2;
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        Object leftInput = call.rel(1);
        RexNode filterCondition = this.getFilterCondition(call);
        LogicalSnapshot snapshot = this.getLogicalSnapshot(call);
        RelDataType leftRowType = leftInput.getRowType();
        RexNode joinCondition = filterCondition.accept(new RexShuttle(this, correlate, leftRowType){
            private final LogicalCorrelate correlate$2;
            private final RelDataType leftRowType$2;

            public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                RexNode rexNode;
                RexNode rexNode2 = fieldAccess.getReferenceExpr();
                if (rexNode2 instanceof RexCorrelVariable) {
                    RexCorrelVariable rexCorrelVariable = (RexCorrelVariable)rexNode2;
                    Predef$.MODULE$.require(this.correlate$2.getCorrelationId().equals(rexCorrelVariable.id));
                    int index = this.leftRowType$2.getFieldList().indexOf(fieldAccess.getField());
                    rexNode = RexInputRef.of(index, this.leftRowType$2);
                } else {
                    rexNode = super.visitFieldAccess(fieldAccess);
                }
                return rexNode;
            }

            public RexNode visitInputRef(RexInputRef inputRef) {
                int rightIndex = this.leftRowType$2.getFieldCount() + inputRef.getIndex();
                return new RexInputRef(rightIndex, inputRef.getType());
            }
            {
                this.correlate$2 = correlate$2;
                this.leftRowType$2 = leftRowType$2;
            }
        });
        this.validateSnapshotInCorrelate(snapshot, correlate);
        RexBuilder rexBuilder = correlate.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)leftInput);
        relBuilder.push(snapshot);
        RelNode rewriteJoin = relBuilder.join(correlate.getJoinType(), joinCondition).build();
        JoinInfo joinInfo = ((LogicalJoin)rewriteJoin).analyzeCondition();
        Buffer leftJoinKey = (Buffer)JavaConversions$.MODULE$.asScalaBuffer((List)joinInfo.leftKeys).map((Function1)new Serializable(this, (RelNode)leftInput, rexBuilder){
            public static final long serialVersionUID = 0L;
            private final RelNode leftInput$1;
            private final RexBuilder rexBuilder$1;

            public final RexInputRef apply(Integer i) {
                return this.rexBuilder$1.makeInputRef(this.leftInput$1, Predef$.MODULE$.Integer2int(i));
            }
            {
                this.leftInput$1 = leftInput$1;
                this.rexBuilder$1 = rexBuilder$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        int leftFieldCnt = leftInput.getRowType().getFieldCount();
        Buffer rightJoinKey = (Buffer)JavaConversions$.MODULE$.asScalaBuffer((List)joinInfo.rightKeys).map((Function1)new Serializable(this, snapshot, rexBuilder, leftFieldCnt){
            public static final long serialVersionUID = 0L;
            private final LogicalSnapshot snapshot$1;
            private final RexBuilder rexBuilder$1;
            private final int leftFieldCnt$1;

            public final RexInputRef apply(Integer i) {
                RelDataType leftKeyType = this.snapshot$1.getRowType().getFieldList().get(Predef$.MODULE$.Integer2int(i)).getType();
                return this.rexBuilder$1.makeInputRef(leftKeyType, this.leftFieldCnt$1 + Predef$.MODULE$.Integer2int(i));
            }
            {
                this.snapshot$1 = snapshot$1;
                this.rexBuilder$1 = rexBuilder$1;
                this.leftFieldCnt$1 = leftFieldCnt$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        if (leftJoinKey.length() == 0 || rightJoinKey.length() == 0) {
            throw new ValidationException("Currently the join key in Temporal Table Join can not be empty.");
        }
        Tuple2 tuple22 = new Tuple2((Object)leftJoinKey, (Object)rightJoinKey);
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Buffer leftJoinKey2 = (Buffer)tuple22._1();
        Buffer rightJoinKey2 = (Buffer)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)leftJoinKey2, (Object)rightJoinKey2);
        Buffer leftJoinKey3 = (Buffer)tuple23._1();
        Buffer rightJoinKey3 = (Buffer)tuple23._2();
        RexInputRef snapshotTimeInputRef = (RexInputRef)this.extractSnapshotTimeInputRef((RelNode)leftInput, snapshot).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ValidationException("Temporal Table Join requires time attribute in the left table, but no time attribute found.");
            }
        });
        if (this.isRowTimeTemporalTableJoin(snapshot)) {
            Option<RexNode> rightTimeInputRef = this.extractRightEventTimeInputRef((RelNode)leftInput, snapshot);
            if (rightTimeInputRef.isEmpty() || !FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(((RexNode)rightTimeInputRef.get()).getType())) throw new ValidationException(new StringBuilder().append((Object)"Event-Time Temporal Table Join requires both").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" primary key and row time attribute in versioned table,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but no row time attribute can be found."})).s((Seq)Nil$.MODULE$)).toString());
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialRowTimeTemporalTableJoinCondCall(rexBuilder, snapshotTimeInputRef, (RexNode)rightTimeInputRef.get(), (Seq<RexNode>)leftJoinKey3, (Seq<RexNode>)rightJoinKey3);
        } else {
            rexNode = TemporalJoinUtil$.MODULE$.makeInitialProcTimeTemporalTableJoinConCall(rexBuilder, snapshotTimeInputRef, (Seq<RexNode>)leftJoinKey3, (Seq<RexNode>)rightJoinKey3);
        }
        RexNode temporalCondition = rexNode;
        RelBuilder builder = call.builder();
        RexNode condition = builder.and(joinCondition, temporalCondition);
        builder.push((RelNode)leftInput);
        builder.push(snapshot);
        builder.join(correlate.getJoinType(), condition);
        RelNode temporalJoin = builder.build();
        call.transformTo(temporalJoin);
    }

    private boolean isRowTimeTemporalTableJoin(LogicalSnapshot snapshot) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType = snapshot.getPeriod().getType();
        boolean bl = relDataType instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
        return bl;
    }

    public LogicalCorrelateToJoinFromGeneralTemporalTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }
}

