/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.CallBindingCallContext;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public final class TypeInferenceOperandInference
implements SqlOperandTypeInference {
    private final DataTypeFactory dataTypeFactory;
    private final FunctionDefinition definition;
    private final TypeInference typeInference;

    public TypeInferenceOperandInference(DataTypeFactory dataTypeFactory, FunctionDefinition definition, TypeInference typeInference) {
        this.dataTypeFactory = dataTypeFactory;
        this.definition = definition;
        this.typeInference = typeInference;
    }

    @Override
    public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
        CallBindingCallContext callContext = new CallBindingCallContext(this.dataTypeFactory, this.definition, callBinding, returnType);
        try {
            this.inferOperandTypesOrError(ShortcutUtils.unwrapTypeFactory(callBinding), callContext, operandTypes);
        }
        catch (CalciteContextException | ValidationException runtimeException) {
        }
        catch (Throwable t) {
            throw TypeInferenceUtil.createUnexpectedException(callContext, t);
        }
    }

    private void inferOperandTypesOrError(FlinkTypeFactory typeFactory, CallContext callContext, RelDataType[] operandTypes) {
        List expectedDataTypes = this.typeInference.getTypedArguments().isPresent() ? this.typeInference.getTypedArguments().get() : (List)this.typeInference.getInputTypeStrategy().inferInputTypes(callContext, false).orElse(null);
        if (expectedDataTypes == null || expectedDataTypes.size() != operandTypes.length) {
            return;
        }
        for (int i = 0; i < operandTypes.length; ++i) {
            LogicalType inferredType = ((DataType)expectedDataTypes.get(i)).getLogicalType();
            operandTypes[i] = typeFactory.createFieldTypeFromLogicalType(inferredType);
        }
    }
}

