/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractSqlCallContext
implements CallContext {
    private final DataTypeFactory dataTypeFactory;
    private final FunctionDefinition definition;
    private final String name;

    protected AbstractSqlCallContext(DataTypeFactory dataTypeFactory, FunctionDefinition definition, String name) {
        this.dataTypeFactory = dataTypeFactory;
        this.definition = definition;
        this.name = name;
    }

    @Override
    public DataTypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    @Override
    public FunctionDefinition getFunctionDefinition() {
        return this.definition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected static <T> T getLiteralValueAs(LiteralValueAccessor accessor, Class<T> clazz) {
        Preconditions.checkArgument((!clazz.isPrimitive() ? 1 : 0) != 0);
        Serializable convertedValue = null;
        if (clazz == Duration.class) {
            long longVal = accessor.getValueAs(Long.class);
            convertedValue = Duration.ofMillis(longVal);
        } else if (clazz == Period.class) {
            long longVal = accessor.getValueAs(Long.class);
            if (longVal <= Integer.MAX_VALUE && longVal >= Integer.MIN_VALUE) {
                convertedValue = Period.ofMonths((int)longVal);
            }
        } else if (clazz == LocalDate.class) {
            DateString dateString = accessor.getValueAs(DateString.class);
            convertedValue = LocalDate.parse(dateString.toString());
        } else if (clazz == LocalTime.class) {
            TimeString timeString = accessor.getValueAs(TimeString.class);
            convertedValue = LocalTime.parse(timeString.toString());
        } else if (clazz == LocalDateTime.class) {
            TimestampString timestampString = accessor.getValueAs(TimestampString.class);
            convertedValue = LocalDateTime.parse(timestampString.toString().replace(' ', 'T'));
        } else if (clazz == Instant.class) {
            TimestampString timestampString = accessor.getValueAs(TimestampString.class);
            convertedValue = LocalDateTime.parse(timestampString.toString().replace(' ', 'T')).atOffset(ZoneOffset.UTC).toInstant();
        }
        if (convertedValue != null) {
            return (T)convertedValue;
        }
        return accessor.getValueAs(clazz);
    }

    protected static interface LiteralValueAccessor {
        public <T> T getValueAs(Class<T> var1);
    }
}

