/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.util.Preconditions;

public class CallExpressionResolver {
    private final ExpressionResolver resolver;

    public CallExpressionResolver(RelBuilder relBuilder) {
        FlinkContext context = ShortcutUtils.unwrapContext(relBuilder.getCluster());
        this.resolver = ExpressionResolver.resolverFor(context.getTableConfig(), name -> Optional.empty(), context.getFunctionCatalog().asLookup(str -> {
            throw new TableException("We should not need to lookup any expressions at this point");
        }), context.getCatalogManager().getDataTypeFactory(), new QueryOperation[0]).build();
    }

    public ResolvedExpression resolve(Expression expression2) {
        List<ResolvedExpression> resolved = this.resolver.resolve(Collections.singletonList(expression2));
        Preconditions.checkArgument((resolved.size() == 1 ? 1 : 0) != 0);
        return resolved.get(0);
    }
}

