/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Preconditions;

@Internal
public final class TableFunctionDefinition
implements FunctionDefinition {
    private final String name;
    private final TableFunction<?> tableFunction;
    private final TypeInformation<?> resultType;

    public TableFunctionDefinition(String name, TableFunction<?> tableFunction, TypeInformation<?> resultType2) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.tableFunction = (TableFunction)Preconditions.checkNotNull(tableFunction);
        this.resultType = (TypeInformation)Preconditions.checkNotNull(resultType2);
    }

    public String getName() {
        return this.name;
    }

    public TableFunction<?> getTableFunction() {
        return this.tableFunction;
    }

    public TypeInformation<?> getResultType() {
        return this.resultType;
    }

    @Override
    public FunctionKind getKind() {
        return FunctionKind.TABLE;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        throw new TableException("Functions implemented for the old type system are not supported.");
    }

    @Override
    public Set<FunctionRequirement> getRequirements() {
        return this.tableFunction.getRequirements();
    }

    @Override
    public boolean isDeterministic() {
        return this.tableFunction.isDeterministic();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFunctionDefinition that = (TableFunctionDefinition)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

