/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FileSourceSplitState<SplitT extends FileSourceSplit> {
    private final SplitT split;
    private long offset;
    private long recordsToSkipAfterOffset;

    public FileSourceSplitState(SplitT split2) {
        this.split = (FileSourceSplit)Preconditions.checkNotNull(split2);
        Optional<CheckpointedPosition> readerPosition = ((FileSourceSplit)split2).getReaderPosition();
        if (readerPosition.isPresent()) {
            this.offset = readerPosition.get().getOffset();
            this.recordsToSkipAfterOffset = readerPosition.get().getRecordsAfterOffset();
        } else {
            this.offset = -1L;
            this.recordsToSkipAfterOffset = 0L;
        }
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRecordsToSkipAfterOffset() {
        return this.recordsToSkipAfterOffset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setRecordsToSkipAfterOffset(long recordsToSkipAfterOffset) {
        this.recordsToSkipAfterOffset = recordsToSkipAfterOffset;
    }

    public void setPosition(long offset, long recordsToSkipAfterOffset) {
        this.offset = offset;
        this.recordsToSkipAfterOffset = recordsToSkipAfterOffset;
    }

    public void setPosition(CheckpointedPosition position) {
        this.offset = position.getOffset();
        this.recordsToSkipAfterOffset = position.getRecordsAfterOffset();
    }

    public SplitT toFileSourceSplit() {
        CheckpointedPosition position = this.offset == -1L && this.recordsToSkipAfterOffset == 0L ? null : new CheckpointedPosition(this.offset, this.recordsToSkipAfterOffset);
        FileSourceSplit updatedSplit = ((FileSourceSplit)this.split).updateWithCheckpointedPosition(position);
        if (updatedSplit == null) {
            throw new FlinkRuntimeException("Split returned 'null' in updateWithCheckpointedPosition(): " + this.split);
        }
        if (updatedSplit.getClass() != this.split.getClass()) {
            throw new FlinkRuntimeException(String.format("Split returned different type in updateWithCheckpointedPosition(). Split type is %s, returned type is %s", this.split.getClass().getName(), updatedSplit.getClass().getName()));
        }
        return (SplitT)updatedSplit;
    }
}

