/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.ClassDataTypeConverter;
import org.apache.flink.types.Row;

@Internal
public final class DataTypeExtractor {
    private final DataTypeFactory typeFactory;
    private final String contextExplanation;

    private DataTypeExtractor(DataTypeFactory typeFactory, String contextExplanation) {
        this.typeFactory = typeFactory;
        this.contextExplanation = contextExplanation;
    }

    public static DataType extractFromType(DataTypeFactory typeFactory, Type type) {
        return DataTypeExtractor.extractDataTypeWithClassContext(typeFactory, DataTypeTemplate.fromDefaults(), null, type, "");
    }

    public static DataType extractFromType(DataTypeFactory typeFactory, DataTypeTemplate template, Type type) {
        return DataTypeExtractor.extractDataTypeWithClassContext(typeFactory, template, null, type, "");
    }

    public static DataType extractFromGeneric(DataTypeFactory typeFactory, Class<?> baseClass, int genericPos, Type contextType) {
        TypeVariable<Class<?>> variable = baseClass.getTypeParameters()[genericPos];
        return DataTypeExtractor.extractDataTypeWithClassContext(typeFactory, DataTypeTemplate.fromDefaults(), contextType, variable, String.format(" in generic class '%s' in %s", baseClass.getName(), contextType.toString()));
    }

    public static DataType extractFromMethodParameter(DataTypeFactory typeFactory, Class<?> baseClass, Method method, int paramPos) {
        Parameter parameter = method.getParameters()[paramPos];
        DataTypeHint hint = parameter.getAnnotation(DataTypeHint.class);
        DataTypeTemplate template = hint != null ? DataTypeTemplate.fromAnnotation(typeFactory, hint) : DataTypeTemplate.fromDefaults();
        return DataTypeExtractor.extractDataTypeWithClassContext(typeFactory, template, baseClass, parameter.getParameterizedType(), String.format(" in parameter %d of method '%s' in class '%s'", paramPos, method.getName(), baseClass.getName()));
    }

    public static DataType extractFromMethodOutput(DataTypeFactory typeFactory, Class<?> baseClass, Method method) {
        DataTypeHint hint = method.getAnnotation(DataTypeHint.class);
        DataTypeTemplate template = hint != null ? DataTypeTemplate.fromAnnotation(typeFactory, hint) : DataTypeTemplate.fromDefaults();
        return DataTypeExtractor.extractDataTypeWithClassContext(typeFactory, template, baseClass, method.getGenericReturnType(), String.format(" in return type of method '%s' in class '%s'", method.getName(), baseClass.getName()));
    }

    private static DataType extractDataTypeWithClassContext(DataTypeFactory typeFactory, DataTypeTemplate outerTemplate, @Nullable Type contextType, Type type, String contextExplanation) {
        DataTypeExtractor extractor = new DataTypeExtractor(typeFactory, contextExplanation);
        List<Type> typeHierarchy = contextType != null ? ExtractionUtils.collectTypeHierarchy(contextType) : Collections.emptyList();
        return extractor.extractDataTypeOrRaw(outerTemplate, typeHierarchy, type);
    }

    private DataType extractDataTypeOrRaw(DataTypeTemplate outerTemplate, List<Type> typeHierarchy, Type type) {
        DataTypeHint hint;
        Type resolvedType = type instanceof TypeVariable ? ExtractionUtils.resolveVariable(typeHierarchy, (TypeVariable)type) : type;
        DataTypeTemplate template = outerTemplate;
        Class<?> clazz = ExtractionUtils.toClass(resolvedType);
        if (clazz != null && (hint = clazz.getAnnotation(DataTypeHint.class)) != null) {
            template = outerTemplate.mergeWithInnerAnnotation(this.typeFactory, hint);
        }
        DataType dataType2 = this.extractDataTypeOrRawWithTemplate(template, typeHierarchy, resolvedType);
        dataType2 = this.handleDataViewHints(dataType2, clazz);
        return this.closestBridging(dataType2, clazz);
    }

    private DataType extractDataTypeOrRawWithTemplate(DataTypeTemplate template, List<Type> typeHierarchy, Type type) {
        if (template.dataType != null) {
            return template.dataType;
        }
        try {
            return this.extractDataTypeOrError(template, typeHierarchy, type);
        }
        catch (Throwable t) {
            Class<?> clazz = ExtractionUtils.toClass(type);
            if (template.isAllowRawGlobally() || template.isAllowAnyPattern(clazz)) {
                return ExtractionUtils.createRawType(this.typeFactory, template.rawSerializer, clazz);
            }
            throw ExtractionUtils.extractionError(t, "Could not extract a data type from '%s'%s. Please pass the required data type manually or allow RAW types.", type.toString(), this.contextExplanation);
        }
    }

    private DataType extractDataTypeOrError(DataTypeTemplate template, List<Type> typeHierarchy, Type type) {
        if (type instanceof TypeVariable) {
            throw ExtractionUtils.extractionError("Unresolved type variable '%s'. A data type cannot be extracted from a type variable. The original content might have been erased due to Java type erasure.", type.toString());
        }
        DataType resultDataType = this.extractArrayType(template, typeHierarchy, type);
        if (resultDataType != null) {
            return resultDataType;
        }
        resultDataType = this.extractEnforcedRawType(template, type);
        if (resultDataType != null) {
            return resultDataType;
        }
        this.checkForCommonErrors(type);
        resultDataType = this.extractPredefinedType(template, type);
        if (resultDataType != null) {
            return resultDataType;
        }
        resultDataType = this.extractMapType(template, typeHierarchy, type);
        if (resultDataType != null) {
            return resultDataType;
        }
        try {
            return this.extractStructuredType(template, typeHierarchy, type);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Could not extract a data type from '%s'. Interpreting it as a structured type was also not successful.", type.toString());
        }
    }

    @Nullable
    private DataType extractArrayType(DataTypeTemplate template, List<Type> typeHierarchy, Type type) {
        if (type == byte[].class) {
            return DataTypes.BYTES();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArray = (GenericArrayType)type;
            return DataTypes.ARRAY(this.extractDataTypeOrRaw(template, typeHierarchy, genericArray.getGenericComponentType()));
        }
        Class<?> clazz = ExtractionUtils.toClass(type);
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return DataTypes.ARRAY(this.extractDataTypeOrRaw(template, typeHierarchy, clazz.getComponentType()));
        }
        if (clazz != List.class) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            throw ExtractionUtils.extractionError("The class '%s' needs generic parameters for an array type.", List.class.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        DataType element = this.extractDataTypeOrRaw(template, typeHierarchy, parameterizedType.getActualTypeArguments()[0]);
        return (DataType)DataTypes.ARRAY(element).bridgedTo(List.class);
    }

    @Nullable
    private DataType extractEnforcedRawType(DataTypeTemplate template, Type type) {
        Class<?> clazz = ExtractionUtils.toClass(type);
        if (template.isForceAnyPattern(clazz)) {
            return ExtractionUtils.createRawType(this.typeFactory, template.rawSerializer, clazz);
        }
        return null;
    }

    private void checkForCommonErrors(Type type) {
        Class<?> clazz = ExtractionUtils.toClass(type);
        if (clazz == null) {
            return;
        }
        if (clazz == Row.class) {
            throw ExtractionUtils.extractionError("Cannot extract a data type from a pure '%s' class. Please use annotations to define field names and field types.", Row.class.getName());
        }
        if (clazz == Object.class) {
            throw ExtractionUtils.extractionError("Cannot extract a data type from a pure '%s' class. Usually, this indicates that class information is missing or got lost. Please specify a more concrete class or treat it as a RAW type.", Object.class.getName());
        }
        if (clazz.getName().startsWith("scala.Tuple")) {
            throw ExtractionUtils.extractionError("Scala tuples are not supported. Use case classes or '%s' instead.", Row.class.getName());
        }
        if (clazz.getName().startsWith("scala.collection")) {
            throw ExtractionUtils.extractionError("Scala collections are not supported. See the documentation for supported classes or treat them as RAW types.", new Object[0]);
        }
    }

    @Nullable
    private DataType extractPredefinedType(DataTypeTemplate template, Type type) {
        Class<?> clazz = ExtractionUtils.toClass(type);
        if (clazz == null) {
            return null;
        }
        if (clazz == BigDecimal.class) {
            if (template.defaultDecimalPrecision != null && template.defaultDecimalScale != null) {
                return DataTypes.DECIMAL(template.defaultDecimalPrecision, template.defaultDecimalScale);
            }
            if (template.defaultDecimalPrecision != null) {
                return DataTypes.DECIMAL(template.defaultDecimalPrecision, 0);
            }
            throw ExtractionUtils.extractionError("Values of '%s' need fixed precision and scale.", BigDecimal.class.getName());
        }
        if (clazz == Time.class || clazz == LocalTime.class) {
            if (template.defaultSecondPrecision != null) {
                return (DataType)DataTypes.TIME(template.defaultSecondPrecision).bridgedTo(clazz);
            }
        } else if (clazz == Timestamp.class || clazz == LocalDateTime.class) {
            if (template.defaultSecondPrecision != null) {
                return (DataType)DataTypes.TIMESTAMP(template.defaultSecondPrecision).bridgedTo(clazz);
            }
        } else if (clazz == OffsetDateTime.class) {
            if (template.defaultSecondPrecision != null) {
                return DataTypes.TIMESTAMP_WITH_TIME_ZONE(template.defaultSecondPrecision);
            }
        } else if (clazz == Instant.class) {
            if (template.defaultSecondPrecision != null) {
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(template.defaultSecondPrecision);
            }
        } else if (clazz == Duration.class) {
            if (template.defaultSecondPrecision != null) {
                return DataTypes.INTERVAL(DataTypes.SECOND(template.defaultSecondPrecision));
            }
        } else if (clazz == Period.class) {
            if (template.defaultYearPrecision != null && template.defaultYearPrecision == 0) {
                return DataTypes.INTERVAL(DataTypes.MONTH());
            }
            if (template.defaultYearPrecision != null) {
                return DataTypes.INTERVAL(DataTypes.YEAR(template.defaultYearPrecision), DataTypes.MONTH());
            }
        }
        return ClassDataTypeConverter.extractDataType(clazz).orElse(null);
    }

    @Nullable
    private DataType extractMapType(DataTypeTemplate template, List<Type> typeHierarchy, Type type) {
        Class<?> clazz = ExtractionUtils.toClass(type);
        if (clazz != Map.class) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            throw ExtractionUtils.extractionError("The class '%s' needs generic parameters for a map type.", Map.class.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        DataType key = this.extractDataTypeOrRaw(template, typeHierarchy, parameterizedType.getActualTypeArguments()[0]);
        DataType value = this.extractDataTypeOrRaw(template, typeHierarchy, parameterizedType.getActualTypeArguments()[1]);
        return DataTypes.MAP(key, value);
    }

    private DataType extractStructuredType(DataTypeTemplate template, List<Type> typeHierarchy, Type type) {
        Class<?> clazz = ExtractionUtils.toClass(type);
        if (clazz == null) {
            throw ExtractionUtils.extractionError("Not a class type.", new Object[0]);
        }
        ExtractionUtils.validateStructuredClass(clazz);
        ExtractionUtils.validateStructuredSelfReference(type, typeHierarchy);
        List<Field> fields = ExtractionUtils.collectStructuredFields(clazz);
        if (fields.isEmpty()) {
            throw ExtractionUtils.extractionError("Class '%s' has no fields.", clazz.getName());
        }
        boolean allFieldsMutable = fields.stream().allMatch(f -> {
            ExtractionUtils.validateStructuredFieldReadability(clazz, f);
            return ExtractionUtils.isStructuredFieldMutable(clazz, f);
        });
        ExtractionUtils.AssigningConstructor constructor = ExtractionUtils.extractAssigningConstructor(clazz, fields);
        if (!allFieldsMutable && constructor == null) {
            throw ExtractionUtils.extractionError("Class '%s' has immutable fields and thus requires a constructor that is publicly accessible and assigns all fields: %s", clazz.getName(), fields.stream().map(Field::getName).collect(Collectors.joining(", ")));
        }
        if (constructor == null && !ExtractionUtils.hasInvokableConstructor(clazz, new Class[0])) {
            throw ExtractionUtils.extractionError("Class '%s' has neither a constructor that assigns all fields nor a default constructor.", clazz.getName());
        }
        Map<String, DataType> fieldDataTypes = this.extractStructuredTypeFields(template, typeHierarchy, type, fields);
        DataTypes.Field[] attributes = this.createStructuredTypeAttributes(constructor, fieldDataTypes);
        return DataTypes.STRUCTURED(clazz, attributes);
    }

    private Map<String, DataType> extractStructuredTypeFields(DataTypeTemplate template, List<Type> typeHierarchy, Type type, List<Field> fields) {
        HashMap<String, DataType> fieldDataTypes = new HashMap<String, DataType>();
        List<Type> structuredTypeHierarchy = ExtractionUtils.collectTypeHierarchy(type);
        for (Field field : fields) {
            try {
                Type fieldType = field.getGenericType();
                ArrayList<Type> fieldTypeHierarchy = new ArrayList<Type>();
                fieldTypeHierarchy.addAll(typeHierarchy);
                fieldTypeHierarchy.addAll(structuredTypeHierarchy);
                DataTypeTemplate fieldTemplate = this.mergeFieldTemplate(this.typeFactory, field, template);
                DataType fieldDataType = this.extractDataTypeOrRaw(fieldTemplate, fieldTypeHierarchy, fieldType);
                fieldDataTypes.put(field.getName(), fieldDataType);
            }
            catch (Throwable t) {
                throw ExtractionUtils.extractionError(t, "Error in field '%s' of class '%s'.", field.getName(), field.getDeclaringClass().getName());
            }
        }
        return fieldDataTypes;
    }

    private DataTypes.Field[] createStructuredTypeAttributes(ExtractionUtils.AssigningConstructor constructor, Map<String, DataType> fieldDataTypes) {
        return (DataTypes.Field[])Optional.ofNullable(constructor).map(c -> c.parameterNames.stream()).orElseGet(() -> fieldDataTypes.keySet().stream().sorted()).map(name -> DataTypes.FIELD(name, (DataType)fieldDataTypes.get(name))).toArray(DataTypes.Field[]::new);
    }

    private DataTypeTemplate mergeFieldTemplate(DataTypeFactory typeFactory, Field field, DataTypeTemplate structuredTemplate) {
        DataTypeHint hint = field.getAnnotation(DataTypeHint.class);
        if (hint == null) {
            return structuredTemplate.copyWithoutDataType();
        }
        return structuredTemplate.mergeWithInnerAnnotation(typeFactory, hint);
    }

    private DataType closestBridging(DataType dataType2, @Nullable Class<?> clazz) {
        boolean supportsConversion;
        if (clazz == null || clazz.isAssignableFrom(dataType2.getConversionClass())) {
            return dataType2;
        }
        LogicalType logicalType = dataType2.getLogicalType();
        boolean bl = supportsConversion = logicalType.supportsInputConversion(clazz) || logicalType.supportsOutputConversion(clazz);
        if (supportsConversion) {
            return (DataType)dataType2.bridgedTo(clazz);
        }
        return dataType2;
    }

    private DataType handleDataViewHints(DataType dataType2, @Nullable Class<?> clazz) {
        if (clazz == null || !DataView.class.isAssignableFrom(clazz)) {
            return dataType2;
        }
        if (LogicalTypeChecks.isCompositeType(dataType2.getLogicalType())) {
            return dataType2;
        }
        if (ListView.class.isAssignableFrom(clazz)) {
            if (!LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.ARRAY)) {
                throw ExtractionUtils.extractionError("Annotated list views should have a logical type of ARRAY.", new Object[0]);
            }
            CollectionDataType collectionDataType = (CollectionDataType)dataType2;
            return ListView.newListViewDataType(collectionDataType.getElementDataType());
        }
        if (MapView.class.isAssignableFrom(clazz)) {
            if (!LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.MAP)) {
                throw ExtractionUtils.extractionError("Annotated map views should have a logical type of MAP.", new Object[0]);
            }
            KeyValueDataType keyValueDataType = (KeyValueDataType)dataType2;
            return MapView.newMapViewDataType(keyValueDataType.getKeyDataType(), keyValueDataType.getValueDataType());
        }
        throw ExtractionUtils.extractionError("Invalid data view: %s", clazz.getName());
    }
}

