/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import org.apache.flink.table.shaded.org.joda.time.format.DateTimeFormatter;
import org.apache.flink.table.shaded.org.joda.time.format.DateTimeFormatterBuilder;
import org.apache.flink.table.utils.ThreadLocalCache;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DateTimeFunctions$ {
    public static final DateTimeFunctions$ MODULE$;
    private final int PIVOT_YEAR;
    private final ThreadLocalCache<String, DateTimeFormatter> DATETIME_FORMATTER_CACHE;

    static {
        new DateTimeFunctions$();
    }

    private int PIVOT_YEAR() {
        return this.PIVOT_YEAR;
    }

    private ThreadLocalCache<String, DateTimeFormatter> DATETIME_FORMATTER_CACHE() {
        return this.DATETIME_FORMATTER_CACHE;
    }

    public String dateFormat(long ts, String formatString) {
        DateTimeFormatter formatter = this.DATETIME_FORMATTER_CACHE().get(formatString);
        return formatter.print(ts);
    }

    public DateTimeFormatter createDateTimeFormatter(String format) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < format.length()) {
            Object object;
            char character = format.charAt(i);
            ++i;
            if (escaped) {
                char c = character;
                switch (c) {
                    default: {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendLiteral(character);
                        break;
                    }
                    case '%': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendLiteral('%');
                        break;
                    }
                    case 'D': 
                    case 'U': 
                    case 'V': 
                    case 'X': 
                    case 'u': 
                    case 'w': {
                        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%%", " not supported in date format string"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)character)})));
                    }
                    case 'y': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendTwoDigitYear(this.PIVOT_YEAR());
                        break;
                    }
                    case 'Y': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendYear(4, 4);
                        break;
                    }
                    case 'W': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendDayOfWeekText();
                        break;
                    }
                    case 'x': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendWeekyear(4, 4);
                        break;
                    }
                    case 'v': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendWeekOfWeekyear(2);
                        break;
                    }
                    case 'T': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'r': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendClockhourOfHalfday(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendLiteral(' ').appendHalfdayOfDayText();
                        break;
                    }
                    case 'p': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'm': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'M': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendMonthOfYearText();
                        break;
                    }
                    case 'l': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendClockhourOfHalfday(1);
                        break;
                    }
                    case 'k': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendHourOfDay(1);
                        break;
                    }
                    case 'j': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendDayOfYear(3);
                        break;
                    }
                    case 'i': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'I': 
                    case 'h': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'H': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendHourOfDay(2);
                        break;
                    }
                    case 'f': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendFractionOfSecond(6, 9);
                        break;
                    }
                    case 'e': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendDayOfMonth(1);
                        break;
                    }
                    case 'd': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'c': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendMonthOfYear(1);
                        break;
                    }
                    case 'b': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'a': {
                        DateTimeFormatterBuilder dateTimeFormatterBuilder = builder.appendDayOfWeekShortText();
                    }
                }
                escaped = false;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (character == '%') {
                escaped = true;
                object = BoxedUnit.UNIT;
                continue;
            }
            object = builder.appendLiteral(character);
        }
        return builder.toFormatter();
    }

    private DateTimeFunctions$() {
        MODULE$ = this;
        this.PIVOT_YEAR = 2020;
        this.DATETIME_FORMATTER_CACHE = new ThreadLocalCache<String, DateTimeFormatter>(){

            public DateTimeFormatter getNewInstance(String format) {
                return DateTimeFunctions$.MODULE$.createDateTimeFormatter(format);
            }
        };
    }
}

