/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001=\u00111\u0004\u0015:pGRKW.Z*peR\u0004&o\\2fgN4UO\\2uS>t'BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0003!u\u0019\"\u0001A\t\u0011\u000bII2$K\u0015\u000e\u0003MQ!\u0001F\u000b\u0002\u0013\u0019,hn\u0019;j_:\u001c(B\u0001\f\u0018\u0003\r\t\u0007/\u001b\u0006\u00031!\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005i\u0019\"\u0001F&fs\u0016$\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0002\u001d;1\u0001A!\u0002\u0010\u0001\u0005\u0004y\"!A&\u0012\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#a\u0002(pi\"Lgn\u001a\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\u0007\u0005s\u0017\u0010\u0005\u0002+[5\t1F\u0003\u0002-\t\u0005)A/\u001f9fg&\u0011af\u000b\u0002\u0005\u0007J{w\u000f\u0003\u00051\u0001\t\u0015\r\u0011\"\u00032\u00031Ig\u000e];u%><H+\u001f9f+\u0005\u0011\u0004C\u0001\u00164\u0013\t!4F\u0001\u0007D%><H+\u001f9f\u0013:4w\u000e\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u00035Ig\u000e];u%><H+\u001f9fA!A\u0001\b\u0001BC\u0002\u0013%\u0011(A\u0007s_^\u001cu.\u001c9be\u0006$xN]\u000b\u0002uA\u00111\bP\u0007\u0002\u0005%\u0011QH\u0001\u0002\u0018\u0007>dG.Z2uS>t'k\\<D_6\u0004\u0018M]1u_JD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IAO\u0001\u000fe><8i\\7qCJ\fGo\u001c:!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q\u00191\tR#\u0011\u0007m\u00021\u0004C\u00031\u0001\u0002\u0007!\u0007C\u00039\u0001\u0002\u0007!\bC\u0005H\u0001\u0001\u0007\t\u0019!C\u0005\u0011\u0006q!-\u001e4gKJ,G-\u0012<f]R\u001cX#A%\u0011\u0007)\u0003&+D\u0001L\u0015\taU*A\u0003ti\u0006$XM\u0003\u0002O\u001f\u000611m\\7n_:T!A\u0006\u0005\n\u0005E[%!\u0003'jgR\u001cF/\u0019;f!\t\u0019V+D\u0001U\u0015\ta\u0003\"\u0003\u0002W)\n\u0019!k\\<\t\u0013a\u0003\u0001\u0019!a\u0001\n\u0013I\u0016A\u00052vM\u001a,'/\u001a3Fm\u0016tGo]0%KF$\"AW/\u0011\u0005\u0005Z\u0016B\u0001/#\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\t\r\u0001\u0004\u0001\u0015)\u0003J\u0003=\u0011WO\u001a4fe\u0016$WI^3oiN\u0004\u0003b\u00022\u0001\u0005\u0004%IaY\u0001\u000bg>\u0014HOQ;gM\u0016\u0014X#\u00013\u0011\u0007\u0015T'+D\u0001g\u0015\t9\u0007.\u0001\u0003vi&d'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001a\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\t\r5\u0004\u0001\u0015!\u0003e\u0003-\u0019xN\u001d;Ck\u001a4WM\u001d\u0011\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0013\u0001\u0018aB8viB,HoQ\u000b\u0002S!I!\u000f\u0001a\u0001\u0002\u0004%Ia]\u0001\f_V$\b/\u001e;D?\u0012*\u0017\u000f\u0006\u0002[i\"9a,]A\u0001\u0002\u0004I\u0003B\u0002<\u0001A\u0003&\u0011&\u0001\u0005pkR\u0004X\u000f^\"!\u0011\u0015A\b\u0001\"\u0011z\u0003\u0011y\u0007/\u001a8\u0015\u0005iS\b\"B>x\u0001\u0004a\u0018AB2p]\u001aLw\rE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\"\tQbY8oM&<WO]1uS>t\u0017bAA\u0002}\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!a\u0002\u0001\t\u0003\nI!\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000fi\u000bY!a\u0004\u0002\u001a!9\u0011QBA\u0003\u0001\u0004I\u0013AB5oaV$8\t\u0003\u0005\u0002\u0012\u0005\u0015\u0001\u0019AA\n\u0003\r\u0019G\u000f\u001f\t\u0004#\u0005U\u0011bAA\f3\t91i\u001c8uKb$\b\u0002CA\u000e\u0003\u000b\u0001\r!!\b\u0002\u0007=,H\u000fE\u0003\u0002 \u0005\r\u0012&\u0004\u0002\u0002\")\u0011q\rC\u0005\u0005\u0003K\t\tCA\u0005D_2dWm\u0019;pe\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012aB8o)&lWM\u001d\u000b\b5\u00065\u0012qGA \u0011!\ty#a\nA\u0002\u0005E\u0012!\u0003;j[\u0016\u001cH/Y7q!\r\t\u00131G\u0005\u0004\u0003k\u0011#\u0001\u0002'p]\u001eD\u0001\"!\u0005\u0002(\u0001\u0007\u0011\u0011\b\t\u0004#\u0005m\u0012bAA\u001f3\tqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CA\u000e\u0003O\u0001\r!!\b")
public class ProcTimeSortProcessFunction<K>
extends KeyedProcessFunction<K, CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final CollectionRowComparator rowComparator;
    private ListState<Row> bufferedEvents;
    private final ArrayList<Row> sortBuffer;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private CollectionRowComparator rowComparator() {
        return this.rowComparator;
    }

    private ListState<Row> bufferedEvents() {
        return this.bufferedEvents;
    }

    private void bufferedEvents_$eq(ListState<Row> x$1) {
        this.bufferedEvents = x$1;
    }

    private ArrayList<Row> sortBuffer() {
        return this.sortBuffer;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        ListStateDescriptor sortDescriptor = new ListStateDescriptor("sortState", (TypeInformation)this.inputRowType().rowType());
        this.bufferedEvents_$eq((ListState<Row>)this.getRuntimeContext().getListState(sortDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        long currentTime = ctx.timerService().currentProcessingTime();
        this.bufferedEvents().add((Object)input);
        ctx.timerService().registerProcessingTimeTimer(currentTime + 1L);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator iter = ((Iterable)this.bufferedEvents().get()).iterator();
        this.sortBuffer().clear();
        while (iter.hasNext()) {
            this.sortBuffer().add((Row)iter.next());
        }
        Collections.sort(this.sortBuffer(), this.rowComparator());
        for (int i = 0; i < this.sortBuffer().size(); ++i) {
            this.outputC().row_$eq(this.sortBuffer().get(i));
            out.collect((Object)this.outputC());
        }
        this.bufferedEvents().clear();
    }

    public ProcTimeSortProcessFunction(CRowTypeInfo inputRowType, CollectionRowComparator rowComparator) {
        this.inputRowType = inputRowType;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull((Object)rowComparator);
        this.sortBuffer = new ArrayList();
    }
}

