/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.logical;

import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.plan.util.RexProgramExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001E\u0011\u0011\u0005U;tQ\u001aKG\u000e^3s\u0013:$x\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016T!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\u0006eVdWm\u001d\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019r#D\u0001\u0015\u0015\t9QC\u0003\u0002\u0017\u0019\u000591-\u00197dSR,\u0017B\u0001\r\u0015\u0005)\u0011V\r\\(qiJ+H.\u001a\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\tAqa\b\u0001C\u0002\u0013%\u0001%A\u0006uC\ndWmQ8oM&<W#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011B\u0011aA1qS&\u0011ae\t\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0004)\u0001\u0001\u0006I!I\u0001\ri\u0006\u0014G.Z\"p]\u001aLw\r\t\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u00039!WMZ1vYR\u001c\u0015\r^1m_\u001e,\u0012\u0001\f\t\u0003[Ij\u0011A\f\u0006\u0003_A\nA\u0001\\1oO*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005\u0019\u0019FO]5oO\"1Q\u0007\u0001Q\u0001\n1\nq\u0002Z3gCVdGoQ1uC2|w\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y!\tqaY1uC2|w-\u0003\u0002?w\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\bB\u0002!\u0001A\u0003%\u0011(A\bdCR\fGn\\4NC:\fw-\u001a:!\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003\u001di\u0017\r^2iKN$\"\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000f\t{w\u000e\\3b]\")1*\u0011a\u0001\u0019\u0006!1-\u00197m!\t\u0019R*\u0003\u0002O)\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"\u0002)\u0001\t\u0003\n\u0016aB8o\u001b\u0006$8\r\u001b\u000b\u0003%V\u0003\"!R*\n\u0005Q3%\u0001B+oSRDQaS(A\u00021CQa\u0016\u0001\u0005\na\u000b!\u0003];tQ\u001aKG\u000e^3s\u0013:$xnU2b]R1!+\u0017.dQrDQa\u0013,A\u00021CQa\u0017,A\u0002q\u000bAaY1mGB\u0011Q,Y\u0007\u0002=*\u00111a\u0018\u0006\u0003A\u001a\tQA\\8eKNL!A\u00190\u0003!\u0019c\u0017N\\6M_\u001eL7-\u00197DC2\u001c\u0007\"\u00023W\u0001\u0004)\u0017\u0001B:dC:\u0004\"!\u00184\n\u0005\u001dt&a\u0007$mS:\\Gj\\4jG\u0006dG+\u00192mKN{WO]2f'\u000e\fg\u000eC\u0003j-\u0002\u0007!.\u0001\tgS2$XM]1cY\u0016\u001cv.\u001e:dKB\u00121n\u001d\t\u0004Y>\fX\"A7\u000b\u00059D\u0011aB:pkJ\u001cWm]\u0005\u0003a6\u0014QCR5mi\u0016\u0014\u0018M\u00197f)\u0006\u0014G.Z*pkJ\u001cW\r\u0005\u0002sg2\u0001A!\u0003;i\u0003\u0003\u0005\tQ!\u0001v\u0005\ryFEM\t\u0003mf\u0004\"!R<\n\u0005a4%a\u0002(pi\"Lgn\u001a\t\u0003\u000bjL!a\u001f$\u0003\u0007\u0005s\u0017\u0010C\u0003~-\u0002\u0007a0A\u0006eKN\u001c'/\u001b9uS>t\u0007cA@\u0002\u00069\u0019Q)!\u0001\n\u0007\u0005\ra)\u0001\u0004Qe\u0016$WMZ\u0005\u0004g\u0005\u001d!bAA\u0002\r\u001e9\u00111\u0002\u0002\t\u0002\u00055\u0011!\t)vg\"4\u0015\u000e\u001c;fe&sGo\u001c+bE2,7k\\;sG\u0016\u001c6-\u00198Sk2,\u0007cA\u000f\u0002\u0010\u00191\u0011A\u0001E\u0001\u0003#\u0019B!a\u0004\u0002\u0014A\u0019Q)!\u0006\n\u0007\u0005]aI\u0001\u0004B]f\u0014VM\u001a\u0005\b5\u0005=A\u0011AA\u000e)\t\ti\u0001\u0003\u0006\u0002 \u0005=!\u0019!C\u0001\u0003C\t\u0001\"\u0013(T)\u0006s5)R\u000b\u0002%!A\u0011QEA\bA\u0003%!#A\u0005J\u001dN#\u0016IT\"FA\u0001")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    private final TableConfig tableConfig = TableConfig.getDefault();
    private final String defaultCatalog;
    private final CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(Thread.currentThread().getContextClassLoader()).config((ReadableConfig)this.tableConfig().getConfiguration()).defaultCatalog(this.defaultCatalog(), new GenericInMemoryCatalog(this.defaultCatalog(), "default_database")).build();

    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    private TableConfig tableConfig() {
        return this.tableConfig;
    }

    private String defaultCatalog() {
        return this.defaultCatalog;
    }

    private CatalogManager catalogManager() {
        return this.catalogManager;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSource<?> tableSource = scan.tableSource();
        if (tableSource instanceof FilterableTableSource) {
            TableSource<?> tableSource2 = tableSource;
            bl = calc.getProgram().getCondition() != null && !((FilterableTableSource)((Object)tableSource2)).isFilterPushedDown();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        FilterableTableSource filterableSource = (FilterableTableSource)((Object)scan.tableSource());
        this.pushFilterIntoScan(call, calc, scan, filterableSource, this.description);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, FlinkLogicalCalc calc, FlinkLogicalTableSourceScan scan, FilterableTableSource<?> filterableSource, String description) {
        Preconditions.checkArgument((!filterableSource.isFilterPushedDown() ? 1 : 0) != 0);
        RexProgram program = calc.getProgram();
        Tuple2<Expression[], RexNode[]> tuple2 = RexProgramExtractor$.MODULE$.extractConjunctiveConditions(program, call.builder().getRexBuilder(), new FunctionCatalog(this.tableConfig(), this.catalogManager(), new ModuleManager()));
        if (tuple2 != null) {
            RexProgram newRexProgram;
            RexProgram rexProgram;
            RexNode rexNode;
            Tuple2 tuple22;
            Expression[] predicates = (Expression[])tuple2._1();
            RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
            Expression[] predicates2 = (Expression[])tuple23._1();
            RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
            if (Predef$.MODULE$.refArrayOps((Object[])predicates2).isEmpty()) {
                return;
            }
            LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
            Predef$.MODULE$.refArrayOps((Object[])predicates2).foreach((Function1)new Serializable(this, remainingPredicates){
                public static final long serialVersionUID = 0L;
                private final LinkedList remainingPredicates$1;

                public final boolean apply(Expression e) {
                    return this.remainingPredicates$1.add(e);
                }
                {
                    this.remainingPredicates$1 = remainingPredicates$1;
                }
            });
            TableSource<?> newTableSource = filterableSource.applyPredicate(remainingPredicates);
            if (((FilterableTableSource)((Object)newTableSource)).isFilterPushedDown() && newTableSource.explainSource().equals(scan.tableSource().explainSource())) {
                throw new TableException("Failed to push filter into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
            }
            RelBuilder relBuilder = call.builder();
            if (remainingPredicates.isEmpty() && !Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2).nonEmpty()) {
                rexNode = null;
            } else {
                relBuilder.push(scan);
                Buffer remainingPrecidatesAsExpr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(remainingPredicates).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PlannerExpression apply(Expression x$2) {
                        return (PlannerExpression)x$2;
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                Buffer remainingConditions = ((BufferLike)remainingPrecidatesAsExpr.map((Function1)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(PlannerExpression x$3) {
                        return x$3.toRexNode(this.relBuilder$1);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2));
                rexNode = (RexNode)remainingConditions.reduce((Function2)new Serializable(this, relBuilder){
                    public static final long serialVersionUID = 0L;
                    private final RelBuilder relBuilder$1;

                    public final RexNode apply(RexNode l, RexNode r) {
                        return this.relBuilder$1.and(l, r);
                    }
                    {
                        this.relBuilder$1 = relBuilder$1;
                    }
                });
            }
            RexNode remainingCondition = rexNode;
            FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), scan.tableSchema(), newTableSource, scan.selectedFields());
            if (remainingCondition == null && program.projectsOnlyIdentity()) {
                rexProgram = null;
            } else {
                List expandedProjectList = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(program.getProjectList()).asScala()).map((Function1)new Serializable(this, program){
                    public static final long serialVersionUID = 0L;
                    private final RexProgram program$1;

                    public final RexNode apply(RexLocalRef ref) {
                        return this.program$1.expandLocalRef(ref);
                    }
                    {
                        this.program$1 = program$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).asJava();
                rexProgram = newRexProgram = RexProgram.create(program.getInputRowType(), (List<? extends RexNode>)expandedProjectList, remainingCondition, program.getOutputRowType(), relBuilder.getRexBuilder());
            }
            if (newRexProgram == null) {
                call.transformTo(newScan);
            } else {
                Calc newCalc = calc.copy(calc.getTraitSet(), newScan, newRexProgram);
                call.transformTo(newCalc);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalCalc.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
        this.defaultCatalog = "default_catalog";
    }
}

