/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.CommonSort;
import org.apache.flink.table.plan.nodes.CommonSort$class;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel$class;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.aggregate.IdentityCRowMap;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n'>\u0014HO\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\u000f!!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0003d_J,'BA\f\u0019\u0003\r\u0011X\r\u001c\u0006\u000331\tqaY1mG&$X-\u0003\u0002\u001c)\t!1k\u001c:u!\tib$D\u0001\u0005\u0013\tyBA\u0001\u0006D_6lwN\\*peR\u0004\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u001b\u0011\u000bG/Y*ue\u0016\fWNU3m\u0011!)\u0003A!A!\u0002\u00131\u0013aB2mkN$XM\u001d\t\u0003O%j\u0011\u0001\u000b\u0006\u0003\u000faI!A\u000b\u0015\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u001dr\u0013BA\u0018)\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0011\"\u001b8qkRtu\u000eZ3\u0011\u0005M\"T\"\u0001\f\n\u0005U2\"a\u0002*fY:{G-\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005Y\u0011N\u001c9viN\u001b\u0007.Z7b!\tID(D\u0001;\u0015\tYd!\u0001\u0004tG\",W.Y\u0005\u0003{i\u0012\u0011BU8x'\u000eDW-\\1\t\u0011m\u0002!\u0011!Q\u0001\naB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000eg>\u0014HoQ8mY\u0006$\u0018n\u001c8\u0011\u0005M\u0012\u0015BA\"\u0017\u00051\u0011V\r\\\"pY2\fG/[8o\u0011!)\u0005A!A!\u0002\u00131\u0015AC:peR|eMZ:fiB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nG\u0001\u0004e\u0016D\u0018BA&I\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAR\u0001\ng>\u0014HOR3uG\"D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002R/:\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\u00061\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t16\u000bC\u0003\\\u0001\u0011\u0005A,\u0001\u0004=S:LGO\u0010\u000b\u000b;z{\u0006-\u00192dI\u00164\u0007CA\u0011\u0001\u0011\u0015)#\f1\u0001'\u0011\u0015a#\f1\u0001.\u0011\u0015\t$\f1\u00013\u0011\u00159$\f1\u00019\u0011\u0015Y$\f1\u00019\u0011\u0015\u0001%\f1\u0001B\u0011\u0015)%\f1\u0001G\u0011\u0015i%\f1\u0001G\u0011\u0015y%\f1\u0001Q\u0011\u0015A\u0007\u0001\"\u0011j\u00035!WM]5wKJ{w\u000fV=qKR\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002n-\u0005!A/\u001f9f\u0013\tyGNA\u0006SK2$\u0015\r^1UsB,\u0007\"B9\u0001\t\u0003\u0012\u0018\u0001B2paf$bAE:umbT\b\"\u0002\u0017q\u0001\u0004i\u0003\"B;q\u0001\u0004\u0011\u0014!B5oaV$\b\"B<q\u0001\u0004\t\u0015\u0001\u00048fo\u000e{G\u000e\\1uS>t\u0007\"B=q\u0001\u00041\u0015AB8gMN,G\u000fC\u0003|a\u0002\u0007a)A\u0003gKR\u001c\u0007\u000eC\u0003~\u0001\u0011\u0005c0\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0006bBA\u0001\u0001\u0011\u0005\u00131A\u0001\rKb\u0004H.Y5o)\u0016\u0014Xn\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u00024\u0003\u000fI1!!\u0003\u0017\u0005%\u0011V\r\\,sSR,'\u000fC\u0004\u0002\u000e}\u0004\r!!\u0002\u0002\u0005A<\bbBA\t\u0001\u0011\u0005\u00131C\u0001\u0010iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]R!\u0011QCA\u001c!\u0019\t9\"a\t\u0002(5\u0011\u0011\u0011\u0004\u0006\u0004\u0007\u0005m!\u0002BA\u000f\u0003?\t1!\u00199j\u0015\r\t\tCC\u0001\ngR\u0014X-Y7j]\u001eLA!!\n\u0002\u001a\tQA)\u0019;b'R\u0014X-Y7\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005)A/\u001f9fg*\u0019\u0011\u0011\u0007\u0005\u0002\u000fI,h\u000e^5nK&!\u0011QGA\u0016\u0005\u0011\u0019%k\\<\t\u0011\u0005e\u0012q\u0002a\u0001\u0003w\tq\u0001\u001d7b]:,'\u000f\u0005\u0003\u0002>\u0005\u0005SBAA \u0015\r\tI\u0004C\u0005\u0005\u0003\u0007\nyDA\u0007TiJ,\u0017-\u001c)mC:tWM\u001d\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003I\u0019'/Z1uKN{'\u000f\u001e)s_\u000e$\u0016.\\3\u0015\r\u0005U\u00111JA(\u0011!\ti%!\u0012A\u0002\u0005U\u0011aB5oaV$Hi\u0015\u0005\t\u0003#\n)\u00051\u0001\u0002T\u00059Q\r_3d\u0007\u001a<\u0007\u0003BA+\u0003;j!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005u!\"\u0003\u0003\u0002`\u0005]#aD#yK\u000e,H/[8o\u0007>tg-[4\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f\u0005\t2M]3bi\u0016\u001cvN\u001d;S_^$\u0016.\\3\u0015\r\u0005U\u0011qMA5\u0011!\ti%!\u0019A\u0002\u0005U\u0001\u0002CA)\u0003C\u0002\r!a\u0015")
public class DataStreamSort
extends Sort
implements CommonSort,
DataStreamRel {
    private final RelOptCluster cluster;
    private final RowSchema inputSchema;
    private final RowSchema schema;
    private final RelCollation sortCollation;
    private final RexNode sortOffset;
    private final RexNode sortFetch;
    private final String description;

    @Override
    public boolean needsUpdatesAsRetraction() {
        return DataStreamRel$class.needsUpdatesAsRetraction(this);
    }

    @Override
    public boolean producesUpdates() {
        return DataStreamRel$class.producesUpdates(this);
    }

    @Override
    public boolean consumesRetractions() {
        return DataStreamRel$class.consumesRetractions(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel$class.producesRetractions(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode$class.estimateRowSize(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode$class.estimateDataTypeSize(this, t);
    }

    @Override
    public long getFetchLimitEnd(RexNode fetch, RexNode offset) {
        return CommonSort$class.getFetchLimitEnd(this, fetch, offset);
    }

    @Override
    public long getFetchLimitStart(RexNode offset) {
        return CommonSort$class.getFetchLimitStart(this, offset);
    }

    @Override
    public String sortToString(RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort$class.sortToString(this, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelWriter sortExplainTerms(RelWriter pw, RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort$class.sortExplainTerms(this, pw, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new DataStreamSort(this.cluster, traitSet, input, this.inputSchema, this.schema, newCollation, offset, fetch, this.description);
    }

    @Override
    public String toString() {
        return this.sortToString(this.schema.relDataType(), this.sortCollation, this.sortOffset, this.sortFetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.sortExplainTerms(pw.input("input", this.getInput()), this.schema.relDataType(), this.sortCollation, this.sortOffset, this.sortFetch);
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner) {
        block9: {
            block12: {
                DataStream<CRow> dataStream;
                block11: {
                    ExecutionConfig execCfg;
                    RelDataType timeType;
                    DataStream<CRow> inputDS;
                    block10: {
                        DataStream<CRow> dataStream2;
                        inputDS = ((DataStreamRel)this.input).translateToPlan(planner);
                        timeType = SortUtil$.MODULE$.getFirstSortField(this.sortCollation, this.schema.relDataType()).getType();
                        RelFieldCollation.Direction direction = SortUtil$.MODULE$.getFirstSortDirection(this.sortCollation);
                        RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
                        if (direction != null ? !((Object)((Object)direction)).equals((Object)direction2) : direction2 != null) break block9;
                        execCfg = planner.getExecutionEnvironment().getConfig();
                        RelDataType relDataType = timeType;
                        if (!FlinkTypeFactory$.MODULE$.isProctimeIndicatorType(timeType)) break block10;
                        Tuple2 tuple2 = new Tuple2((Object)this.sortOffset, (Object)this.sortFetch);
                        if (tuple2 != null && tuple2._1() != null && tuple2._2() != null) {
                            throw new TableException("Streaming tables do not support sort with offset and fetch.");
                        }
                        if (tuple2 != null && tuple2._2() != null) {
                            throw new TableException("Streaming tables do not support sort with fetch.");
                        }
                        if (tuple2 != null && tuple2._1() != null) {
                            throw new TableException("Streaming tables do not support sort with offset.");
                        }
                        dataStream = dataStream2 = this.createSortProcTime(inputDS, execCfg);
                        break block11;
                    }
                    if (!FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeType)) break block12;
                    Tuple2 tuple2 = new Tuple2((Object)this.sortOffset, (Object)this.sortFetch);
                    if (tuple2 != null && tuple2._1() != null && tuple2._2() != null) {
                        throw new TableException("Streaming tables do not support sort with offset and fetch");
                    }
                    if (tuple2 != null && tuple2._2() != null) {
                        throw new TableException("Streaming tables do not support sort with fetch");
                    }
                    if (tuple2 != null && tuple2._1() != null) {
                        throw new TableException("Streaming tables do not support sort with offset");
                    }
                    DataStream<CRow> dataStream3 = this.createSortRowTime(inputDS, execCfg);
                    dataStream = dataStream3;
                }
                return dataStream;
            }
            throw new TableException("Primary sort order of a streaming table must be ascending on time.");
        }
        throw new TableException("Primary sort order of a streaming table must be ascending on time.");
    }

    public DataStream<CRow> createSortProcTime(DataStream<CRow> inputDS, ExecutionConfig execCfg) {
        SingleOutputStreamOperator singleOutputStreamOperator;
        CRowTypeInfo returnTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        if (this.sortCollation.getFieldCollations().size() > 1) {
            KeyedProcessFunction<Byte, CRow, CRow> KeyedProcessFunction2 = SortUtil$.MODULE$.createProcTimeSortFunction(this.sortCollation, this.inputSchema.relDataType(), this.inputSchema.typeInfo(), execCfg);
            singleOutputStreamOperator = inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(KeyedProcessFunction2).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
        } else {
            singleOutputStreamOperator = inputDS.map((MapFunction)new IdentityCRowMap()).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
        }
        return singleOutputStreamOperator;
    }

    public DataStream<CRow> createSortRowTime(DataStream<CRow> inputDS, ExecutionConfig execCfg) {
        CRowTypeInfo returnTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        KeyedProcessFunction<Byte, CRow, CRow> keyedProcessFunction = SortUtil$.MODULE$.createRowTimeSortFunction(this.sortCollation, this.inputSchema.relDataType(), this.inputSchema.typeInfo(), execCfg);
        return inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(keyedProcessFunction).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
    }

    public DataStreamSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, RowSchema inputSchema, RowSchema schema, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch, String description) {
        this.cluster = cluster;
        this.inputSchema = inputSchema;
        this.schema = schema;
        this.sortCollation = sortCollation;
        this.sortOffset = sortOffset;
        this.sortFetch = sortFetch;
        this.description = description;
        super(cluster, traitSet, inputNode, sortCollation, sortOffset, sortFetch);
        CommonSort$class.$init$(this);
        FlinkRelNode$class.$init$(this);
        DataStreamRel$class.$init$(this);
    }
}

