/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
final class ResolveCallByArgumentsRule
implements ResolverRule {
    ResolveCallByArgumentsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression2, ResolverRule.ResolutionContext context) {
        return expression2.stream().flatMap(expr -> expr.accept(new ResolvingCallVisitor(context, null)).stream()).collect(Collectors.toList());
    }

    private static class TableApiCallContext
    implements CallContext {
        private final DataTypeFactory typeFactory;
        private final String name;
        private final FunctionDefinition definition;
        private final List<ResolvedExpression> resolvedArgs;

        public TableApiCallContext(DataTypeFactory typeFactory, String name, FunctionDefinition definition, List<ResolvedExpression> resolvedArgs) {
            this.typeFactory = typeFactory;
            this.name = name;
            this.definition = definition;
            this.resolvedArgs = resolvedArgs;
        }

        @Override
        public DataTypeFactory getDataTypeFactory() {
            return this.typeFactory;
        }

        @Override
        public FunctionDefinition getFunctionDefinition() {
            return this.definition;
        }

        @Override
        public boolean isArgumentLiteral(int pos) {
            ResolvedExpression arg = this.getArgument(pos);
            return arg instanceof ValueLiteralExpression || arg instanceof TypeLiteralExpression;
        }

        @Override
        public boolean isArgumentNull(int pos) {
            Preconditions.checkArgument((boolean)this.isArgumentLiteral(pos), (String)"Argument at position %s is not a literal.", (Object[])new Object[]{pos});
            ResolvedExpression arg = this.getArgument(pos);
            if (arg instanceof TypeLiteralExpression) {
                return false;
            }
            ValueLiteralExpression literal = (ValueLiteralExpression)this.getArgument(pos);
            return literal.isNull();
        }

        @Override
        public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
            Preconditions.checkArgument((boolean)this.isArgumentLiteral(pos), (String)"Argument at position %s is not a literal.", (Object[])new Object[]{pos});
            ResolvedExpression arg = this.getArgument(pos);
            if (arg instanceof TypeLiteralExpression) {
                if (!DataType.class.isAssignableFrom(clazz)) {
                    return Optional.empty();
                }
                return Optional.of(arg.getOutputDataType());
            }
            ValueLiteralExpression literal = (ValueLiteralExpression)this.getArgument(pos);
            return literal.getValueAs(clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<DataType> getArgumentDataTypes() {
            return this.resolvedArgs.stream().map(ResolvedExpression::getOutputDataType).collect(Collectors.toList());
        }

        @Override
        public Optional<DataType> getOutputDataType() {
            return Optional.empty();
        }

        private ResolvedExpression getArgument(int pos) {
            if (pos >= this.resolvedArgs.size()) {
                throw new IndexOutOfBoundsException(String.format("Not enough arguments to access literal at position %d for function '%s'.", pos, this.name));
            }
            return this.resolvedArgs.get(pos);
        }
    }

    private static class ResolvingCallVisitor
    extends RuleExpressionVisitor<List<ResolvedExpression>> {
        @Nullable
        private TypeInferenceUtil.SurroundingInfo surroundingInfo;

        ResolvingCallVisitor(ResolverRule.ResolutionContext context, @Nullable TypeInferenceUtil.SurroundingInfo surroundingInfo) {
            super(context);
            this.surroundingInfo = surroundingInfo;
        }

        @Override
        public List<ResolvedExpression> visit(UnresolvedCallExpression unresolvedCall) {
            FunctionDefinition definition = !unresolvedCall.getFunctionIdentifier().isPresent() ? this.prepareInlineUserDefinedFunction(unresolvedCall.getFunctionDefinition()) : unresolvedCall.getFunctionDefinition();
            String name = unresolvedCall.getFunctionIdentifier().map(FunctionIdentifier::toString).orElseGet(definition::toString);
            Optional<TypeInference> typeInference = this.getOptionalTypeInference(definition);
            ArrayList<ResolvedExpression> resolvedArgs = new ArrayList<ResolvedExpression>();
            int argCount = unresolvedCall.getChildren().size();
            for (int i = 0; i < argCount; ++i) {
                int currentPos = i;
                ResolvingCallVisitor childResolver = new ResolvingCallVisitor(this.resolutionContext, typeInference.map(inference -> new TypeInferenceUtil.SurroundingInfo(name, definition, (TypeInference)inference, argCount, currentPos)).orElse(null));
                resolvedArgs.addAll((Collection<ResolvedExpression>)unresolvedCall.getChildren().get(i).accept(childResolver));
            }
            if (definition == BuiltInFunctionDefinitions.FLATTEN) {
                return this.executeFlatten(resolvedArgs);
            }
            return Collections.singletonList(typeInference.map(newInference -> this.runTypeInference(name, unresolvedCall, (TypeInference)newInference, (List<ResolvedExpression>)resolvedArgs, this.surroundingInfo)).orElseGet(() -> this.runLegacyTypeInference(unresolvedCall, resolvedArgs)));
        }

        @Override
        protected List<ResolvedExpression> defaultMethod(Expression expression2) {
            if (expression2 instanceof ResolvedExpression) {
                return Collections.singletonList((ResolvedExpression)expression2);
            }
            throw new TableException("Unexpected unresolved expression: " + expression2);
        }

        private List<ResolvedExpression> executeFlatten(List<ResolvedExpression> args) {
            if (args.size() != 1) {
                throw new ValidationException("Invalid number of arguments for flattening.");
            }
            ResolvedExpression composite2 = args.get(0);
            TypeInformation<?> resultType2 = TypeConversions.fromDataTypeToLegacyInfo(composite2.getOutputDataType());
            if (resultType2 instanceof CompositeType) {
                return this.flattenCompositeType(composite2, (CompositeType)resultType2);
            }
            return Collections.singletonList(composite2);
        }

        private List<ResolvedExpression> flattenCompositeType(ResolvedExpression composite2, CompositeType<?> resultType2) {
            return IntStream.range(0, resultType2.getArity()).mapToObj(idx -> this.resolutionContext.postResolutionFactory().get(composite2, ApiExpressionUtils.valueLiteral(resultType2.getFieldNames()[idx]), TypeConversions.fromLegacyInfoToDataType(resultType2.getTypeAt(idx)))).collect(Collectors.toList());
        }

        private Optional<TypeInference> getOptionalTypeInference(FunctionDefinition definition) {
            if (definition instanceof ScalarFunctionDefinition || definition instanceof TableFunctionDefinition || definition instanceof AggregateFunctionDefinition || definition instanceof TableAggregateFunctionDefinition) {
                return Optional.empty();
            }
            TypeInference inference = definition.getTypeInference(this.resolutionContext.typeFactory());
            if (inference.getOutputTypeStrategy() != TypeStrategies.MISSING) {
                return Optional.of(inference);
            }
            return Optional.empty();
        }

        private ResolvedExpression runTypeInference(String name, UnresolvedCallExpression unresolvedCall, TypeInference inference, List<ResolvedExpression> resolvedArgs, @Nullable TypeInferenceUtil.SurroundingInfo surroundingInfo) {
            TypeInferenceUtil.Result inferenceResult = TypeInferenceUtil.runTypeInference(inference, new TableApiCallContext(this.resolutionContext.typeFactory(), name, unresolvedCall.getFunctionDefinition(), resolvedArgs), surroundingInfo);
            List<ResolvedExpression> adaptedArguments = this.adaptArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private ResolvedExpression runLegacyTypeInference(UnresolvedCallExpression unresolvedCall, List<ResolvedExpression> resolvedArgs) {
            PlannerTypeInferenceUtil util = this.resolutionContext.functionLookup().getPlannerTypeInferenceUtil();
            TypeInferenceUtil.Result inferenceResult = util.runTypeInference(unresolvedCall, resolvedArgs);
            List<ResolvedExpression> adaptedArguments = this.adaptArguments(inferenceResult, resolvedArgs);
            return unresolvedCall.resolve(adaptedArguments, inferenceResult.getOutputDataType());
        }

        private List<ResolvedExpression> adaptArguments(TypeInferenceUtil.Result inferenceResult, List<ResolvedExpression> resolvedArgs) {
            return IntStream.range(0, resolvedArgs.size()).mapToObj(pos -> {
                ResolvedExpression argument = (ResolvedExpression)resolvedArgs.get(pos);
                DataType argumentType = argument.getOutputDataType();
                DataType expectedType = inferenceResult.getExpectedArgumentTypes().get(pos);
                if (!LogicalTypeCasts.supportsAvoidingCast(argumentType.getLogicalType(), expectedType.getLogicalType())) {
                    return this.resolutionContext.postResolutionFactory().cast(argument, expectedType);
                }
                return argument;
            }).collect(Collectors.toList());
        }

        private FunctionDefinition prepareInlineUserDefinedFunction(FunctionDefinition definition) {
            if (definition instanceof ScalarFunctionDefinition) {
                ScalarFunctionDefinition sf = (ScalarFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), sf.getScalarFunction());
                return new ScalarFunctionDefinition(sf.getName(), sf.getScalarFunction());
            }
            if (definition instanceof TableFunctionDefinition) {
                TableFunctionDefinition tf = (TableFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), tf.getTableFunction());
                return new TableFunctionDefinition(tf.getName(), tf.getTableFunction(), tf.getResultType());
            }
            if (definition instanceof AggregateFunctionDefinition) {
                AggregateFunctionDefinition af = (AggregateFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), af.getAggregateFunction());
                return new AggregateFunctionDefinition(af.getName(), af.getAggregateFunction(), af.getResultTypeInfo(), af.getAccumulatorTypeInfo());
            }
            if (definition instanceof TableAggregateFunctionDefinition) {
                TableAggregateFunctionDefinition taf = (TableAggregateFunctionDefinition)definition;
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), taf.getTableAggregateFunction());
                return new TableAggregateFunctionDefinition(taf.getName(), taf.getTableAggregateFunction(), taf.getResultTypeInfo(), taf.getAccumulatorTypeInfo());
            }
            if (definition instanceof UserDefinedFunction) {
                UserDefinedFunctionHelper.prepareInstance(this.resolutionContext.configuration(), (UserDefinedFunction)definition);
            }
            return definition;
        }
    }
}

