/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.util.Preconditions;

@Internal
final class ExpandColumnFunctionsRule
implements ResolverRule {
    ExpandColumnFunctionsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression2, ResolverRule.ResolutionContext context) {
        ColumnFunctionsExpander columnFunctionsExpander = new ColumnFunctionsExpander(context.referenceLookup().getAllInputFields().stream().map(p -> ApiExpressionUtils.unresolvedRef(p.getName())).collect(Collectors.toList()));
        return expression2.stream().flatMap(expr -> expr.accept(columnFunctionsExpander).stream()).collect(Collectors.toList());
    }

    private static int indexOfName(List<UnresolvedReferenceExpression> inputFieldReferences, String targetName) {
        int i;
        for (i = 0; i < inputFieldReferences.size() && !inputFieldReferences.get(i).getName().equals(targetName); ++i) {
        }
        return i == inputFieldReferences.size() ? -1 : i;
    }

    private static class ColumnsExpressionExpander
    extends ApiExpressionDefaultVisitor<List<UnresolvedReferenceExpression>> {
        private final List<UnresolvedReferenceExpression> inputFieldReferences;

        public ColumnsExpressionExpander(List<UnresolvedReferenceExpression> inputFieldReferences) {
            this.inputFieldReferences = inputFieldReferences;
        }

        @Override
        public List<UnresolvedReferenceExpression> visit(ValueLiteralExpression valueLiteral) {
            return ExpressionUtils.extractValue(valueLiteral, Integer.class).map(i -> Collections.singletonList(this.inputFieldReferences.get(i - 1))).orElseGet(() -> this.defaultMethod(valueLiteral));
        }

        @Override
        public List<UnresolvedReferenceExpression> visit(UnresolvedReferenceExpression unresolvedReference) {
            if (unresolvedReference.getName().equals("*")) {
                return this.inputFieldReferences;
            }
            return Collections.singletonList(unresolvedReference);
        }

        @Override
        public List<UnresolvedReferenceExpression> visit(UnresolvedCallExpression unresolvedCall) {
            if (this.isIndexRangeCall(unresolvedCall)) {
                int end;
                int start = ExpressionUtils.extractValue(unresolvedCall.getChildren().get(0), Integer.class).orElseThrow(() -> new ValidationException("Constant integer value expected."));
                Preconditions.checkArgument((start <= (end = ExpressionUtils.extractValue(unresolvedCall.getChildren().get(1), Integer.class).orElseThrow(() -> new ValidationException("Constant integer value expected.")).intValue()) ? 1 : 0) != 0, (Object)String.format("The start:%s of %s() or %s() should not bigger than end:%s.", start, BuiltInFunctionDefinitions.WITH_COLUMNS.getName(), BuiltInFunctionDefinitions.WITHOUT_COLUMNS.getName(), end));
                return this.inputFieldReferences.subList(start - 1, end);
            }
            if (this.isNameRangeCall(unresolvedCall)) {
                int end;
                String startName = ((UnresolvedReferenceExpression)unresolvedCall.getChildren().get(0)).getName();
                String endName = ((UnresolvedReferenceExpression)unresolvedCall.getChildren().get(1)).getName();
                int start = ExpandColumnFunctionsRule.indexOfName(this.inputFieldReferences, startName);
                Preconditions.checkArgument((start <= (end = ExpandColumnFunctionsRule.indexOfName(this.inputFieldReferences, endName)) ? 1 : 0) != 0, (Object)String.format("The start name:%s of %s() or %s() should not behind the end:%s.", startName, BuiltInFunctionDefinitions.WITH_COLUMNS.getName(), BuiltInFunctionDefinitions.WITHOUT_COLUMNS.getName(), endName));
                return this.inputFieldReferences.subList(start, end + 1);
            }
            return this.defaultMethod(unresolvedCall);
        }

        @Override
        protected List<UnresolvedReferenceExpression> defaultMethod(Expression expression2) {
            throw new ValidationException(String.format("The parameters of %s() or %s() only accept column names or column indices.", BuiltInFunctionDefinitions.WITH_COLUMNS.getName(), BuiltInFunctionDefinitions.WITHOUT_COLUMNS.getName()));
        }

        private boolean isIndexRangeCall(UnresolvedCallExpression expression2) {
            return expression2.getFunctionDefinition() == BuiltInFunctionDefinitions.RANGE_TO && expression2.getChildren().get(0) instanceof ValueLiteralExpression && expression2.getChildren().get(1) instanceof ValueLiteralExpression;
        }

        private boolean isNameRangeCall(UnresolvedCallExpression expression2) {
            return expression2.getFunctionDefinition() == BuiltInFunctionDefinitions.RANGE_TO && expression2.getChildren().get(0) instanceof UnresolvedReferenceExpression && expression2.getChildren().get(1) instanceof UnresolvedReferenceExpression;
        }
    }

    private static class ColumnFunctionsExpander
    extends ApiExpressionDefaultVisitor<List<Expression>> {
        private final List<UnresolvedReferenceExpression> inputFieldReferences;
        private final ColumnsExpressionExpander columnsExpressionExpander;

        public ColumnFunctionsExpander(List<UnresolvedReferenceExpression> inputFieldReferences) {
            this.inputFieldReferences = inputFieldReferences;
            this.columnsExpressionExpander = new ColumnsExpressionExpander(inputFieldReferences);
        }

        @Override
        public List<Expression> visit(UnresolvedCallExpression unresolvedCall) {
            List<Expression> result;
            FunctionDefinition definition = unresolvedCall.getFunctionDefinition();
            if (definition == BuiltInFunctionDefinitions.WITH_COLUMNS) {
                result = this.resolveArgsOfColumns(unresolvedCall.getChildren(), false);
            } else if (definition == BuiltInFunctionDefinitions.WITHOUT_COLUMNS) {
                result = this.resolveArgsOfColumns(unresolvedCall.getChildren(), true);
            } else {
                List<Expression> args = unresolvedCall.getChildren().stream().flatMap(c -> c.accept(this).stream()).collect(Collectors.toList());
                result = Collections.singletonList(unresolvedCall.replaceArgs(args));
                if (definition == BuiltInFunctionDefinitions.AS) {
                    for (int i = 1; i < args.size(); ++i) {
                        if (args.get(i) instanceof ValueLiteralExpression) continue;
                        String errorMessage = args.stream().map(Object::toString).collect(Collectors.joining(", "));
                        throw new ValidationException(String.format("Invalid AS, parameters are: [%s].", errorMessage));
                    }
                }
            }
            return result;
        }

        @Override
        protected List<Expression> defaultMethod(Expression expression2) {
            return Collections.singletonList(expression2);
        }

        private List<Expression> resolveArgsOfColumns(List<Expression> args, boolean isReverseProjection) {
            LinkedList<Expression> finalResult = new LinkedList<Expression>();
            List result = args.stream().flatMap(e -> e.accept(this.columnsExpressionExpander).stream()).collect(Collectors.toList());
            if (isReverseProjection) {
                for (UnresolvedReferenceExpression field : this.inputFieldReferences) {
                    if (ExpandColumnFunctionsRule.indexOfName(result, field.getName()) != -1) continue;
                    finalResult.add(field);
                }
            } else {
                finalResult.addAll(result);
            }
            return finalResult;
        }
    }
}

