/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.QueryOperationCatalogViewTable;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.plan.schema.TableSinkTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;

class DatabaseCalciteSchema
implements Schema {
    private final boolean isStreamingMode;
    private final String catalogName;
    private final String databaseName;
    private final CatalogManager catalogManager;
    private final TableConfig tableConfig;

    public DatabaseCalciteSchema(boolean isStreamingMode, String databaseName, String catalogName, CatalogManager catalogManager, TableConfig tableConfig) {
        this.isStreamingMode = isStreamingMode;
        this.databaseName = databaseName;
        this.catalogName = catalogName;
        this.catalogManager = catalogManager;
        this.tableConfig = tableConfig;
    }

    @Override
    public Table getTable(String tableName) {
        ObjectIdentifier identifier = ObjectIdentifier.of(this.catalogName, this.databaseName, tableName);
        return this.catalogManager.getTable(identifier).map(result -> {
            TableFactory tableFactory = result.isTemporary() ? null : (TableFactory)this.catalogManager.getCatalog(this.catalogName).flatMap(Catalog::getTableFactory).orElse(null);
            return this.convertTable(identifier, (CatalogManager.TableLookupResult)result, tableFactory);
        }).orElse(null);
    }

    private Table convertTable(ObjectIdentifier identifier, CatalogManager.TableLookupResult lookupResult, @Nullable TableFactory tableFactory) {
        CatalogBaseTable table = lookupResult.getTable();
        TableSchema resolvedSchema = lookupResult.getResolvedSchema();
        if (table instanceof QueryOperationCatalogView) {
            return QueryOperationCatalogViewTable.createCalciteTable((QueryOperationCatalogView)table, resolvedSchema);
        }
        if (table instanceof ConnectorCatalogTable) {
            return this.convertConnectorTable((ConnectorCatalogTable)table, resolvedSchema);
        }
        if (table instanceof CatalogTable) {
            return this.convertCatalogTable(identifier, (CatalogTable)table, resolvedSchema, tableFactory, lookupResult.isTemporary());
        }
        if (table instanceof CatalogView) {
            return this.convertCatalogView(identifier.getObjectName(), (CatalogView)table, resolvedSchema);
        }
        throw new TableException("Unsupported table type: " + table);
    }

    private Table convertConnectorTable(ConnectorCatalogTable<?, ?> table, TableSchema resolvedSchema) {
        Optional<TableSourceTable> tableSourceTable = table.getTableSource().map(tableSource -> new TableSourceTable(resolvedSchema, tableSource, !table.isBatch(), FlinkStatistic.UNKNOWN()));
        if (tableSourceTable.isPresent()) {
            return tableSourceTable.get();
        }
        Optional<TableSinkTable> tableSinkTable = table.getTableSink().map(tableSink -> new TableSinkTable(tableSink, FlinkStatistic.UNKNOWN()));
        if (tableSinkTable.isPresent()) {
            return tableSinkTable.get();
        }
        throw new TableException("Cannot convert a connector table without either source or sink.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Table convertCatalogTable(ObjectIdentifier identifier, CatalogTable table, TableSchema resolvedSchema, @Nullable TableFactory tableFactory, boolean isTemporary) {
        TableSource tableSource;
        TableSourceFactoryContextImpl context = new TableSourceFactoryContextImpl(identifier, table, (ReadableConfig)this.tableConfig.getConfiguration(), isTemporary);
        if (tableFactory != null) {
            if (!(tableFactory instanceof TableSourceFactory)) throw new TableException("Cannot query a sink-only table. TableFactory provided by catalog must implement TableSourceFactory");
            tableSource = ((TableSourceFactory)tableFactory).createTableSource(context);
        } else {
            tableSource = TableFactoryUtil.findAndCreateTableSource(context);
        }
        if (tableSource instanceof StreamTableSource) return new TableSourceTable(resolvedSchema, tableSource, this.isStreamingMode, FlinkStatistic.UNKNOWN());
        throw new TableException("Catalog tables support only StreamTableSource and InputFormatTableSource");
    }

    private Table convertCatalogView(String tableName, CatalogView table, TableSchema resolvedSchema) {
        return new ViewTable(null, typeFactory -> ((FlinkTypeFactory)typeFactory).buildLogicalRowType(resolvedSchema), table.getExpandedQuery(), Arrays.asList(this.catalogName, this.databaseName), Arrays.asList(this.catalogName, this.databaseName, tableName));
    }

    @Override
    public Set<String> getTableNames() {
        return this.catalogManager.listTables(this.catalogName, this.databaseName);
    }

    @Override
    public RelProtoDataType getType(String name) {
        return null;
    }

    @Override
    public Set<String> getTypeNames() {
        return new HashSet<String>();
    }

    @Override
    public Collection<Function> getFunctions(String s) {
        return new HashSet<Function>();
    }

    @Override
    public Set<String> getFunctionNames() {
        return new HashSet<String>();
    }

    @Override
    public Schema getSubSchema(String s) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }
}

