/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputStreamFSInputWrapper;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.compression.StandardDeCompressors;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connector.file.src.util.IteratorResultIterator;
import org.apache.flink.connector.file.src.util.Utils;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public final class StreamFormatAdapter<T>
implements BulkFormat<T, FileSourceSplit> {
    private static final long serialVersionUID = 1L;
    private final StreamFormat<T> streamFormat;

    public StreamFormatAdapter(StreamFormat<T> streamFormat) {
        this.streamFormat = (StreamFormat)Preconditions.checkNotNull(streamFormat);
    }

    @Override
    public BulkFormat.Reader<T> createReader(Configuration config, FileSourceSplit split2) throws IOException {
        TrackingFsDataInputStream trackingStream = StreamFormatAdapter.openStream(split2.path(), config, split2.offset());
        long splitEnd = split2.offset() + split2.length();
        return (BulkFormat.Reader)Utils.doWithCleanupOnException((Closeable)((Object)trackingStream), () -> {
            StreamFormat.Reader<T> streamReader = this.streamFormat.createReader(config, trackingStream, trackingStream.getFileLength(), splitEnd);
            return new Reader<T>(streamReader, trackingStream, -1L, 0L);
        });
    }

    @Override
    public BulkFormat.Reader<T> restoreReader(Configuration config, FileSourceSplit split2) throws IOException {
        assert (split2.getReaderPosition().isPresent());
        CheckpointedPosition checkpointedPosition = split2.getReaderPosition().get();
        TrackingFsDataInputStream trackingStream = StreamFormatAdapter.openStream(split2.path(), config, split2.offset());
        long splitEnd = split2.offset() + split2.length();
        return (BulkFormat.Reader)Utils.doWithCleanupOnException((Closeable)((Object)trackingStream), () -> {
            StreamFormat.Reader streamReader = checkpointedPosition.getOffset() == -1L ? this.streamFormat.createReader(config, trackingStream, trackingStream.getFileLength(), splitEnd) : this.streamFormat.restoreReader(config, trackingStream, checkpointedPosition.getOffset(), trackingStream.getFileLength(), splitEnd);
            Utils.doWithCleanupOnException(streamReader, (ThrowingRunnable<IOException>)((ThrowingRunnable)() -> {
                for (long toSkip = checkpointedPosition.getRecordsAfterOffset(); toSkip > 0L && streamReader.read() != null; --toSkip) {
                }
            }));
            return new Reader<T>(streamReader, trackingStream, checkpointedPosition.getOffset(), checkpointedPosition.getRecordsAfterOffset());
        });
    }

    @Override
    public boolean isSplittable() {
        return this.streamFormat.isSplittable();
    }

    @Override
    public TypeInformation<T> getProducedType() {
        return this.streamFormat.getProducedType();
    }

    private static TrackingFsDataInputStream openStream(Path file, Configuration config, long seekPosition) throws IOException {
        FileSystem fs = file.getFileSystem();
        long fileLength = fs.getFileStatus(file).getLen();
        int fetchSize = MathUtils.checkedDownCast((long)((MemorySize)config.get(StreamFormat.FETCH_IO_SIZE)).getBytes());
        if (fetchSize <= 0) {
            throw new IllegalConfigurationException(String.format("The fetch size (%s) must be > 0, but is %d", StreamFormat.FETCH_IO_SIZE.key(), fetchSize));
        }
        InflaterInputStreamFactory<?> deCompressor = StandardDeCompressors.getDecompressorForFileName(file.getPath());
        FSDataInputStream inStream = fs.open(file);
        return (TrackingFsDataInputStream)((Object)Utils.doWithCleanupOnException((Closeable)inStream, () -> {
            FSDataInputStream in = deCompressor == null ? inStream : new InputStreamFSInputWrapper(deCompressor.create((InputStream)inStream));
            in.seek(seekPosition);
            return new TrackingFsDataInputStream(in, fileLength, fetchSize);
        }));
    }

    private static final class TrackingFsDataInputStream
    extends FSDataInputStream {
        private final FSDataInputStream stream;
        private final long fileLength;
        private final int batchSize;
        private int remainingInBatch;

        TrackingFsDataInputStream(FSDataInputStream stream, long fileLength, int batchSize) {
            Preconditions.checkArgument((fileLength > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0);
            this.stream = stream;
            this.fileLength = fileLength;
            this.batchSize = batchSize;
        }

        public void seek(long desired) throws IOException {
            this.stream.seek(desired);
            this.remainingInBatch = 0;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public int read() throws IOException {
            --this.remainingInBatch;
            return this.stream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.remainingInBatch -= len;
            return this.stream.read(b, off, len);
        }

        public void close() throws IOException {
            this.stream.close();
        }

        boolean hasRemainingInBatch() {
            return this.remainingInBatch > 0;
        }

        void newBatch() {
            this.remainingInBatch = this.batchSize;
        }

        long getFileLength() {
            return this.fileLength;
        }
    }

    public static final class Reader<T>
    implements BulkFormat.Reader<T> {
        private final StreamFormat.Reader<T> reader;
        private final TrackingFsDataInputStream stream;
        private long lastOffset;
        private long lastRecordsAfterOffset;

        Reader(StreamFormat.Reader<T> reader, TrackingFsDataInputStream stream, long initialOffset, long initialSkipCount) {
            this.reader = (StreamFormat.Reader)Preconditions.checkNotNull(reader);
            this.stream = (TrackingFsDataInputStream)((Object)Preconditions.checkNotNull((Object)((Object)stream)));
            this.lastOffset = initialOffset;
            this.lastRecordsAfterOffset = initialSkipCount;
        }

        @Override
        @Nullable
        public BulkFormat.RecordIterator<T> readBatch() throws IOException {
            T next;
            this.updateCheckpointedPosition();
            this.stream.newBatch();
            ArrayList<T> result = new ArrayList<T>();
            while (this.stream.hasRemainingInBatch() && (next = this.reader.read()) != null) {
                result.add(next);
            }
            if (result.isEmpty()) {
                return null;
            }
            IteratorResultIterator iter = new IteratorResultIterator(result.iterator(), this.lastOffset, this.lastRecordsAfterOffset);
            this.lastRecordsAfterOffset += (long)result.size();
            return iter;
        }

        @Override
        public void close() throws IOException {
            try {
                this.reader.close();
            }
            finally {
                IOUtils.closeQuietly((AutoCloseable)((Object)this.stream));
            }
        }

        private void updateCheckpointedPosition() {
            CheckpointedPosition position = this.reader.getCheckpointedPosition();
            if (position != null) {
                this.lastOffset = position.getOffset();
                this.lastRecordsAfterOffset = position.getRecordsAfterOffset();
            }
        }
    }
}

