/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config.entries;

import java.util.List;
import org.apache.flink.table.client.config.entries.TableEntry;
import org.apache.flink.table.descriptors.DescriptorProperties;

public class TemporalTableEntry
extends TableEntry {
    private static final String TABLES_HISTORY_TABLE = "history-table";
    private static final String TABLES_PRIMARY_KEY = "primary-key";
    private static final String TABLES_TIME_ATTRIBUTE = "time-attribute";
    private final String historyTable;
    private final List<String> primaryKeyFields;
    private final String timeAttribute;

    TemporalTableEntry(String name, DescriptorProperties properties) {
        super(name, properties);
        this.historyTable = properties.getString(TABLES_HISTORY_TABLE);
        this.primaryKeyFields = properties.getArray(TABLES_PRIMARY_KEY, arg_0 -> ((DescriptorProperties)properties).getString(arg_0));
        this.timeAttribute = properties.getString(TABLES_TIME_ATTRIBUTE);
    }

    public String getHistoryTable() {
        return this.historyTable;
    }

    public List<String> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public String getTimeAttribute() {
        return this.timeAttribute;
    }

    @Override
    protected void validate(DescriptorProperties properties) {
        properties.validateString(TABLES_HISTORY_TABLE, false, 1);
        properties.validateArray(TABLES_PRIMARY_KEY, key -> properties.validateString(key, false, 1), 1, 1);
        properties.validateString(TABLES_TIME_ATTRIBUTE, false, 1);
    }
}

