/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config.entries;

import java.util.Arrays;
import java.util.Map;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.entries.ConfigEntry;
import org.apache.flink.table.client.config.entries.SinkTableEntry;
import org.apache.flink.table.client.config.entries.SourceSinkTableEntry;
import org.apache.flink.table.client.config.entries.SourceTableEntry;
import org.apache.flink.table.client.config.entries.TemporalTableEntry;
import org.apache.flink.table.client.config.entries.ViewEntry;
import org.apache.flink.table.descriptors.DescriptorProperties;

public abstract class TableEntry
extends ConfigEntry {
    public static final String TABLES_NAME = "name";
    private static final String TABLES_TYPE = "type";
    @Deprecated
    private static final String TABLES_TYPE_VALUE_SOURCE = "source";
    @Deprecated
    private static final String TABLES_TYPE_VALUE_SINK = "sink";
    @Deprecated
    private static final String TABLES_TYPE_VALUE_BOTH = "both";
    private static final String TABLES_TYPE_VALUE_SOURCE_TABLE = "source-table";
    private static final String TABLES_TYPE_VALUE_SINK_TABLE = "sink-table";
    private static final String TABLES_TYPE_VALUE_SOURCE_SINK_TABLE = "source-sink-table";
    private static final String TABLES_TYPE_VALUE_VIEW = "view";
    private static final String TABLES_TYPE_VALUE_TEMPORAL_TABLE = "temporal-table";
    private final String name;

    protected TableEntry(String name, DescriptorProperties properties) {
        super(properties);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static TableEntry create(Map<String, Object> config) {
        return TableEntry.create(ConfigUtil.normalizeYaml(config));
    }

    private static TableEntry create(DescriptorProperties properties) {
        properties.validateString(TABLES_NAME, false, 1);
        properties.validateEnumValues(TABLES_TYPE, false, Arrays.asList(TABLES_TYPE_VALUE_SOURCE, TABLES_TYPE_VALUE_SOURCE_TABLE, TABLES_TYPE_VALUE_SINK, TABLES_TYPE_VALUE_SINK_TABLE, TABLES_TYPE_VALUE_BOTH, TABLES_TYPE_VALUE_SOURCE_SINK_TABLE, TABLES_TYPE_VALUE_VIEW, TABLES_TYPE_VALUE_TEMPORAL_TABLE));
        String name = properties.getString(TABLES_NAME);
        DescriptorProperties cleanedProperties = properties.withoutKeys(Arrays.asList(TABLES_NAME, TABLES_TYPE));
        switch (properties.getString(TABLES_TYPE)) {
            case "source": 
            case "source-table": {
                return new SourceTableEntry(name, cleanedProperties);
            }
            case "sink": 
            case "sink-table": {
                return new SinkTableEntry(name, cleanedProperties);
            }
            case "both": 
            case "source-sink-table": {
                return new SourceSinkTableEntry(name, cleanedProperties);
            }
            case "view": {
                return new ViewEntry(name, cleanedProperties);
            }
            case "temporal-table": {
                return new TemporalTableEntry(name, cleanedProperties);
            }
        }
        throw new SqlClientException("Unexpected table type.");
    }
}

