/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.client.cli.SqlCommandParser;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCompleter
implements Completer {
    private static final Logger LOG = LoggerFactory.getLogger(SqlCompleter.class);
    public static final String[] COMMAND_HINTS = SqlCompleter.getCommandHints();
    private String sessionId;
    private Executor executor;

    public SqlCompleter(String sessionId, Executor executor) {
        this.sessionId = sessionId;
        this.executor = executor;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        String statement = line.line();
        if (statement.endsWith(";")) {
            statement = statement.substring(0, statement.length() - 1);
        }
        String statementNormalized = statement.toUpperCase().trim();
        for (String commandHint : COMMAND_HINTS) {
            if (!commandHint.startsWith(statementNormalized) || line.cursor() >= commandHint.length()) continue;
            candidates.add(this.createCandidate(this.getCompletionHint(statementNormalized, commandHint)));
        }
        try {
            this.executor.completeStatement(this.sessionId, statement, line.cursor()).forEach(hint -> candidates.add(this.createCandidate((String)hint)));
        }
        catch (SqlExecutionException e) {
            LOG.debug("Could not complete statement at " + line.cursor() + ":" + statement, (Throwable)e);
        }
    }

    private String getCompletionHint(String statementNormalized, String commandHint) {
        int returnStartPos;
        if (statementNormalized.length() == 0) {
            return commandHint;
        }
        int cursorPos = statementNormalized.length() - 1;
        if (Character.isWhitespace(commandHint.charAt(cursorPos + 1))) {
            returnStartPos = Math.min(commandHint.length() - 1, cursorPos + 2);
        } else {
            for (returnStartPos = cursorPos; returnStartPos > 0 && !Character.isWhitespace(commandHint.charAt(returnStartPos - 1)); --returnStartPos) {
            }
        }
        return commandHint.substring(returnStartPos);
    }

    private Candidate createCandidate(String hint) {
        return new Candidate(AttributedString.stripAnsi(hint), hint, null, null, null, null, true);
    }

    private static String[] getCommandHints() {
        return (String[])Arrays.stream(SqlCommandParser.SqlCommand.values()).filter(SqlCommandParser.SqlCommand::hasRegexPattern).map(cmd -> {
            if (cmd.hasOperands()) {
                return cmd.toString();
            }
            return cmd.toString() + ";";
        }).toArray(String[]::new);
    }
}

