/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.tsextractors.TimestampExtractorUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.table.utils.TypeMappingUtils;

@Internal
public class TableSourceValidation {
    public static void validateTableSource(TableSource<?> tableSource, TableSchema schema) {
        List<RowtimeAttributeDescriptor> rowtimeAttributes = TableSourceValidation.getRowtimeAttributes(tableSource);
        Optional<String> proctimeAttribute = TableSourceValidation.getProctimeAttribute(tableSource);
        TableSourceValidation.validateNoGeneratedColumns(schema);
        TableSourceValidation.validateSingleRowtimeAttribute(rowtimeAttributes);
        TableSourceValidation.validateRowtimeAttributesExistInSchema(rowtimeAttributes, schema);
        TableSourceValidation.validateProctimeAttributesExistInSchema(proctimeAttribute, schema);
        TableSourceValidation.validateLogicalToPhysicalMapping(tableSource, schema);
        TableSourceValidation.validateTimestampExtractorArguments(rowtimeAttributes, tableSource);
        TableSourceValidation.validateNotOverlapping(rowtimeAttributes, proctimeAttribute);
    }

    public static boolean hasRowtimeAttribute(TableSource<?> tableSource) {
        return !TableSourceValidation.getRowtimeAttributes(tableSource).isEmpty();
    }

    public static boolean hasProctimeAttribute(TableSource<?> tableSource) {
        return TableSourceValidation.getProctimeAttribute(tableSource).isPresent();
    }

    private static void validateSingleRowtimeAttribute(List<RowtimeAttributeDescriptor> rowtimeAttributes) {
        if (rowtimeAttributes.size() > 1) {
            throw new ValidationException("Currently, only a single rowtime attribute is supported. Please remove all but one RowtimeAttributeDescriptor.");
        }
    }

    private static void validateRowtimeAttributesExistInSchema(List<RowtimeAttributeDescriptor> rowtimeAttributes, TableSchema tableSchema) {
        rowtimeAttributes.forEach(r -> {
            if (!tableSchema.getFieldDataType(r.getAttributeName()).isPresent()) {
                throw new ValidationException(String.format("Found a rowtime attribute for field '%s' but it does not exist in the Table. TableSchema: %s", r.getAttributeName(), tableSchema));
            }
        });
    }

    private static void validateProctimeAttributesExistInSchema(Optional<String> proctimeAttribute, TableSchema tableSchema) {
        proctimeAttribute.ifPresent(r -> {
            if (!tableSchema.getFieldDataType((String)r).isPresent()) {
                throw new ValidationException(String.format("Found a proctime attribute for field '%s' but it does not exist in the Table. TableSchema: %s", r, tableSchema));
            }
        });
    }

    private static void validateNotOverlapping(List<RowtimeAttributeDescriptor> rowtimeAttributes, Optional<String> proctimeAttribute) {
        proctimeAttribute.ifPresent(proctime -> {
            if (rowtimeAttributes.stream().anyMatch(rowtimeAttribute -> rowtimeAttribute.getAttributeName().equals(proctime))) {
                throw new ValidationException(String.format("Field '%s' must not be processing time and rowtime attribute at the same time.", proctime));
            }
        });
    }

    private static void validateLogicalToPhysicalMapping(TableSource<?> tableSource, TableSchema schema) {
        Function<String, String> fieldMapping = TableSourceValidation.getNameMappingFunction(tableSource);
        TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers(tableSource, schema.getTableColumns(), true, fieldMapping);
    }

    private static Function<String, String> getNameMappingFunction(TableSource<?> tableSource) {
        Map<String, String> fieldsMap;
        Function<String, String> fieldMapping = tableSource instanceof DefinedFieldMapping && ((DefinedFieldMapping)((Object)tableSource)).getFieldMapping() != null ? ((fieldsMap = ((DefinedFieldMapping)((Object)tableSource)).getFieldMapping()) != null ? fieldsMap::get : Function.identity()) : Function.identity();
        return fieldMapping;
    }

    private static void validateTimestampExtractorArguments(List<RowtimeAttributeDescriptor> descriptors, TableSource<?> tableSource) {
        if (descriptors.size() == 1) {
            TimestampExtractor extractor = descriptors.get(0).getTimestampExtractor();
            TypeInformation[] types = (TypeInformation[])Arrays.stream(TimestampExtractorUtils.getAccessedFields(extractor, tableSource.getProducedDataType(), TableSourceValidation.getNameMappingFunction(tableSource))).map(ResolvedFieldReference::resultType).toArray(TypeInformation[]::new);
            extractor.validateArgumentFields(types);
        }
    }

    private static void validateNoGeneratedColumns(TableSchema tableSchema) {
        if (TableSchemaUtils.containsGeneratedColumns(tableSchema)) {
            throw new ValidationException("TableSource#getTableSchema shouldn't contain generated columns, schema: \n" + tableSchema);
        }
    }

    private static List<RowtimeAttributeDescriptor> getRowtimeAttributes(TableSource<?> tableSource) {
        if (tableSource instanceof DefinedRowtimeAttributes) {
            return ((DefinedRowtimeAttributes)((Object)tableSource)).getRowtimeAttributeDescriptors();
        }
        return Collections.emptyList();
    }

    private static Optional<String> getProctimeAttribute(TableSource<?> tableSource) {
        if (tableSource instanceof DefinedProctimeAttribute) {
            return Optional.ofNullable(((DefinedProctimeAttribute)((Object)tableSource)).getProctimeAttribute());
        }
        return Optional.empty();
    }

    private TableSourceValidation() {
    }
}

