/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public final class WrapperTypeInfo<T>
extends TypeInformation<T> {
    private static final String FORMAT = "%s(%s, %s)";
    private final Class<T> typeClass;
    private final TypeSerializer<T> typeSerializer;

    public WrapperTypeInfo(Class<T> typeClass, TypeSerializer<T> typeSerializer) {
        this.typeClass = (Class)Preconditions.checkNotNull(typeClass);
        this.typeSerializer = (TypeSerializer)Preconditions.checkNotNull(typeSerializer);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return this.typeSerializer;
    }

    public String toString() {
        return String.format(FORMAT, ((Object)((Object)this)).getClass().getSimpleName(), this.typeClass.getName(), this.typeSerializer.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WrapperTypeInfo that = (WrapperTypeInfo)((Object)o);
        return this.typeClass.equals(that.typeClass) && this.typeSerializer.equals(that.typeSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.typeClass, this.typeSerializer);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof WrapperTypeInfo;
    }
}

