/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.ColumnarArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class ArrayDataSerializer
extends TypeSerializer<ArrayData> {
    private static final long serialVersionUID = 1L;
    private final LogicalType eleType;
    private final TypeSerializer<Object> eleSer;
    private transient BinaryArrayData reuseArray;
    private transient BinaryArrayWriter reuseWriter;

    public ArrayDataSerializer(LogicalType eleType, ExecutionConfig conf) {
        this.eleType = eleType;
        this.eleSer = InternalSerializers.create(eleType, conf);
    }

    private ArrayDataSerializer(LogicalType eleType, TypeSerializer<Object> eleSer) {
        this.eleType = eleType;
        this.eleSer = eleSer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<ArrayData> duplicate() {
        return new ArrayDataSerializer(this.eleType, (TypeSerializer<Object>)this.eleSer.duplicate());
    }

    public ArrayData createInstance() {
        return new BinaryArrayData();
    }

    public ArrayData copy(ArrayData from) {
        if (from instanceof GenericArrayData) {
            return this.copyGenericArray((GenericArrayData)from);
        }
        if (from instanceof BinaryArrayData) {
            return ((BinaryArrayData)from).copy();
        }
        return this.copyColumnarArray((ColumnarArrayData)from);
    }

    public ArrayData copy(ArrayData from, ArrayData reuse) {
        return this.copy(from);
    }

    private GenericArrayData copyGenericArray(GenericArrayData array) {
        if (array.isPrimitiveArray()) {
            switch (this.eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return new GenericArrayData(Arrays.copyOf(array.toBooleanArray(), array.size()));
                }
                case TINYINT: {
                    return new GenericArrayData(Arrays.copyOf(array.toByteArray(), array.size()));
                }
                case SMALLINT: {
                    return new GenericArrayData(Arrays.copyOf(array.toShortArray(), array.size()));
                }
                case INTEGER: {
                    return new GenericArrayData(Arrays.copyOf(array.toIntArray(), array.size()));
                }
                case BIGINT: {
                    return new GenericArrayData(Arrays.copyOf(array.toLongArray(), array.size()));
                }
                case FLOAT: {
                    return new GenericArrayData(Arrays.copyOf(array.toFloatArray(), array.size()));
                }
                case DOUBLE: {
                    return new GenericArrayData(Arrays.copyOf(array.toDoubleArray(), array.size()));
                }
            }
            throw new RuntimeException("Unknown type: " + this.eleType);
        }
        Object[] objectArray = array.toObjectArray();
        Object[] newArray = (Object[])Array.newInstance(LogicalTypeUtils.toInternalConversionClass(this.eleType), array.size());
        for (int i = 0; i < array.size(); ++i) {
            newArray[i] = this.eleSer.copy(objectArray[i]);
        }
        return new GenericArrayData(newArray);
    }

    private GenericArrayData copyColumnarArray(ColumnarArrayData from) {
        if (!this.eleType.isNullable()) {
            switch (this.eleType.getTypeRoot()) {
                case BOOLEAN: {
                    return new GenericArrayData(from.toBooleanArray());
                }
                case TINYINT: {
                    return new GenericArrayData(from.toByteArray());
                }
                case SMALLINT: {
                    return new GenericArrayData(from.toShortArray());
                }
                case INTEGER: 
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: {
                    return new GenericArrayData(from.toIntArray());
                }
                case BIGINT: {
                    return new GenericArrayData(from.toLongArray());
                }
                case FLOAT: {
                    return new GenericArrayData(from.toFloatArray());
                }
                case DOUBLE: {
                    return new GenericArrayData(from.toDoubleArray());
                }
            }
        }
        Object[] newArray = new Object[from.size()];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = !from.isNullAt(i) ? this.eleSer.copy(ArrayData.get(from, i, this.eleType)) : null;
        }
        return new GenericArrayData(newArray);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(ArrayData record, DataOutputView target) throws IOException {
        BinaryArrayData binaryArray = this.toBinaryArray(record);
        target.writeInt(binaryArray.getSizeInBytes());
        BinarySegmentUtils.copyToView(binaryArray.getSegments(), binaryArray.getOffset(), binaryArray.getSizeInBytes(), target);
    }

    public BinaryArrayData toBinaryArray(ArrayData from) {
        if (from instanceof BinaryArrayData) {
            return (BinaryArrayData)from;
        }
        int numElements = from.size();
        if (this.reuseArray == null) {
            this.reuseArray = new BinaryArrayData();
        }
        if (this.reuseWriter == null || this.reuseWriter.getNumElements() != numElements) {
            this.reuseWriter = new BinaryArrayWriter(this.reuseArray, numElements, BinaryArrayData.calculateFixLengthPartSize(this.eleType));
        } else {
            this.reuseWriter.reset();
        }
        for (int i = 0; i < numElements; ++i) {
            if (from.isNullAt(i)) {
                this.reuseWriter.setNullAt(i, this.eleType);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, ArrayData.get(from, i, this.eleType), this.eleType, this.eleSer);
        }
        this.reuseWriter.complete();
        return this.reuseArray;
    }

    public ArrayData deserialize(DataInputView source) throws IOException {
        return this.deserializeReuse(new BinaryArrayData(), source);
    }

    public ArrayData deserialize(ArrayData reuse, DataInputView source) throws IOException {
        return this.deserializeReuse(reuse instanceof GenericArrayData ? new BinaryArrayData() : (BinaryArrayData)reuse, source);
    }

    private BinaryArrayData deserializeReuse(BinaryArrayData reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, bytes.length);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArrayDataSerializer that = (ArrayDataSerializer)((Object)o);
        return this.eleType.equals(that.eleType);
    }

    public int hashCode() {
        return this.eleType.hashCode();
    }

    @VisibleForTesting
    public TypeSerializer getEleSer() {
        return this.eleSer;
    }

    public TypeSerializerSnapshot<ArrayData> snapshotConfiguration() {
        return new ArrayDataSerializerSnapshot(this.eleType, this.eleSer);
    }

    public static final class ArrayDataSerializerSnapshot
    implements TypeSerializerSnapshot<ArrayData> {
        private static final int CURRENT_VERSION = 3;
        private LogicalType previousType;
        private TypeSerializer previousEleSer;

        public ArrayDataSerializerSnapshot() {
        }

        ArrayDataSerializerSnapshot(LogicalType eleType, TypeSerializer eleSer) {
            this.previousType = eleType;
            this.previousEleSer = eleSer;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream outStream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousType);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousEleSer);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            try {
                DataInputViewStream inStream = new DataInputViewStream(in);
                this.previousType = (LogicalType)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
                this.previousEleSer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<ArrayData> restoreSerializer() {
            return new ArrayDataSerializer(this.previousType, this.previousEleSer);
        }

        public TypeSerializerSchemaCompatibility<ArrayData> resolveSchemaCompatibility(TypeSerializer<ArrayData> newSerializer) {
            if (!(newSerializer instanceof ArrayDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            ArrayDataSerializer newArrayDataSerializer = (ArrayDataSerializer)newSerializer;
            if (!this.previousType.equals(newArrayDataSerializer.eleType) || !this.previousEleSer.equals((Object)newArrayDataSerializer.eleSer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

