/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.SortedMapTypeInfo;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetractableTopNFunction
extends AbstractTopNFunction {
    private static final long serialVersionUID = 1365312180599454479L;
    private static final Logger LOG = LoggerFactory.getLogger(RetractableTopNFunction.class);
    private static final String STATE_CLEARED_WARN_MSG = "The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.";
    private final RowDataTypeInfo sortKeyType;
    private final boolean lenient = true;
    private transient MapState<RowData, List<RowData>> dataState;
    private transient ValueState<SortedMap<RowData, Long>> treeMap;
    private GeneratedRecordEqualiser generatedEqualiser;
    private RecordEqualiser equaliser;
    private Comparator<RowData> serializableComparator;

    public RetractableTopNFunction(long minRetentionTime, long maxRetentionTime, RowDataTypeInfo inputRowType, GeneratedRecordComparator generatedRecordComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, GeneratedRecordEqualiser generatedEqualiser, boolean generateUpdateBefore, boolean outputRankNumber) {
        super(minRetentionTime, maxRetentionTime, inputRowType, generatedRecordComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
        this.sortKeyType = sortKeySelector.getProducedType();
        this.serializableComparator = new ComparatorWrapper(generatedRecordComparator);
        this.generatedEqualiser = generatedEqualiser;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.equaliser = (RecordEqualiser)this.generatedEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.generatedEqualiser = null;
        ListTypeInfo valueTypeInfo = new ListTypeInfo((TypeInformation)this.inputRowType);
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("data-state", (TypeInformation)this.sortKeyType, (TypeInformation)valueTypeInfo);
        this.dataState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor("sorted-map", new SortedMapTypeInfo((TypeInformation<RowData>)this.sortKeyType, BasicTypeInfo.LONG_TYPE_INFO, this.serializableComparator));
        this.treeMap = this.getRuntimeContext().getState(valueStateDescriptor);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime);
        this.initRankEnd(input);
        TreeMap<RowData, Long> sortedMap = (TreeMap<RowData, Long>)this.treeMap.value();
        if (sortedMap == null) {
            sortedMap = new TreeMap<RowData, Long>(this.sortKeyComparator);
        }
        RowData sortKey = (RowData)this.sortKeySelector.getKey((Object)input);
        boolean isAccumulate = RowDataUtil.isAccumulateMsg(input);
        input.setRowKind(RowKind.INSERT);
        if (isAccumulate) {
            if (sortedMap.containsKey(sortKey)) {
                sortedMap.put(sortKey, (Long)sortedMap.get(sortKey) + 1L);
            } else {
                sortedMap.put(sortKey, 1L);
            }
            if (this.outputRankNumber || this.hasOffset()) {
                this.emitRecordsWithRowNumber(sortedMap, sortKey, input, out);
            } else {
                this.emitRecordsWithoutRowNumber(sortedMap, sortKey, input, out);
            }
            ArrayList<RowData> inputs = (ArrayList<RowData>)this.dataState.get((Object)sortKey);
            if (inputs == null) {
                inputs = new ArrayList<RowData>();
            }
            inputs.add(input);
            this.dataState.put((Object)sortKey, inputs);
        } else {
            if (this.outputRankNumber || this.hasOffset()) {
                this.retractRecordWithRowNumber(sortedMap, sortKey, input, out);
            } else {
                this.retractRecordWithoutRowNumber(sortedMap, sortKey, input, out);
            }
            if (sortedMap.containsKey(sortKey)) {
                long count = (Long)sortedMap.get(sortKey) - 1L;
                if (count == 0L) {
                    sortedMap.remove(sortKey);
                } else {
                    sortedMap.put(sortKey, count);
                }
            } else if (sortedMap.isEmpty()) {
                LOG.warn(STATE_CLEARED_WARN_MSG);
            } else {
                throw new RuntimeException("Can not retract a non-existent record. This should never happen.");
            }
        }
        this.treeMap.update(sortedMap);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.dataState, this.treeMap});
        }
    }

    private void emitRecordsWithRowNumber(SortedMap<RowData, Long> sortedMap, RowData sortKey, RowData inputRow, Collector<RowData> out) throws Exception {
        Iterator<Map.Entry<RowData, Long>> iterator = sortedMap.entrySet().iterator();
        long currentRank = 0L;
        RowData currentRow = null;
        boolean findsSortKey = false;
        while (iterator.hasNext() && this.isInRankEnd(currentRank)) {
            Map.Entry<RowData, Long> entry = iterator.next();
            RowData key = entry.getKey();
            if (!findsSortKey && key.equals(sortKey)) {
                currentRank += entry.getValue().longValue();
                currentRow = inputRow;
                findsSortKey = true;
                continue;
            }
            if (findsSortKey) {
                List inputs = (List)this.dataState.get((Object)key);
                if (inputs == null) {
                    LOG.warn(STATE_CLEARED_WARN_MSG);
                    continue;
                }
                for (int i = 0; i < inputs.size() && this.isInRankEnd(currentRank); ++i) {
                    RowData prevRow = (RowData)inputs.get(i);
                    this.collectUpdateBefore(out, prevRow, currentRank);
                    this.collectUpdateAfter(out, currentRow, currentRank);
                    currentRow = prevRow;
                    ++currentRank;
                }
                continue;
            }
            currentRank += entry.getValue().longValue();
        }
        if (this.isInRankEnd(currentRank)) {
            this.collectInsert(out, currentRow, currentRank);
        }
    }

    private void emitRecordsWithoutRowNumber(SortedMap<RowData, Long> sortedMap, RowData sortKey, RowData inputRow, Collector<RowData> out) throws Exception {
        Iterator<Map.Entry<RowData, Long>> iterator = sortedMap.entrySet().iterator();
        long curRank = 0L;
        boolean findsSortKey = false;
        RowData toCollect = null;
        RowData toDelete = null;
        while (iterator.hasNext() && this.isInRankEnd(curRank)) {
            Map.Entry<RowData, Long> entry = iterator.next();
            RowData key = entry.getKey();
            if (!findsSortKey && key.equals(sortKey)) {
                if (this.isInRankRange(curRank += entry.getValue().longValue())) {
                    toCollect = inputRow;
                }
                findsSortKey = true;
                continue;
            }
            if (findsSortKey) {
                List inputs = (List)this.dataState.get((Object)key);
                if (inputs == null) {
                    LOG.warn(STATE_CLEARED_WARN_MSG);
                    continue;
                }
                long count = entry.getValue();
                long rankOfLastRecord = curRank + count;
                if (this.isInRankEnd(rankOfLastRecord)) {
                    curRank = rankOfLastRecord;
                    continue;
                }
                int index = Long.valueOf(this.rankEnd - curRank).intValue();
                toDelete = (RowData)inputs.get(index);
                break;
            }
            curRank += entry.getValue().longValue();
        }
        if (toDelete != null) {
            this.collectDelete(out, toDelete);
        }
        if (toCollect != null) {
            this.collectInsert(out, inputRow);
        }
    }

    private void retractRecordWithRowNumber(SortedMap<RowData, Long> sortedMap, RowData sortKey, RowData inputRow, Collector<RowData> out) throws Exception {
        Iterator<Map.Entry<RowData, Long>> iterator = sortedMap.entrySet().iterator();
        long currentRank = 0L;
        RowData prevRow = null;
        boolean findsSortKey = false;
        while (iterator.hasNext() && this.isInRankEnd(currentRank)) {
            RowData currentRow;
            List inputs;
            Map.Entry<RowData, Long> entry = iterator.next();
            RowData key = entry.getKey();
            if (!findsSortKey && key.equals(sortKey)) {
                inputs = (List)this.dataState.get((Object)key);
                if (inputs == null) {
                    LOG.warn(STATE_CLEARED_WARN_MSG);
                    continue;
                }
                Iterator inputIter = inputs.iterator();
                while (inputIter.hasNext() && this.isInRankEnd(currentRank)) {
                    currentRow = (RowData)inputIter.next();
                    if (!findsSortKey && this.equaliser.equals(currentRow, inputRow)) {
                        prevRow = currentRow;
                        findsSortKey = true;
                        inputIter.remove();
                    } else if (findsSortKey) {
                        this.collectUpdateBefore(out, prevRow, currentRank);
                        this.collectUpdateAfter(out, currentRow, currentRank);
                        prevRow = currentRow;
                    }
                    ++currentRank;
                }
                if (inputs.isEmpty()) {
                    this.dataState.remove((Object)key);
                    continue;
                }
                this.dataState.put((Object)key, (Object)inputs);
                continue;
            }
            if (findsSortKey) {
                inputs = (List)this.dataState.get((Object)key);
                for (int i = 0; i < inputs.size() && this.isInRankEnd(currentRank); ++i) {
                    currentRow = (RowData)inputs.get(i);
                    this.collectUpdateBefore(out, prevRow, currentRank);
                    this.collectUpdateAfter(out, currentRow, currentRank);
                    prevRow = currentRow;
                    ++currentRank;
                }
                continue;
            }
            currentRank += entry.getValue().longValue();
        }
        if (this.isInRankEnd(currentRank)) {
            this.collectDelete(out, prevRow, currentRank);
        }
    }

    private void retractRecordWithoutRowNumber(SortedMap<RowData, Long> sortedMap, RowData sortKey, RowData inputRow, Collector<RowData> out) throws Exception {
        Iterator<Map.Entry<RowData, Long>> iterator = sortedMap.entrySet().iterator();
        long curRank = 0L;
        boolean findsSortKey = false;
        while (iterator.hasNext() && this.isInRankEnd(curRank)) {
            Map.Entry<RowData, Long> entry = iterator.next();
            RowData key = entry.getKey();
            if (!findsSortKey && key.equals(sortKey)) {
                List inputs = (List)this.dataState.get((Object)key);
                if (inputs == null) {
                    LOG.warn(STATE_CLEARED_WARN_MSG);
                    continue;
                }
                Iterator inputIter = inputs.iterator();
                while (inputIter.hasNext() && this.isInRankEnd(curRank)) {
                    ++curRank;
                    RowData prevRow = (RowData)inputIter.next();
                    if (!findsSortKey && this.equaliser.equals(prevRow, inputRow)) {
                        this.collectDelete(out, prevRow, curRank);
                        --curRank;
                        findsSortKey = true;
                        inputIter.remove();
                        continue;
                    }
                    if (!findsSortKey || curRank != this.rankEnd) continue;
                    this.collectInsert(out, prevRow, curRank);
                    break;
                }
                if (inputs.isEmpty()) {
                    this.dataState.remove((Object)key);
                    continue;
                }
                this.dataState.put((Object)key, (Object)inputs);
                continue;
            }
            if (findsSortKey) {
                long count = entry.getValue();
                long rankOfLastRecord = curRank + count;
                if (rankOfLastRecord < this.rankEnd) {
                    curRank = rankOfLastRecord;
                    continue;
                }
                int index = Long.valueOf(this.rankEnd - curRank - 1L).intValue();
                List inputs = (List)this.dataState.get((Object)key);
                RowData toAdd = (RowData)inputs.get(index);
                this.collectInsert(out, toAdd);
                break;
            }
            curRank += entry.getValue().longValue();
        }
    }

    private static class ComparatorWrapper
    implements Comparator<RowData>,
    Serializable {
        private static final long serialVersionUID = 4386377835781068140L;
        private transient Comparator<RowData> comparator;
        private GeneratedRecordComparator generatedRecordComparator;

        private ComparatorWrapper(GeneratedRecordComparator generatedRecordComparator) {
            this.generatedRecordComparator = generatedRecordComparator;
        }

        @Override
        public int compare(RowData o1, RowData o2) {
            if (this.comparator == null) {
                this.comparator = (Comparator)this.generatedRecordComparator.newInstance(Thread.currentThread().getContextClassLoader());
            }
            return this.comparator.compare(o1, o2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ComparatorWrapper) {
                ComparatorWrapper o = (ComparatorWrapper)obj;
                GeneratedRecordComparator oGeneratedComparator = o.generatedRecordComparator;
                return this.generatedRecordComparator.getClassName().equals(oGeneratedComparator.getClassName()) && this.generatedRecordComparator.getCode().equals(oGeneratedComparator.getCode()) && Arrays.equals(this.generatedRecordComparator.getReferences(), oGeneratedComparator.getReferences());
            }
            return false;
        }
    }
}

