/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.JoinedRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class ProcTimeUnboundedPrecedingFunction<K>
extends KeyedProcessFunctionWithCleanupState<K, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private transient AggsHandleFunction function;
    private transient ValueState<RowData> accState;
    private transient JoinedRowData output;

    public ProcTimeUnboundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes) {
        super(minRetentionTime, maxRetentionTime);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
    }

    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        RowDataTypeInfo accTypeInfo = new RowDataTypeInfo(this.accTypes);
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = this.getRuntimeContext().getState(stateDescriptor);
        this.initCleanupTimeState("ProcTimeUnboundedOverCleanupTime");
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        RowData accumulators = (RowData)this.accState.value();
        if (null == accumulators) {
            accumulators = this.function.createAccumulators();
        }
        this.function.setAccumulators(accumulators);
        this.function.accumulate(input);
        accumulators = this.function.getAccumulators();
        this.accState.update((Object)accumulators);
        RowData aggValue = this.function.getValue();
        this.output.replace(input, aggValue);
        out.collect((Object)this.output);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.accState});
            this.function.cleanup();
        }
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

